@extends('layout.master')

@section('title')
    Cash-Book-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Cash book</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
         <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <button id="printButton" class="btn btn-primary me-3">
                <i class="fas fa-print"></i> Print
            </button>
        </div>


        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <div class="custom">
            <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport"
                style="display: none; width:100%">
                <thead>
                    <tr>
                        <th>Voucher No</th>
                        <th>Cheque # & Date</th>
                        <th>Account #</th>
                        <th>Account Title</th>
                        <th>Particular</th>
                        @foreach ($accounts as $accountId)
                            {{-- Check if the account has transactions before rendering the column --}}
                            @if (isset($transactions[$accountId]) && $transactions[$accountId]->isNotEmpty())
                                <th>{{ $transactions[$accountId][0]->account_name ?? 'Account ' . $accountId }}</th>
                            @endif
                        @endforeach
                    </tr>
                </thead>
                <tbody>
                    @foreach ($transactions as $accountId => $accountTransactions)
                        @foreach ($accountTransactions as $transaction)
                            <tr>
                                <td>{{ $transaction->voucher_no }}</td>
                                <td>{{ $transaction->cheque_number }} & {{ $transaction->transaction_date }}</td>
                                <td>{{ $transaction->account_code }}</td>
                                <td>{{ $transaction->account_title }}</td>
                                <td>{{ $transaction->narration }}</td>

                                {{-- Loop through the accounts and display the respective amount --}}
                                @foreach ($accounts as $accountId)
                                    {{-- Only display the column if there are transactions for this account --}}
                                    @if (isset($transactions[$accountId]) && $transactions[$accountId]->isNotEmpty())
                                        <td>
                                            {{-- Only display the amount for the account if the account matches --}}
                                            @if ($transaction->account_name == $transactions[$accountId][0]->account_name)
                                                {{ $transaction->amount }}
                                            @endif
                                        </td>
                                    @endif
                                @endforeach
                            </tr>
                        @endforeach
                    @endforeach
                </tbody>
            </table>
        </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>


    <script>
        $(document).ready(function() {
            // Check if DataTable library is loaded
            if ($.fn.dataTable) {
                // Initialize the DataTable
                $('#jobBalancingReport').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                            extend: 'excelHtml5',
                            text: 'Export to Excel',
                            title: 'Cash Book',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            }
                        },
                    ],
                    "ordering": false,
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#jobBalancingReport').show();
                    }
                });
            }
        });
    </script>
    <script>
        document.getElementById("printButton").addEventListener("click", function() {
            var table = $('#jobBalancingReport').DataTable();
            table.page.len(-1).draw(); // Disable pagination by setting length to -1 (show all rows)
            // var printContents = document.querySelector(".custom").innerHTML;
            var printContents = document.querySelector(".custom table").outerHTML;

            var originalContents = document.body.innerHTML;

            document.body.innerHTML = `
                <html>
                    <head>
                        <title>Cash Book Report - YARAN</title>
                        <style>
                            html {
                                background-color: white;
                            }
                            body {
                                font-family: Arial, sans-serif;
                                background-color: white;
                            }
                            table {
                                width: 100%;
                                background-color: white;
                                border-collapse: collapse;
                                margin-bottom: 20px;
                            }
                            th, td {
                                border: 1px solid #ddd;
                                padding: 8px;
                                text-align: left;
                            }
                            th {
                                background-color: #f2f2f2;
                            }
                            h1 {
                                text-align: center;
                            }
                        </style>
                    </head>
                    <body>
                        <div style="display: flex; flex-wrap: wrap; align-items: center; margin-top: 2rem; text-align: center; margin-bottom: 10px;">
                            <div style="flex-grow: 1;">
                                <h2 style="font-size: 20px !important; font-weight: bold; text-align: center; text-transform: uppercase;">
                                    Cash Book Report
                                </h2>
                        </div>
                        <div style="margin-top: 10px">
                            ${printContents}
                        </div>
                    </body>
                </html>
            `;

            window.print();
            document.body.innerHTML = originalContents;
            location.reload(); // Reload to restore the original content
        });
    </script>
@endsection
