@extends('layout.master')

@section('title')
    Cash Flow Report-YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts/cash-flow') }}" class="breadcrumb-item"> Cash Flow Report</a><i data-feather="chevron-right"
        class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Filters</a>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/accounts/cash-flow') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Cash Flow Report
                        </h2>

                        <button type="submit" class="btn btn-primary" id="submitBtn">Generate Report</button>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-4">
                                    <label for="date_from">Date From</label>
                                    <input type="date" value="{{ $date_from }}" name="date_from" id="date_from"
                                        class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label for="date_to">Date To</label>
                                    <input type="date" value="{{ $date_to }}" name="date_to" id="date_to"
                                        class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label> Account</label>
                                    <select data-placeholder="Select Account" id="parent_account_id" name="account_id"
                                        class="tom-select w-full">
                                        <option value="">Please Select Account</option>
                                        @foreach ($parent_accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2 ">
                                    <label>Company</label>
                                    <select data-placeholder="Select Company" id="company" name="company"
                                        class="tom-select w-full mt-2">
                                        <option value="1" {{ request('company') == 1 ? 'selected' : '' }}>YARAN
                                            SHIPPING LINE</option>
                                    </select>
                                </div>

                                {{-- <div class="col-md-4 mt-2">
                                    <label>Currency</label>
                                    <select data-placeholder="Select Currency" id="currency_id" name="currency_id"
                                        class="tom-select w-full mt-2">
                                        <option value="">Please Select Currency</option>
                                        @foreach ($currencies as $index => $currency)
                                            <option value="{{ $currency->id }}" {{ $index == 0 ? 'selected' : '' }}>
                                                {{ $currency->name }}</option>
                                        @endforeach
                                    </select>
                                </div> --}}
                                {{-- <div class="col-md-4 mt-2">
                                    <label>Report Currency</label>
                                    <select data-placeholder="Select Report Currency" id="Report_currency_id"
                                        name="report_currency_id" class="tom-select w-full">
                                        <option value="">Please Select Report Currency</option>
                                        @foreach ($currencies as $currency)
                                            <option value="{{ $currency->id }}">{{ $currency->name }}</option>
                                        @endforeach
                                    </select>
                                </div> --}}


                                <div class="col-md-4 mt-2">
                                    <label for="cost_center">Cost Center</label>
                                    <div class="d-flex align-items-center">
                                        <select data-placeholder="Select Cost Center" id="cost_center" name="cost_center"
                                            class="tom-select w-full mt-2">
                                            <option value=""></option>
                                            <option {{ request('cost_center') == 'Head Office' ? 'selected' : '' }}
                                                value="Head Office">Head Office</option>
                                        </select>
                                    </div>
                                </div>
                                {{-- <div class="col-md-4 mt-2">
                                    <label for="account_level">Account level</label>
                                    <div class="d-flex align-items-center">
                                        <select data-placeholder="Select account level" id="cost_center"
                                            name="account_level" class="tom-select w-full mt-2">
                                            <option value=""></option>
                                            <option {{ request('account_level') == 'Parent' ? 'selected' : '' }}
                                                value="Parent">Parent</option>
                                            <option {{ request('account_level') == 'Detail' ? 'selected' : '' }}
                                                value="Detail">Detail</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="exchange_rate">Exchange Rate</label>
                                    <div class="input-group mt-2">
                                        <input type="number" id="exchange_rate" name="exchange_rate" class="form-control"
                                            placeholder="Enter exchange rate (e.g., 1.23)" step="0.01" min="0"
                                            value="{{ old('exchange_rate', request('exchange_rate')) }}">
                                    </div>
                                </div> --}}
                            </div>



                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script>
        document.getElementById('myForm').addEventListener('submit', function(e) {
            const accountId = document.getElementById('parent_account_id').value;

            if (!accountId) {
                e.preventDefault();
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: "Please select an account",
                    showConfirmButton: false,
                    timer: 2500
                });
            }
        });
    </script>
@endsection
