@extends('layout.master')

@section('title')
    Cash-Flow-Report-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Cash Flow Report</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold;">
                    Opening Balance : {{ $openingBalance }}
                </h2>
            </div>
            <button id="printButton" class="btn btn-primary me-3">
                <i class="fas fa-print"></i> Print
            </button>
        </div>
        @php
            $balance = $openingBalance; // Reset balance before calculations
            $totalAmountIn = 0;
            $totalAmountOut = 0;
        @endphp

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <h3 class="font-medium text-center font-bold">
                Cash Flow Report (Cash In and Cash Out)
            </h3>
            <div class="custom">
                <table class="table table-bordered mt-n2 display nowrap" id="cashFlowTable"
                    style="display: none; width:100%">
                    <thead>
                        <tr>
                            <th>Transaction Type</th>
                            <th>Account Debit</th>
                            <th>Account Credit</th>
                            <th>Account Debit Parent</th>
                            <th>Account Credit Parent</th>
                            <th>Amount In</th>
                            <th>Amount Out</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $balance = $openingBalance;
                            $totalAmountIn = 0;
                            $totalAmountOut = 0;
                        @endphp

                        @foreach ($accountIn as $transaction)
                            <tr>
                                <td>Cash In</td>
                                <td>{{ $transaction->AccountDebit }}</td>
                                <td>{{ $transaction->AccountCredit }}</td>
                                <td></td>
                                <td>{{ $transaction->AccountCreditParent }}</td>
                                <td>{{ $transaction->AmountIn }}</td>
                                <td></td>
                            </tr>
                            @php
                                $totalAmountIn += $transaction->AmountIn ?? 0;
                                $balance += $transaction->AmountIn ?? 0;
                            @endphp
                        @endforeach

                        @foreach ($accountOut as $transaction)
                            <tr>
                                <td>Cash Out</td>
                                <td>{{ $transaction->AccountDebit }}</td>
                                <td>{{ $transaction->AccountCredit }}</td>
                                <td>{{ $transaction->AccountDebitParent }}</td>
                                <td></td>
                                <td></td>
                                <td>{{ $transaction->AmountOut }}</td>
                            </tr>
                            @php
                                $totalAmountOut += $transaction->AmountOut ?? 0;
                                $balance -= $transaction->AmountOut ?? 0;
                            @endphp
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="5">Total</th>
                            <th>{{ $totalAmountIn }}</th>
                            <th>{{ $totalAmountOut }}</th>
                        </tr>
                        <tr>
                            <th colspan="5">Balance at End of Period</th>
                            <th colspan="2">{{ $balance }}</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>


    <script>
        $(document).ready(function() {
            if ($.fn.dataTable) {
                $('#cashFlowTable').DataTable({
                    dom: 'Bfrtip',
                    buttons: [{
                        extend: 'excelHtml5',
                        text: 'Export to Excel',
                        title: 'Cash Flow Report',
                        exportOptions: {
                            columns: ':visible'
                        }
                    }],
                    initComplete: function() {
                        $('#cashFlowTable').show();
                    }
                });
            }
        });
    </script>
    <script>
        document.getElementById("printButton").addEventListener("click", function() {
            var table = $('#cashFlowTable').DataTable();
            table.page.len(-1).draw(); // Disable pagination by setting length to -1 (show all rows)
            // var printContents = document.querySelector(".custom").innerHTML;
            var printContents = document.querySelector(".custom table").outerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = `
                <html>
                    <head>
                        <title>Cash Flow Report - YARAN</title>
                        <style>
                            html {
                                background-color: white;
                            }
                            body {
                                font-family: Arial, sans-serif;
                                background-color: white;
                            }
                            table {
                                width: 100%;
                                border-collapse: collapse;
                                margin-bottom: 20px;
                            }
                            th, td {
                                border: 1px solid #ddd;
                                padding: 8px;
                                text-align: left;
                            }
                            th {
                                background-color: #f2f2f2;
                            }
                            h1 {
                                text-align: center;
                            }
                        </style>
                    </head>
                    <body>
                        <div style="display: flex; flex-wrap: wrap; align-items: center; margin-top: 2rem; text-align: center; margin-bottom: 10px;">
                            <div style="flex-grow: 1;">
                                <h2 style="font-size: 20px !important; font-weight: bold; text-align: center; text-transform: uppercase;">
                                    Cash Flow Report
                                </h2>
                        </div>
                        <div style="margin-top: 10px">
                            ${printContents}
                        </div>
                    </body>
                </html>
            `;

            window.print();
            document.body.innerHTML = originalContents;
            location.reload(); // Reload to restore the original content
        });
    </script>
@endsection
