@extends('layout.master')

@section('title')
    Chart-of-Account-List-YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts/chart-of-account-list') }}" class="breadcrumb-item">Chart Of Account List</a><i
        data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Filters</a>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/accounts/chart-of-account-list') }}"
                enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Chart Of Account List
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Generate Report</button>
                        {{-- <a href="{{ url('/accounts/chart_of_account') }}" type="back"
                            class="btn btn-secondary waves-effect">
                            Back
                        </a> --}}
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="col-md-6 mt-2">
                                    <label> Account</label>
                                    <div class="d-flex mt-2">
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="account" id="all_acount"
                                                value="all_acount" {{ old('account') == 'all_acount' ? 'checked' : '' }}
                                                checked onchange="toggleInputFields()">
                                            <label class="form-check-label" for="all_acount">All Account</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="account"
                                                id="particular_parent" value="particular_parent"
                                                {{ old('account') == 'particular_parent' ? 'checked' : '' }}
                                                onchange="toggleInputFields()">
                                            <label class="form-check-label" for="particular_parent">Particular
                                                Parent</label>
                                        </div>
                                    </div>

                                    <select id="parent_account_id" name="parent_account_id" class="select2 w-full" disabled>
                                        <option value=""></option>
                                        @foreach ($parent_accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-6 mt-2 ">
                                    <label>Company</label>
                                    <div class="d-flex mt-2">
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="company" id="all_company"
                                                value="all_company" {{ old('company') == 'all_company' ? 'checked' : '' }}
                                                checked onchange="toggleInputCompany()">
                                            <label class="form-check-label" for="all_company">All Company</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="company"
                                                id="particular_company" value="particular_company"
                                                {{ old('company') == 'particular_company' ? 'checked' : '' }}
                                                onchange="toggleInputCompany()">
                                            <label class="form-check-label" for="particular_company">Particular
                                                Company</label>
                                        </div>
                                    </div>
                                    <select id="company_id" name="company_id" class="select2 w-full " disabled>
                                        <option value=""></option>
                                        <option value="1" {{ request('company') == 1 ? 'selected' : '' }}>YARAN
                                            SHIPPING LINE</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mt-4">
                                    <label>Category</label>
                                    <select data-placeholder="Select category" id="category_id" name="category_id"
                                        class="tom-select w-full">
                                        <option value="">Please Select category</option>
                                        @foreach ($category as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4 mt-4">
                                    <label>Sub Category</label>
                                    <select data-placeholder="Select sub category" id="sub_category_id"
                                        name="sub_category_id" class="tom-select w-full">
                                        <option value="">Please Select Parent Account</option>
                                        @foreach ($sub_category as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4 mt-6">
                                    <label>Order By</label>
                                    <div class="d-flex mt-2">
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="order_by" id="account_code"
                                                value="account_code"
                                                {{ old('order_by') == 'account_code' ? 'checked' : '' }} checked>
                                            <label class="form-check-label" for="account_code">Account Code</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="order_by"
                                                id="account_name" value="account_name"
                                                {{ old('order_by') == 'account_name' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="account_name">Account Name</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        function toggleInputFields() {
            const selectedAccount = document.querySelector('input[name="account"]:checked').value;
            const parentAccountSelect = document.getElementById('parent_account_id');
            if (selectedAccount === 'all_acount') {
                parentAccountSelect.disabled = true;
            } else {
                parentAccountSelect.disabled = false;
            }
        }

        function toggleInputCompany() {
            const selectedCompany = document.querySelector('input[name="company"]:checked').value;
            const parentCompanySelect = document.getElementById('company_id');
            if (selectedCompany === 'all_company') {
                parentCompanySelect.disabled = true;
            } else {
                parentCompanySelect.disabled = false;
            }
        }
    </script>
@endsection
