@extends('layout.master')

@section('title')
    Chart-of-Account-List-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Chart of Account List</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <button id="printButton" class="btn btn-primary me-3">
                <i class="fas fa-print"></i> Print
            </button>
        </div>


        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <div class="custom">
                <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport"
                    style="display: none; width:100%">
                    <thead>
                        <tr>
                            <th>Account No</th>
                            <th>Account Title</th>
                            <th>Type</th>
                            <th>Catogary</th>
                            <th>Sub Category</th>

                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($accounts as $account)
                            <tr>
                                <td>{{ @$account->account_code }}</td>
                                <td>{{ @$account->name }}</td>
                                <td>
                                    @if ($accounts->where('parent_account_id', $account->id)->isEmpty())
                                        Detail
                                    @else
                                        Group
                                    @endif
                                </td>
                                <td>{{ @$account->account_category->name }}</td>
                                <td>{{ @$account->account_sub_category->name }}</td>
                            </tr>
                        @endforeach
                    </tbody>

                </table>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>


    <script>
        $(document).ready(function() {
            // Check if DataTable library is loaded
            if ($.fn.dataTable) {
                // Initialize the DataTable
                $('#jobBalancingReport').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                        extend: 'excelHtml5',
                        text: 'Export to Excel',
                        title: 'Chart of Account List',
                        exportOptions: {
                            columns: ':visible' // Export only visible columns
                        }
                    }, ],
                    "ordering": false,
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#jobBalancingReport').show();
                    }
                });
            }
        });
    </script>
    <script>
        document.getElementById("printButton").addEventListener("click", function() {
            // Temporarily disable DataTables pagination
            var table = $('#jobBalancingReport').DataTable();
            table.page.len(-1).draw(); // Disable pagination by setting length to -1 (show all rows)

            // Access the full table content (all rows) for printing
            var printContents = document.querySelector(".custom table").outerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = `
            <html>
                <head>
                    <title>Chart of Account List Report - YARAN</title>
                    <style>
                        html {
                                background-color: white;
                            }
                        body {
                            font-family: Arial, sans-serif;
                            background-color: white;
                        }
                        table {
                            width: 100%;
                            border-collapse: collapse;
                            margin-bottom: 20px;
                        }
                        th, td {
                            border: 1px solid #ddd;
                            padding: 8px;
                            text-align: left;
                        }
                        th {
                            background-color: #f2f2f2;
                        }
                        h1 {
                            text-align: center;
                        }
                    </style>
                </head>
                <body>
                    <div style="display: flex; flex-wrap: wrap; align-items: center; margin-top: 2rem; text-align: center; margin-bottom: 10px;">
                        <div style="flex-grow: 1;">
                            <h2 style="font-size: 20px !important; font-weight: bold; text-align: center; text-transform: uppercase;">
                                Chart of Account List Report
                            </h2>
                        </div>
                    </div>
                    <div style="margin-top: 10px">
                        ${printContents}  <!-- Insert the entire table content here -->
                    </div>
                </body>
            </html>
        `;

            // Trigger the print action
            window.print();

            // After printing, restore the original content and re-enable pagination
            document.body.innerHTML = originalContents;
            location.reload(); // Reload to restore DataTable features
        });
    </script>
@endsection
