@extends('layout.master')

@section('title')
    Cheque-printing-YARAN
@endsection

@section('topbar')
    <a href="{{ url('/accounts/cheque-printing') }}" class="breadcrumb-item">Cheque Printing Report</a><i
        data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Filters</a>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/accounts/cheque-printing') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Cheque Printing Report
                        </h2>

                        <button type="submit" class="btn btn-primary" id="submitBtn">Generate Report</button>
                        {{-- <a href="{{ url('/accounts/chart_of_account') }}" type="back"
                            class="btn btn-secondary waves-effect">
                            Back
                        </a> --}}
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-4">
                                    <label for="date_from">Date From</label>
                                    <input type="date" value="{{ $date_from }}" name="date_from" id="date_from"
                                        class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label for="date_to">Date To</label>
                                    <input type="date" value="{{ $date_to }}" name="date_to" id="date_to"
                                        class="form-control">
                                </div>
                                <div class="col-md-4">
                                    <label>Voucher No</label>
                                    <select data-placeholder="Select Voucher No" id="voucher_no" name="voucher_no"
                                        class="select2 w-full">
                                        <option value="">Please Select Voucher</option>
                                        @foreach ($transaction_masters as $transaction_master)
                                            <option value="{{ $transaction_master->id }}">
                                                {{ $transaction_master->voucher_no }}</option>
                                        @endforeach
                                    </select>
                                </div>



                                <div class="col-md-4 mt-2 ">
                                    <label>Company</label>
                                    <select data-placeholder="Select Company" id="company" name="company"
                                        class="tom-select w-full ">
                                        <option value="1" {{ request('company') == 1 ? 'selected' : '' }}>YARAN
                                            SHIPPING LINE</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label for="voucher_date">Voucher Date</label>
                                    <input type="date" value="{{ \Carbon\Carbon::now()->format('Y-m-d') }}"
                                        name="voucher_date" id="voucher_date" class="form-control" readonly>
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label for="cheque_date">Cheque Date</label>
                                    <input type="date" value="{{ \Carbon\Carbon::now()->format('Y-m-d') }}"
                                        name="cheque_date" id="cheque_date" class="form-control" readonly>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label>Bank</label>
                                    <input type="text" name="bank" id="bank" class="form-control" readonly>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="amount">Amount</label>
                                    <div>
                                        <input type="text" id="amount" class="form-control"
                                            placeholder="Please Enter Amount" name="amount" readonly>
                                    </div>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="pay_to">Pay To</label>
                                    <div>
                                        <input type="text" id="pay_to" class="form-control"
                                            placeholder="Please Enter pay to" name="pay_to" readonly>
                                    </div>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="Cheque_no">Cheque No</label>
                                    <div>
                                        <input type="text" class="form-control" placeholder="Please Enter cheque"
                                            name="Cheque_no" readonly>
                                    </div>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="bank_code">Bank code</label>
                                    <div>
                                        <input type="text" id="bank_code" class="form-control"
                                            placeholder="Please Enter Bank code" name="bank_code" readonly>
                                    </div>
                                </div>
                                {{-- <div class="col-md-4 mt-2 ">
                                    <label>Payment Template</label>
                                    <select data-placeholder="Select Payment Template" id="Payment_Template"
                                        name="Payment_Template" class="tom-select w-full ">
                                        <option></option>
                                    </select>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="RemittanceType">RemittanceType :</label>
                                    <div>
                                        <input type="text" class="form-control"
                                            placeholder="Please Enter Remittance Type" name="Remittance_Type">
                                    </div>
                                </div> --}}
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {

        $('#voucher_no').on('change', function() {
            var voucherId = $(this).val();

            if (voucherId) {
                $.ajax({
                    url: '/api/get-transaction-master/' + voucherId,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        // Update the form fields with the received data
                        $('#voucher_date').val(data.date || '');
                        $('#cheque_date').val(data.cheque_date || '');
                        $('#cheque_no').val(data.cheque_number || '');
                        $('#amount').val(data.total_debit || '');
                        $('#pay_to').val(data.chart_of_accounts ? data.chart_of_accounts
                            .name : '');
                        $('#bank').val(data.chart_of_account ? data.chart_of_account.name :
                            '');
                        $('#bank_code').val(data.chart_of_account ? data.chart_of_account
                            .account_code : '');
                    },
                    error: function(xhr, status, error) {
                        alert('Error: ' + xhr.responseJSON.message);
                        // Clear all fields in case of an error
                        $('#voucher_date').val('');
                        $('#cheque_date').val('');
                        $('#cheque_no').val('');
                        $('#amount').val('');
                        $('#pay_to').val('');
                        $('#bank').val('');
                        $('#bank_code').val('');
                    }
                });
            } else {
                // Clear all fields if no voucher is selected
                $('#voucher_date').val('');
                $('#cheque_date').val('');
                $('#cheque_no').val('');
                $('#amount').val('');
                $('#pay_to').val('');
                $('#bank').val('');
                $('#bank_code').val('');
            }
        });

        $('#myForm').on('submit', function(e) {
            const voucherNo = $('#voucher_no').val();

            if (!voucherNo) {
                e.preventDefault();
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: "Please select Voucher",
                    showConfirmButton: false,
                    timer: 2500
                });
            }
        });
    });
</script>
