@extends('layout.master')
<style>
    .underline-label {
        position: relative;
        display: inline-block;
    }

    .underline-label::after {
        content: "";
        position: absolute;
        bottom: -2px;
        /* Adjust as needed to position the underline */
        left: 0;
        width: calc(100% + 20px);
        /* Extends the underline slightly */
        height: 2px;
        /* Thickness of the underline */
        background-color: #000;
        /* Color of the underline */
    }
</style>
@section('title')
    Cheque-Printing-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Cheque Printing</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        @if ($transaction_master)
            <div class="intro-y g-col-12">
                <div class="p-3">
                    <div class="mt-2 d-flex align-items-center" style="justify-content: space-between">
                        @if (optional($transaction_master->chart_of_accounts)->name)
                            <label for="regular-form-1" class="form-label underline-label">
                                {{ $transaction_master->chart_of_accounts->name }}
                            </label>
                        @endif

                        @if ($transaction_master->date)
                            <label for="regular-form-1" class="form-label underline-label">
                                {{ \Carbon\Carbon::parse($transaction_master->date)->format('d-M-Y') }}
                            </label>
                        @endif
                    </div>

                    <div class="mt-2 d-flex align-items-center" style="justify-content: space-between">
                        @if ($transaction_master->total_debit)
                            <label for="regular-form-1" class="form-label underline-label">
                                {{ ucwords(\App\Helpers\NumberToWords::convert($transaction_master->total_debit)) }}
                            </label>
                        @endif

                        @if ($transaction_master->total_debit)
                            <label for="regular-form-1" class="form-label underline-label">
                                {{ number_format($transaction_master->total_debit, 2) }}
                            </label>
                        @endif
                    </div>
                </div>
            </div>


            <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
                <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport"
                    style="display: none; width:100%">
                    <thead>
                        <tr>
                            <th>Code</th>
                            <th>Narration</th>
                            <th>Debit</th>
                            <th>Credit</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if ($transaction_master->detail)
                            @foreach ($transaction_master->detail as $transaction_detail)
                                <tr>
                                    <td>{{ $transaction_detail->account->account_code }}</td>
                                    <td>{{ $transaction_detail->narration }}</td>
                                    <td>{{ $transaction_detail->debit_lc }}</td>
                                    <td>{{ $transaction_detail->credit_lc }}</td>
                                </tr>
                            @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
        @else
            <div class="intro-y g-col-12 text-center">
                <label class="form-label">No data available for the selected date range.</label>
            </div>
        @endif
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>


    <script>
        $(document).ready(function() {
            // Check if DataTable library is loaded
            if ($.fn.dataTable) {
                // Initialize the DataTable
                $('#jobBalancingReport').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                            extend: 'excelHtml5',
                            text: 'Export to Excel',
                            title: 'Cheque Printing',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            }
                        },
                        {
                            extend: 'print',
                            text: 'Print Table',
                            title: '<div class="print-title">Cheque Printing</div>', // use custom class
                            exportOptions: {
                                columns: ':visible'
                            },
                            customize: function(win) {
                                $(win.document.body).css('background-color', 'white');

                                // Apply white background to <html> and style the title
                                $(win.document.head).append(`
                                    <style>
                                        html {
                                            background-color: white !important;
                                        }
                                        .print-title {
                                            font-size: 20px;
                                            font-weight: bold;
                                            text-align: center;
                                            margin-bottom: 20px;
                                        }
                                        table {
                                            margin-top: 10px;
                                        }
                                    </style>
                                `);
                            }
                        }
                    ],
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#jobBalancingReport').show();
                    }
                });
            }
        });
    </script>
@endsection
