@extends('layout.master')

@section('title')
    Clear/UnClear-Report-YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts/clear-unclear-report') }}" class="breadcrumb-item">Clear/UnClear Report</a><i
        data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Filters</a>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/accounts/clear-unclear-report') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Clear/Unclear Report
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Generate Report</button>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-4">
                                    <label for="date_from">Date From</label>
                                    <input type="date" value="{{ $date_from }}" name="date_from" id="date_from"
                                        class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label for="date_to">Date To</label>
                                    <input type="date" value="{{ $date_to }}" name="date_to" id="date_to"
                                        class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label>Parent Account</label>
                                    <select data-placeholder="Select Account" id="parent_account_id"
                                        name="parent_account_id" class="tom-select w-full">
                                        <option value="">Please Select Parent Account</option>
                                        @foreach ($parent_accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label>Account</label>
                                    <select multiple data-placeholder="Select Account" id="child_account"
                                        name="child_account" class="tom-select w-full">
                                        <option value="">Please Select Account</option>
                                        @foreach ($child_accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label>Bank</label>
                                    <select data-placeholder="Select Bank Account" name="bank" class="tom-select w-full">
                                        <option value="">Please Select bank</option>
                                        @foreach ($bank as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                {{-- <div class="col-md-4 mt-10">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="payment_method" id="receipts"
                                            value="1" checked>
                                        <label class="form-check-label" for="receipts">Receipts</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="payment_method" id="payment"
                                            value="2">
                                        <label class="form-check-label" for="payment">Payment</label>
                                    </div>
                                </div> --}}
                            </div>

                            {{-- <div class="row">
                                <div class="col-md-6">
                                    <fieldset class="mb-3">
                                        <legend>Report Status</legend>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="report_status" id="detail" value="detail" >
                                            <label class="form-check-label" for="detail">Detail</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="report_status" id="summary" value="summary">
                                            <label class="form-check-label" for="summary">Summary</label>
                                        </div>
                                    </fieldset>
                                </div> 
                                <div class="col-md-12">
                                    <fieldset class="mb-3">
                                        <legend>Report Condition</legend>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="report_condition" id="all" value="1">
                                            <label class="form-check-label" for="all">All</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="report_condition" id="clear" value="2" >
                                            <label class="form-check-label" for="clear">Clear</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="report_condition" id="Unclear" value="3" >
                                            <label class="form-check-label" for="Unclear">Unclear</label>
                                        </div>
                                    </fieldset>
                                </div> 
                            </div> --}}
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
