@extends('layout.master')

@section('title')
    Clear-UnClear-Cheques-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Clear/UnClear Cheques Report</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 d-flex justify-content-end mb-3">
            <button id="printButton" class="btn btn-primary me-3">
                <i class="fas fa-print"></i> Print
            </button>
            <!-- Export as Excel -->
            <form action="{{ url('/accounts/clear-unclear-report') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">
                <input type="hidden" name="parent_account_id" value="{{ request('parent_account_id') }}">
                <input type="hidden" name="child_account" value="{{ request('child_account') }}">
                <input type="hidden" name="bank" value="{{ request('bank') }}">
                <input type="hidden" name="export_type" value="xlsx">
                <button type="submit" class="btn btn-success me-3">Export to Excel</button>
            </form>

            <!-- Export as CSV -->
            <form action="{{ url('/accounts/clear-unclear-report') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">
                <input type="hidden" name="parent_account_id" value="{{ request('parent_account_id') }}">
                <input type="hidden" name="child_account" value="{{ request('child_account') }}">
                <input type="hidden" name="bank" value="{{ request('bank') }}">
                <input type="hidden" name="export_type" value="csv">
                <button type="submit" class="btn btn-primary">Export to CSV</button>
            </form>

        </div>
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <div class="custom">
                @if ($invoices && $invoices->isNotEmpty())
                    <table class="table table-bordered mt-n2 display nowrap">
                        <thead>
                            <tr>
                                <th rowspan="2">Sno</th>
                                <th rowspan="2">Voucher #</th>
                                <th rowspan="2">Date</th>
                                <th rowspan="2">Bank</th>
                                <th rowspan="2">Cheque #</th>
                                <th rowspan="2">Cheque Date</th>
                                <th colspan="2" class="text-center">Amount</th>
                            </tr>
                            <tr>
                                <th>Clear</th>
                                <th>UnClear</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $grandTotal = 0;
                            @endphp

                            @foreach ($invoices->groupBy('party_id') as $partyId => $partyInvoices)
                                <tr>
                                    <td colspan="8" class="fw-bold bg-light">
                                        {{ $partyInvoices->first()->chart_of_accounts->name ?? 'Unknown Party' }}
                                    </td>
                                </tr>
                                @php
                                    $partyTotal = 0;
                                @endphp
                                @foreach ($partyInvoices as $index => $invoice)
                                    @php
                                        $invoiceAmount = $invoice->total_debit ?? $invoice->total_credit;
                                        $partyTotal += $invoiceAmount;
                                        $grandTotal += $invoiceAmount;
                                    @endphp
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $invoice->voucher_no }}</td>
                                        <td>{{ \Carbon\Carbon::parse($invoice->date)->format('d-M-Y') }}</td>
                                        <td>{{ $invoice->chart_of_account->name ?? '' }}</td>
                                        <td>{{ $invoice->cheque_number ?? '' }}</td>
                                        <td>
                                            @if ($invoice->cheque_date)
                                                {{ \Carbon\Carbon::parse($invoice->cheque_date)->format('d-M-Y') }}
                                            @else
                                            @endif
                                        </td>
                                        <td>{{ number_format(0, 2) }}</td>
                                        <td>{{ number_format($invoiceAmount, 2) }}</td>
                                    </tr>
                                @endforeach
                                <tr>
                                    <td colspan="6" class="text-end fw-bold">Total for
                                        {{ $partyInvoices->first()->chart_of_accounts->name ?? 'Unknown Party' }}:</td>
                                    <td>0.00</td>
                                    <td class="fw-bold">{{ number_format($partyTotal, 2) }}</td>
                                </tr>
                            @endforeach
                            <tr>
                                <td colspan="6" class="text-end fw-bold">Grand Total:</td>
                                <td>0.00</td>
                                <td class="fw-bold">{{ number_format($grandTotal, 2) }}</td>
                            </tr>
                        </tbody>
                    </table>
                @else
                    <div class="intro-y g-col-12 text-center">
                        <label class="form-label">No data available for the selected date range.</label>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <script>
        document.getElementById("printButton").addEventListener("click", function() {
            var printContents = document.querySelector(".custom").innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = `
                <html>
                    <head>
                        <title>Clear/UnClear Cheques Report - YARAN</title>
                        <style>
                            html {
                                background-color: white;
                            }
                            body {
                                font-family: Arial, sans-serif;
                                background-color: white;
                            }
                            table {
                                width: 100%;
                                border-collapse: collapse;
                                margin-bottom: 20px;
                            }
                            th, td {
                                border: 1px solid #ddd;
                                padding: 8px;
                                text-align: left;
                            }
                            th {
                                background-color: #f2f2f2;
                            }
                            h1 {
                                text-align: center;
                            }
                        </style>
                    </head>
                    <body>
                        <div style="display: flex; flex-wrap: wrap; align-items: center; margin-top: 2rem; text-align: center; margin-bottom: 10px;">
                            <div style="flex-grow: 1;">
                                <h2 style="font-size: 20px !important; font-weight: bold; text-align: center; text-transform: uppercase;">
                                    Clear/UnClear Cheques Report
                                </h2>
                        </div>
                        <div style="margin-top: 10px">
                            ${printContents}
                        </div>
                    </body>
                </html>
            `;

            window.print();
            document.body.innerHTML = originalContents;
            location.reload(); // Reload to restore the original content
        });
    </script>
@endsection
