@extends('layout.master')

@section('title')
    Creditor-List-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Creditor-List</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>

        <div class="intro-y g-col-12 d-flex justify-content-end mb-3">
            <button id="printButton" class="btn btn-primary me-3">
                <i class="fas fa-print"></i>Print</button>
            <form action="{{ url('/accounts/creditor-list') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">
                <input type="hidden" name="account_id" value="{{ request('account_id') }}">
                <input type="hidden" name="currency_id" value="{{ request('currency_id') }}">
                <input type="hidden" name="export_type" value="xlsx">
                <button type="submit" class="btn btn-success me-3">Export to Excel</button>
            </form>

            <!-- Export as CSV -->
            <form action="{{ url('/accounts/creditor-list') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">
                <input type="hidden" name="account_id" value="{{ request('account_id') }}">
                <input type="hidden" name="currency_id" value="{{ request('currency_id') }}">

                <input type="hidden" name="export_type" value="csv">
                <button type="submit" class="btn btn-primary">Export to CSV</button>
            </form>
        </div>

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <div class="custom">
                <table class="table table-bordered mt-n2 display nowrap" id="creditorTable">
                    <thead>
                        <tr>
                            <th rowspan="2">Sno</th>
                            <th rowspan="2">Code</th>
                            <th rowspan="2">Account Name</th>
                            <th colspan="2">Closing Balance</th>
                        </tr>
                        <tr>
                            <th>Debit</th>
                            <th>Credit</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $total_debit_amount = 0.0;
                            $total_credit_amount = 0.0;
                        @endphp
                        @foreach ($voucherDetails as $parentAccountId => $voucherGroup)
                            @php
                                $debit_amount = 0.0;
                                $credit_amount = 0.0;
                            @endphp
                            <tr>
                                <td colspan="5" style="background-color: LightGrey; font-weight:bolder; font-size:15px">
                                    {{ $voucherGroup->first()->parent_account_name }}</td>
                            </tr>
                            @foreach ($voucherGroup as $i => $voucher)
                                <tr>
                                    <td>{{ $i + 1 }}</td>
                                    <td>{{ $voucher->account_code }}</td>
                                    <td>{{ $voucher->name }}</td>
                                    <td>{{ $voucher->debit_lc }}</td>
                                    <td>{{ $voucher->credit_lc }}</td>
                                </tr>
                                @php
                                    $debit_amount += $voucher->debit_lc;
                                    $credit_amount += $voucher->credit_lc;
                                @endphp
                            @endforeach
                            <tr style="background-color: LightGrey;">
                                <td colspan="3" style="font-weight:bolder; font-size:15px; text-align:right">TOTAL</td>
                                <td style="font-weight:bolder; font-size:15px">{{ $debit_amount }}</td>
                                <td style="font-weight:bolder; font-size:15px">{{ $credit_amount }}</td>
                            </tr>
                            @php
                                $total_debit_amount += $debit_amount;
                                $total_credit_amount += $credit_amount;
                            @endphp
                        @endforeach

                    </tbody>
                    <tfoot>
                        <tr>
                        <tr style="background-color: LightGrey;">
                            <td colspan="3" style="font-weight:bolder; font-size:15px;">GRAND TOTAL</td>
                            <td style="font-weight:bolder; font-size:15px">{{ $total_debit_amount }}</td>
                            <td style="font-weight:bolder; font-size:15px">{{ $total_credit_amount }}</td>
                        </tr>
                        </tr>
                    </tfoot>

                </table>
            </div>
        </div>

    </div>

    <script>
        document.getElementById("printButton").addEventListener("click", function() {
            var printContents = document.querySelector(".custom").innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = `
                <html>
                    <head>
                        <title>Creditor List Report - YARAN</title>
                        <style>
                            html {
                                background-color: white;
                            }
                            body {
                                font-family: Arial, sans-serif;
                                background-color: white;
                            }
                            table {
                                width: 100%;
                                border-collapse: collapse;
                                margin-bottom: 20px;
                            }
                            th, td {
                                border: 1px solid #ddd;
                                padding: 8px;
                                text-align: left;
                            }
                            th {
                                background-color: #f2f2f2;
                            }
                            h1 {
                                text-align: center;
                            }
                        </style>
                    </head>
                    <body>
                        <div style="display: flex; flex-wrap: wrap; align-items: center; margin-top: 2rem; text-align: center; margin-bottom: 10px;">
                            <div style="flex-grow: 1;">
                                <h2 style="font-size: 20px !important; font-weight: bold; text-align: center; text-transform: uppercase;">
                                    Creditor List Report
                                </h2>
                        </div>
                        <div style="margin-top: 10px">
                            ${printContents}
                        </div>
                    </body>
                </html>
            `;

            window.print();
            document.body.innerHTML = originalContents;
            location.reload(); // Reload to restore the original content
        });
    </script>
@endsection
