@extends('layout.master')

@section('title')
    Debitor List Report-YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts/debitor-list') }}" class="breadcrumb-item"> Debitor List Report</a><i
        data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Filters</a>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/accounts/debitor-list') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Debitor List Report
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Generate Report</button>
                        {{-- <a href="{{ url('/accounts/chart_of_account') }}" type="back"
                            class="btn btn-secondary waves-effect">
                            Back
                        </a> --}}
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-4">
                                    <label for="date_from">Date From</label>
                                    <input type="date" value="{{ $date_from }}" name="date_from" id="date_from"
                                        class="form-control">
                                </div>

                                {{-- <div class="col-md-4"></div> --}}

                                <div class="col-md-4">
                                    <label for="date_to">Date To</label>
                                    <input type="date" value="{{ $date_to }}" name="date_to" id="date_to"
                                        class="form-control">
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label>Company</label>
                                    <select data-placeholder="Select Company" id="company" name="company"
                                        class="tom-select w-full ">
                                        <option value="1" {{ request('company') == 1 ? 'selected' : '' }}>YARAN
                                            SHIPPING LINE</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label>Account</label>
                                    <select data-placeholder="Select Account" id="account_id" name="account_id"
                                        class="tom-select w-full">
                                        <option value="">Please Select Account</option>
                                        @foreach ($accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>



                                <div class="col-md-4 mt-2">
                                    <label>Currency</label>
                                    <select data-placeholder="Select Currency" id="currency_id" name="currency_id"
                                        class="tom-select w-full">
                                        <option value="">Please Select Currency</option>
                                        @foreach ($currencies as $index => $currency)
                                            <option value="{{ $currency->id }}" {{ $index == 0 ? 'selected' : '' }}>
                                                {{ $currency->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label for="cost_center">Cost Center</label>
                                    <div class="d-flex align-items-center">
                                        <select data-placeholder="Select Cost Center" id="cost_center" name="cost_center"
                                            class="tom-select w-full mt-2">
                                            <option value=""></option>
                                            <option {{ request('cost_center') == 'Head Office' ? 'selected' : '' }}
                                                value="Head Office">Head Office</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            {{-- <div class="row">
                                <div class="col-md-4 mt-2">
                                    <label for="cost_center">Report</label>
                                    <div class="d-flex align-items-center">
                                        <select data-placeholder="Select Report" id="cost_center" name="cost_center"
                                            class="tom-select w-full mt-2">
                                            <option value=""></option>
                                            <option {{ request('Debitors_List') == 'Debitors List' ? 'selected' : '' }}
                                                value="Debitors_List">Debitors List</option>
                                            <option
                                                {{ request('Debitor_Vs_Receivable_Credit_Limit') == 'Debitor Vs Receivable Credit Limit' ? 'selected' : '' }}
                                                value="Debitor_Vs_Receivable_Credit_Limit">Debitor Vs Receivable Credit
                                                Limit</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <fieldset class="mb-3">
                                        <legend>Report Condition</legend>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="exclude_zero_balance"
                                                id="exclude_zero_balance" value="1"
                                                {{ old('exclude_zero_balance') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="exclude_zero_balance">Exclude Zero
                                                Balance</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="exclude_inactive_account"
                                                id="exclude_inactive_account" value="1"
                                                {{ old('exclude_inactive_account') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="exclude_inactive_account">Exclude
                                                In-Active Account</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="show_filter"
                                                id="show_filter" value="1" {{ old('show_filter') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="show_filter">Show Filter</label>
                                        </div>
                                    </fieldset>
                                </div>


                            </div> --}}

                            <div class="row">
                                <div class="col-md-6">
                                    <fieldset class="mb-3 mt-3">
                                        <legend>Order By</legend>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="order_by"
                                                id="account_code" value="account_code"
                                                {{ old('order_by') == 'account_code' ? 'checked' : '' }} checked>
                                            <label class="form-check-label" for="account_code">Account Code</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="order_by"
                                                id="account_name" value="account_name"
                                                {{ old('order_by') == 'account_name' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="account_name">Account Name</label>
                                        </div>
                                    </fieldset>
                                </div>

                                {{-- <div class="col-md-6">
                                    <fieldset class="mb-3">
                                        <legend>Report Type</legend>


                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="report_option"
                                                id="all_radio" value="all" checked onchange="toggleInputFields()">
                                            <label class="form-check-label" for="all_radio">All</label>
                                        </div>

                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="report_option"
                                                id="utilization_radio" value="utilization"
                                                onchange="toggleInputFields()">
                                            <label class="form-check-label" for="utilization_radio">Utilization</label>
                                        </div>

                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="report_option"
                                                id="limit_exceeded_radio" value="limit_exceeded"
                                                onchange="toggleInputFields()">
                                            <label class="form-check-label" for="limit_exceeded_radio">Limit Exceeded
                                                By</label>
                                        </div>


                                        <div id="utilization_input" class="mt-3" style="display:none;">
                                            <label for="utilization">Utilization</label>
                                            <input type="text" id="utilization" name="utilization" placeholder="0.0%"
                                                class="form-control">
                                        </div>

                                        <div id="limit_exceeded_input" class="mt-3" style="display:none;">
                                            <label for="limit_exceeded">Limit Exceeded By</label>
                                            <input type="text" id="limit_exceeded" name="limit_exceeded"
                                                placeholder="0.0%" class="form-control">
                                        </div>
                                    </fieldset>
                                </div> --}}



                            </div>

                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script>
        function toggleInputFields() {
            var utilizationRadio = document.getElementById('utilization_radio').checked;
            var limitExceededRadio = document.getElementById('limit_exceeded_radio').checked;


            if (utilizationRadio) {
                document.getElementById('utilization_input').style.display = 'block';
                document.getElementById('limit_exceeded_input').style.display = 'none';
            } else if (limitExceededRadio) {
                document.getElementById('utilization_input').style.display = 'none';
                document.getElementById('limit_exceeded_input').style.display = 'block';
            } else {
                document.getElementById('utilization_input').style.display = 'none';
                document.getElementById('limit_exceeded_input').style.display = 'none';
            }
        }
    </script>
@endsection
