@extends('layout.master')

@section('title')
    Debitor-List-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Debitor List</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>

        <div class="intro-y g-col-12 d-flex justify-content-end mb-3">
            <button id="printButton" class="btn btn-primary me-3">
                <i class="fas fa-print"></i> Print
            </button>
            <form action="{{ url('/accounts/debitor-list') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">
                <input type="hidden" name="account_id" value="{{ request('account_id') }}">
                <input type="hidden" name="currency_id" value="{{ request('currency_id') }}">
                <input type="hidden" name="export_type" value="xlsx">
                <button type="submit" class="btn btn-success me-3">Export to Excel</button>
            </form>

            <!-- Export as CSV -->
            <form action="{{ url('/accounts/debitor-list') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">
                <input type="hidden" name="account_id" value="{{ request('account_id') }}">
                <input type="hidden" name="currency_id" value="{{ request('currency_id') }}">

                <input type="hidden" name="export_type" value="csv">
                <button type="submit" class="btn btn-primary">Export to CSV</button>
            </form>
        </div>

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2 display nowrap">
                {{-- <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport"
                style="display: none; width:100%"> --}}
                <thead>
                    <tr>
                        <th rowspan="2">Sno</th>
                        <th rowspan="2">Code</th>
                        <th rowspan="2">Account Name</th>
                        <th colspan="2">Closing Balance</th>
                    </tr>
                    <tr>
                        <th>Debit</th>
                        <th>Credit</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $total_debit_amount = 0.0;
                        $total_credit_amount = 0.0;
                    @endphp
                    @foreach ($voucherDetails as $parentAccountId => $voucherGroup)
                        @php
                            $debit_amount = 0.0;
                            $credit_amount = 0.0;
                        @endphp
                        <tr>
                            <td colspan="5" style="background-color: LightGrey; font-weight:bolder; font-size:15px">
                                {{ $voucherGroup->first()->parent_account_name }}</td>
                        </tr>
                        @foreach ($voucherGroup as $i => $voucher)
                            <tr>
                                <td>{{ $i + 1 }}</td>
                                <td>{{ $voucher->account_code }}</td>
                                <td>{{ $voucher->name }}</td>
                                <td>{{ $voucher->debit_lc }}</td>
                                <td>{{ $voucher->credit_lc }}</td>
                            </tr>
                            @php
                                $debit_amount += $voucher->debit_lc;
                                $credit_amount += $voucher->credit_lc;
                            @endphp
                        @endforeach
                        <tr style="background-color: LightGrey;">
                            <td colspan="3" style="font-weight:bolder; font-size:15px; text-align:right">TOTAL</td>
                            <td style="font-weight:bolder; font-size:15px">{{ $debit_amount }}</td>
                            <td style="font-weight:bolder; font-size:15px">{{ $credit_amount }}</td>
                        </tr>
                        @php
                            $total_debit_amount += $debit_amount;
                            $total_credit_amount += $credit_amount;
                        @endphp
                    @endforeach

                </tbody>
                <tfoot>
                    <tr>
                    <tr style="background-color: LightGrey;">
                        <td colspan="3" style="font-weight:bolder; font-size:15px;">GRAND TOTAL</td>
                        <td style="font-weight:bolder; font-size:15px">{{ $total_debit_amount }}</td>
                        <td style="font-weight:bolder; font-size:15px">{{ $total_credit_amount }}</td>
                    </tr>
                    </tr>
                </tfoot>

            </table>
        </div>

    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

    <script>
        document.getElementById('printButton').addEventListener('click', function() {
            // Clone the table to avoid modifying the original
            const table = document.querySelector('table').cloneNode(true);

            // Add a title for the print version
            const printTitle = document.createElement('h2');
            printTitle.textContent = 'Debitor List - YARAN';
            printTitle.style.textAlign = 'center';
            printTitle.style.fontWeight = 'bold';
            printTitle.style.marginBottom = '20px';

            // Create a container for the print content
            const printContainer = document.createElement('div');
            printContainer.appendChild(printTitle);
            printContainer.appendChild(table);

            // Apply print-specific styles
            printContainer.style.padding = '20px';
            printContainer.style.fontFamily = 'Arial, sans-serif';

            // Hide unnecessary elements for printing
            const buttons = printContainer.querySelectorAll('button');
            buttons.forEach(button => button.style.display = 'none');

            // Open a new window for printing
            const printWindow = window.open('', '', 'height=600,width=800');
            printWindow.document.write('<html><head><title>Debitor List</title>');
            printWindow.document.write('<style>');
            printWindow.document.write(`
                table {
                    width: 100%;
                    border-collapse: collapse;
                    margin-bottom: 20px;
                }
                table, th, td {
                    border: 1px solid black;
                }
                th, td {
                    padding: 8px;
                    text-align: left;
                }
                th {
                    background-color: #f2f2f2;
                    font-weight: bold;
                }
                .total-row {
                    background-color: LightGrey;
                    font-weight: bold;
                }
                @media print {
                    body {
                        font-family: Arial, sans-serif;
                    }
                    .print-button {
                        display: none;
                    }
                }
            `);
            printWindow.document.write('</style></head><body>');
            printWindow.document.write(printContainer.innerHTML);
            printWindow.document.write('</body></html>');
            printWindow.document.close();

            // Trigger the print dialog
            printWindow.print();
        });
    </script>

    <script>
        $(document).ready(function() {
            // Check if DataTable library is loaded
            if ($.fn.dataTable) {
                // Initialize the DataTable
                $('#jobBalancingReport').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                            extend: 'excelHtml5',
                            text: 'Export to Excel',
                            title: 'Debitor-list',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            }
                        },
                        // {
                        //     extend: 'pdfHtml5',
                        //     text: 'Export to PDF',
                        //     title: 'Job List with Summary Report',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     },
                        //     customize: function(doc) {
                        //         // Customize PDF output if needed
                        //         doc.content[1].margin = [0, 0, 0, 0]; // Adjust margins
                        //         doc.content[1].table.widths = '*'.repeat(doc.content[1].table.body[
                        //             0].length).split('');
                        //     }
                        // },
                        // {
                        //     extend: 'print',
                        //     text: 'Print Table',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     }
                        // }
                    ],
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#jobBalancingReport').show();
                    }
                });
            }
        });
    </script>
@endsection
