<div class="custom">
    <table class="table table-bordered mt-n2 display nowrap">
        <thead>
            <tr>
                <th>S#</th>
                <th>Particular</th>
                <th>DebitLC</th>
                <th>CreditLC</th>
                <th>DebitVC</th>
                <th>CreditVC</th>
                @if ($add_cost_center == 1)
                    <th>CostCenter / Narration</th>
                @else
                    <th>Narration</th>
                @endif

            </tr>
        </thead>
        <tbody>
            @foreach ($voucherDetails as $index => $voucher)
                @php
                    $totalDebitLC = 0;
                    $totalCrebitLC = 0;
                    $totalDebitVC = 0;
                    $totalCrebitVC = 0;
                @endphp
                <tr>
                    <td style="background: #DCDCDC;" colspan="2">Voucher #: {{ $voucher->voucher_no }}</td>
                    <td style="background: #DCDCDC;" colspan="2">Voucher Date: {{ $voucher->date }}</td>
                    <td style="background: #DCDCDC;" colspan="2">Currency: {{ $voucher->currency->name }}
                    </td>
                    <td style="background: #DCDCDC;">ExchangeRate: {{ $voucher->exchange_rate }}</td>
                </tr>
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $voucher->account?->account_code . ' - ' . $voucher->account?->name }}</td>
                    <td>{{ $voucher->debit_lc }}</td>
                    <td>{{ $voucher->crebit_lc }}</td>
                    <td>{{ $voucher->debit_vc }}</td>
                    <td>{{ $voucher->crebit_vc }}</td>
                    @if ($add_cost_center == 1)
                        <td>{{ 'HEAD OFFICE' . ' / ' . $voucher->narration }}</td>
                    @else
                        <td>{{ $voucher->narration }}</td>
                    @endif
                </tr>
                @php
                    $totalDebitLC += $voucher->debit_lc ?? 0;
                    $totalCrebitLC += $voucher->crebit_lc ?? 0;
                    $totalDebitVC += $voucher->debit_vc ?? 0;
                    $totalCrebitVC += $voucher->crebit_vc ?? 0;
                @endphp
                <tr>
                    <td style="background: #DCDCDC;" colspan="2">Total</td>
                    <td style="background: #DCDCDC;">{{ $totalDebitLC }}</td>
                    <td style="background: #DCDCDC;">{{ $totalCrebitLC }}</td>
                    <td style="background: #DCDCDC;">{{ $totalDebitVC }}</td>
                    <td style="background: #DCDCDC;">{{ $totalCrebitVC }}</td>
                    <td style="background: #DCDCDC;"></td>
                </tr>
                <tr>
                    <td colspan="2">Cheque # : {{ $voucher->voucher_no }}</td>
                    <td colspan="2">Cheque Date : {{ $voucher->date }}</td>
                    <td colspan="3">Source : {{ @$voucher->transaction->payment_type->name }}</td>
                </tr>
                <tr>
                    <td colspan="2">Created By : {{ @$voucher->transaction->created_by_user->name }}</td>
                    <td colspan="2">Created Date : {{ $voucher->created_at }}</td>
                    <td colspan="2">Edit By : {{ @$voucher->transaction->edited_by_user->name }}</td>
                    <td>Edit Date : {{ $voucher->updated_at }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
