<div class="custom">
    <table class="table table-bordered">
        <thead>
            <tr>
                <th colspan="5" class="text-center"><strong>Revenue</strong></th>
            </tr>
            <tr>
                <th>S.No</th>
                <th>Code</th>
                <th>Account Title</th>
                <th>Debit</th>
                <th>Credit</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($revenue as $item)
                <tr>
                    <td>{{ $item['s_no'] }}</td>
                    <td>{{ $item['code'] }}</td>
                    <td>{{ $item['account_title'] }}</td>
                    <td>{{ number_format($item['current_debit'], 2) }}</td>
                    <td>{{ number_format($item['current_credit'], 2) }}</td>
                </tr>
            @endforeach
            @php
                $totalDebitRevenue = array_sum(array_column($revenue, 'current_debit'));
                $totalCreditRevenue = array_sum(array_column($revenue, 'current_credit'));
            @endphp
            <tr>
                <td colspan="3"><strong>Total Revenue</strong></td>
                <td>{{ number_format($totalDebitRevenue, 2) }}</td>
                <td>{{ number_format($totalCreditRevenue, 2) }}</td>
            </tr>

            <tr>
                <th colspan="5" class="text-center"><strong>Expense</strong></th>
            </tr>
            <tr>
                <th>S.No</th>
                <th>Code</th>
                <th>Account Title</th>
                <th>Debit</th>
                <th>Credit</th>
            </tr>
            @foreach ($expense as $item)
                <tr>
                    <td>{{ $item['s_no'] }}</td>
                    <td>{{ $item['code'] }}</td>
                    <td>{{ $item['account_title'] }}</td>
                    <td>{{ number_format($item['current_debit'], 2) }}</td>
                    <td>{{ number_format($item['current_credit'], 2) }}</td>
                </tr>
            @endforeach
            @php
                $totalDebitExpense = array_sum(array_column($expense, 'current_debit'));
                $totalCreditExpense = array_sum(array_column($expense, 'current_credit'));
            @endphp
            <tr>
                <td colspan="3"><strong>Total Expense</strong></td>
                <td>{{ number_format($totalDebitExpense, 2) }}</td>
                <td>{{ number_format($totalCreditExpense, 2) }}</td>
            </tr>

            <tr>
                <th colspan="5" class="text-center"><strong>Profit / Loss</strong></th>
            </tr>
            @php
                $profitLoss = $totalCreditRevenue - $totalDebitExpense;
            @endphp
            <tr>
                <td>1</td>
                <td></td>
                <td>Profit / Loss</td>
                <td>{{ $profitLoss < 0 ? number_format(abs($profitLoss), 2) : '' }}</td>
                <td>{{ $profitLoss >= 0 ? number_format($profitLoss, 2) : '' }}</td>
            </tr>
        </tbody>
    </table>
</div>
