<div class="custom">
    @php
        $grandDebitOpening = 0;
        $grandCreditOpening = 0;
        $grandDebitCurrent = 0;
        $grandCreditCurrent = 0;
        $grandDebitBalance = 0;
        $currency_id = 1;
        $exchange_rate = 1;
    @endphp

    {{-- Loop each account --}}
    @foreach ($allLedgerReports as $accountName => $ledger)
        <table class="table table-bordered mt-n2 display nowrap">
            <thead>
                <tr>
                    <th colspan="{{ $report_type != 3 ? ($report_type == 1 ? 12 : 11) : 10 }}" class="text-center">
                        {{ $ledger['account_name'] }}</th>
                </tr>
                <tr>
                    <th style="width:10%">Sno</th>
                    <th style="width:10%">Date</th>
                    @if ($report_type != 3)
                        <th style="width:10%">Voucher #</th>
                    @endif
                    <th style="width:30%">Particular</th>
                    @if ($report_type == 1)
                        <th style="width:5%">C C</th>
                    @endif
                    <th style="width:15%">Chq / Ref #</th>
                    @if ($hide_cheque_date != 1)
                        <th style="width:25%">Chq / Ref Date</th>
                    @endif
                    <th style="width:15%">Debit</th>
                    <th style="width:15%">Credit</th>
                    <th style="width:15%">Debit (LC)</th>
                    <th style="width:15%">Credit (LC)</th>
                    <th style="width:15%">Balance</th>
                </tr>
            </thead>
            <tbody>
                {{-- Opening Balance --}}
                <tr>
                    <td></td>
                    <td>Opening</td>
                    @if ($report_type != 3)
                        <td></td>
                    @endif
                    <td></td>
                    @if ($report_type == 1)
                        <td></td>
                    @endif
                    <td>{{ $ledger['debit_opening'] > 0 ? $ledger['debit_opening'] : '' }}
                    </td>
                    <td>{{ $ledger['credit_opening'] > 0 ? $ledger['credit_opening'] : '' }}
                    </td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    @if ($hide_cheque_date != 1)
                        <td></td>
                    @endif
                </tr>

                @php $sno = 1; @endphp
                {{-- Transaction Rows --}}
                @foreach ($ledger['ledgerReport'] as $entry)
                    <tr>
                        <td>{{ $sno++ }}</td>
                        <td>{{ $entry['date'] }}</td>
                        @if ($report_type != 3)
                            <td>
                                <a href="{{ url('accounts/general-voucher/edit/' . $entry['transaction_id']) }}">
                                    {{ @$entry['voucher_no'] }}
                                </a>
                            </td>
                        @endif
                        <td>{{ @$entry['narration'] }}</td>
                        @if ($report_type == 1)
                            <td>Head Office</td>
                        @endif
                        <td>{{ @$entry['reference_number'] }}</td>
                        @if ($hide_cheque_date != 1)
                            <td>{{ @$entry['reference_date'] }}</td>
                        @endif
                        <td>{{ $entry['debit_vc'] }}</td>
                        <td>{{ $entry['credit_vc'] }}</td>
                        <td>{{ $entry['debit'] }}</td>
                        <td>{{ $entry['credit'] }}</td>
                        <td>{{ abs($entry['closing_balance'])}}
                            {{ $entry['closing_balance'] < 0 ? 'CR' : 'DR' }}
                        </td>
                    </tr>
                @endforeach

                {{-- Total Row for this account --}}
                <tr>
                    <td colspan="6" class="text-center fw-bold">Total</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td>{{ $ledger['debit_current'] }}</td>
                    <td>{{ $ledger['credit_current'] }}</td>
                    <td>{{ abs($ledger['debit_balance']) }}
                        {{ $ledger['debit_balance'] < 0 ? 'CR' : 'DR' }}
                    </td>
                </tr>
            </tbody>
        </table>

        {{-- Accumulate grand totals --}}
        @php
            $grandDebitOpening += $ledger['debit_opening'];
            $grandCreditOpening += $ledger['credit_opening'];
            $grandDebitCurrent += $ledger['debit_current'];
            $grandCreditCurrent += $ledger['credit_current'];
            $grandDebitBalance += $ledger['debit_balance'];
        @endphp
    @endforeach

    {{-- Grand Total Table (only once, after loop) --}}
    <table class="table table-bordered mt-4">
        <tfoot>
            <tr>
                <th width="70%" class="text-end">Grand Total</th>
                <th width="10%">{{ $grandDebitCurrent + $ledger['debit_opening'] }}</th>
                <th width="10%">{{ $grandCreditCurrent + $ledger['credit_opening'] }}
                </th>
                <th width="10%">{{ abs($grandDebitBalance) }}
                    {{ $grandDebitBalance < 0 ? 'CR' : 'DR' }}
                </th>
            </tr>
        </tfoot>
    </table>


    {{-- Grand Total Row --}}
    {{-- <table class="table table-bordered mt-n2 display nowrap" style="margin-top: 20px;">
        <tbody>
            <tr>
                <th colspan="4">Grand Total</th>
                <th>{{ $grandDebitCurrent }}</th>
                <th>{{ $grandCreditCurrent }}</th>
                <th>{{ $grandDebitBalance }}</th>
                <th></th>
                <th></th>
            </tr>
        </tbody>
    </table> --}}
</div>