<table>
    <thead>
        <tr>
            <th>Account Code</th>
            <th>Account Name</th>
            @if ($report_type == 2)
                <th>Debit (Opening)</th>
                <th>Credit (Opening)</th>
                <th>Debit (Current Period)</th>
                <th>Credit (Current Period)</th>
            @endif
            <th>Debit (Balance)</th>
            <th>Credit (Balance)</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($rows as $row)
            <tr>
                <td>{{ $row['account_id'] }}</td>
                <td>{{ $row['account_name'] }}</td>
                @if ($report_type == 2)
                    <td>{{ $row['opening_debit'] ?? '' }}</td>
                    <td>{{ $row['opening_credit'] ?? '' }}</td>
                    <td>{{ $row['current_debit'] ?? '' }}</td>
                    <td>{{ $row['current_credit'] ?? '' }}</td>
                @endif
                <td>{{ $row['balance_debit'] ?? '' }}</td>
                <td>{{ $row['balance_credit'] ?? '' }}</td>
            </tr>
        @endforeach
    </tbody>
    <tfoot>
        <tr>
            <th>Total</th>
            <th></th>
            @if ($report_type == 2)
                <th>{{ number_format($totals['opening_debit'], 2) }}</th>
                <th>{{ number_format($totals['opening_credit'], 2) }}</th>
                <th>{{ number_format($totals['current_debit'], 2) }}</th>
                <th>{{ number_format($totals['current_credit'], 2) }}</th>
            @endif
            <th>{{ number_format($totals['balance_debit'], 2) }}</th>
            <th>{{ number_format($totals['balance_credit'], 2) }}</th>
        </tr>
    </tfoot>
</table>
