<div class="custom">
                <div class="g-col-12 text-center my-4">
                    <h1 class="fw-bold" style="font-size: 28px; margin-bottom: 10px;">Balance Sheet</h1>
                    <h2 class="text-muted" style="font-size: 20px;">As of {{ date('F d, Y') }}</h2>
                </div>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th colspan="2" class="text-center">Particulars</th>
                            <th class="text-center">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        {{-- ASSETS --}}
                        <tr>
                            <th colspan="3" class="text-center bg-light">Assets</th>
                        </tr>
                        @foreach ($assets as $category => $subcategories)
                            @if ($category != 'total')
                                <tr>
                                    <td colspan="2"><strong>{{ $category }}</strong></td>
                                    <td></td>
                                </tr>
                                @foreach ($subcategories as $subcategory => $amount)
                                    @if ($subcategory != 'total')
                                        <tr>
                                            <td></td>
                                            <td>{{ $subcategory }}</td>
                                            <td class="text-right">{{ number_format($amount, 2) }}</td>
                                        </tr>
                                    @endif
                                @endforeach
                                <tr>
                                    <td></td>
                                    <td><strong>Total {{ $category }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subcategories['total'], 2) }}</strong>
                                    </td>
                                </tr>
                            @endif
                        @endforeach
                        <tr class="table-secondary">
                            <th colspan="2">Total Assets</th>
                            <th class="text-right">{{ number_format($assets['total'], 2) }}</th>
                        </tr>

                        {{-- LIABILITIES --}}
                        <tr>
                            <th colspan="3" class="text-center bg-light">Liabilities</th>
                        </tr>
                        @foreach ($liabilities as $category => $subcategories)
                            @if ($category != 'total')
                                <tr>
                                    <td colspan="2"><strong>{{ $category }}</strong></td>
                                    <td></td>
                                </tr>
                                @foreach ($subcategories as $subcategory => $amount)
                                    @if ($subcategory != 'total')
                                        <tr>
                                            <td></td>
                                            <td>{{ $subcategory }}</td>
                                            <td class="text-right">{{ number_format($amount, 2) }}</td>
                                        </tr>
                                    @endif
                                @endforeach
                                <tr>
                                    <td></td>
                                    <td>Total {{ $category }}</td>
                                    <td class="text-right">{{ number_format($subcategories['total'], 2) }}</td>
                                </tr>
                            @endif
                        @endforeach
                        <tr class="table-secondary">
                            <th colspan="2">Total Liabilities</th>
                            <th class="text-right">{{ number_format($liabilities['total'], 2) }}</th>
                        </tr>

                        {{-- EQUITY --}}
                        <tr>
                            <th colspan="3" class="text-center bg-light">Equity</th>
                        </tr>
                        @foreach ($capital as $category => $subcategories)
                            @if ($category != 'total')
                                @foreach ($subcategories as $subcategory => $amount)
                                    @if ($subcategory != 'total')
                                        <tr>
                                            <td></td>
                                            <td>{{ $subcategory }}</td>
                                            <td class="text-right">{{ number_format($amount, 2) }}</td>
                                        </tr>
                                    @endif
                                @endforeach
                            @endif
                        @endforeach
                        <tr>
                            <td></td>
                            <td>Net Income</td>
                            <td class="text-right">{{ number_format($revenue['total'] - $expenses['total'], 2) }}</td>
                        </tr>
                        <tr class="table-secondary">
                            <th colspan="2">Total Equity</th>
                            <th class="text-right">
                                {{ number_format($capital['total'] + $revenue['total'] - $expenses['total'], 2) }}</th>
                        </tr>

                        {{-- TOTAL LIABILITIES AND EQUITY --}}
                        <tr class="table-dark text-white">
                            <th colspan="2">Total Liabilities and Equity</th>
                            <th class="text-right">
                                {{ number_format($liabilities['total'] + $capital['total'] + $revenue['total'] - $expenses['total'], 2) }}
                            </th>
                        </tr>
                    </tbody>
                </table>
            </div>
