<div class="custom">
    <table class="table table-bordered mt-n2 display nowrap">
        <thead>
            <tr>
                <th>S #</th>
                <th>Invoice #</th>
                <th>Trn Date</th>
                <th>Particular</th>
                <th>Debit</th>
                <th>Credit</th>
                <th>Balance</th>
                <th>Type</th>
                <th>Budget</th>
                <th>Bal Budget</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($formattedDetails as $groupIndex => $group)
                <!-- Group Header -->
                <tr>
                    <td colspan="10" class="bg-light">
                        <strong>{{ $group['group_key'] }}</strong>
                    </td>
                </tr>

                <!-- Group Transactions -->
                @foreach ($group['transactions'] as $transactionIndex => $transaction)
                    <tr>
                        <td>{{ $loop->parent->iteration }}.{{ $transactionIndex + 1 }}</td> <!-- S # -->
                        <td>{{ $transaction['voucher_no'] }}</td> <!-- Trn Date -->
                        <td>{{ $transaction['date'] }}</td> <!-- Trn Date -->
                        <td>{{ $transaction['particulars'] }}</td> <!-- Particular -->
                        <td>{{ number_format($transaction['debit'], 2) }}</td> <!-- Debit -->
                        <td>{{ number_format($transaction['credit'], 2) }}</td> <!-- Credit -->
                        <td>{{ number_format($transaction['balance'], 2) }}</td> <!-- balance -->
                        <td>{{ $transaction['debit'] > 0 ? 'Dr' : 'Cr' }}</td>
                        <td>0.00</td>
                        <td>{{ number_format($transaction['budget_balance'], 2) }}</td> <!-- budget_balance -->
                    </tr>
                @endforeach

                <!-- Group Totals -->
                <tr class="font-weight-bold">
                    <td colspan="4" class="text-right">Total:</td>
                    <td>{{ number_format($group['totals']['total_debit'], 2) }}</td>
                    <td>{{ number_format($group['totals']['total_credit'], 2) }}</td>
                    <td>{{ number_format($group['totals']['balance'], 2) }}</td>
                    <td></td>
                    <td>0.00</td>
                    <td>{{ number_format($group['totals']['budget_balance'], 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
