<div class="custom">
    <table class="table table-bordered mt-n2 display nowrap">
        <thead>
            <tr>
                <th rowspan="2">Sno</th>
                <th rowspan="2">Voucher #</th>
                <th rowspan="2">Date</th>
                <th rowspan="2">Bank</th>
                <th rowspan="2">Cheque #</th>
                <th rowspan="2">Cheque Date</th>
                <th colspan="2" class="text-center">Amount</th>
            </tr>
            <tr>
                <th>Clear</th>
                <th>UnClear</th>
            </tr>
        </thead>
        <tbody>
            @php
                $grandTotal = 0;
            @endphp

            @foreach ($invoices->groupBy('party_id') as $partyId => $partyInvoices)
                <tr>
                    <td colspan="8" class="fw-bold bg-light">
                        {{ $partyInvoices->first()->chart_of_accounts->name ?? 'Unknown Party' }}
                    </td>
                </tr>
                @php
                    $partyTotal = 0;
                @endphp
                @foreach ($partyInvoices as $index => $invoice)
                    @php
                        $invoiceAmount = $invoice->total_debit ?? $invoice->total_credit;
                        $partyTotal += $invoiceAmount;
                        $grandTotal += $invoiceAmount;
                    @endphp
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $invoice->voucher_no }}</td>
                        <td>{{ \Carbon\Carbon::parse($invoice->date)->format('d-M-Y') }}</td>
                        <td>{{ $invoice->chart_of_account->name ?? '' }}</td>
                        <td>{{ $invoice->cheque_number ?? '' }}</td>
                        <td>
                            @if ($invoice->cheque_date)
                                {{ \Carbon\Carbon::parse($invoice->cheque_date)->format('d-M-Y') }}
                            @else
                            @endif
                        </td>
                        <td>{{ number_format(0, 2) }}</td>
                        <td>{{ number_format($invoiceAmount, 2) }}</td>
                    </tr>
                @endforeach
                <tr>
                    <td colspan="6" class="text-end fw-bold">Total for
                        {{ $partyInvoices->first()->chart_of_accounts->name ?? 'Unknown Party' }}:</td>
                    <td>0.00</td>
                    <td class="fw-bold">{{ number_format($partyTotal, 2) }}</td>
                </tr>
            @endforeach
            <tr>
                <td colspan="6" class="text-end fw-bold">Grand Total:</td>
                <td>0.00</td>
                <td class="fw-bold">{{ number_format($grandTotal, 2) }}</td>
            </tr>
        </tbody>
    </table>
</div>
