<div class="custom">
    <table class="table table-bordered mt-n2 display nowrap">
        <thead>
            <tr>
                <th rowspan="2">Sno</th>
                <th rowspan="2">Code</th>
                <th rowspan="2">Account Name</th>
                <th colspan="2">Closing Balance</th>
            </tr>
            <tr>
                <th>Debit</th>
                <th>Credit</th>
            </tr>
        </thead>
        <tbody>
            @php
                $total_debit_amount = 0.0;
                $total_credit_amount = 0.0;
            @endphp
            @foreach ($voucherDetails as $parentAccountId => $voucherGroup)
                @php
                    $debit_amount = 0.0;
                    $credit_amount = 0.0;
                @endphp
                <tr>
                    <td colspan="5" style="background-color: LightGrey; font-weight:bolder; font-size:15px">
                        {{ $voucherGroup->first()->parent_account_name }}</td>
                </tr>
                @foreach ($voucherGroup as $i => $voucher)
                    <tr>
                        <td>{{ $i + 1 }}</td>
                        <td>{{ $voucher->account_code }}</td>
                        <td>{{ $voucher->name }}</td>
                        <td>{{ $voucher->debit_lc }}</td>
                        <td>{{ $voucher->credit_lc }}</td>
                    </tr>
                    @php
                        $debit_amount += $voucher->debit_lc;
                        $credit_amount += $voucher->credit_lc;
                    @endphp
                @endforeach
                <tr style="background-color: LightGrey;">
                    <td colspan="3" style="font-weight:bolder; font-size:15px; text-align:right">TOTAL</td>
                    <td style="font-weight:bolder; font-size:15px">{{ $debit_amount }}</td>
                    <td style="font-weight:bolder; font-size:15px">{{ $credit_amount }}</td>
                </tr>
                @php
                    $total_debit_amount += $debit_amount;
                    $total_credit_amount += $credit_amount;
                @endphp
            @endforeach

        </tbody>
        <tfoot>
            <tr style="background-color: LightGrey;">
                <td colspan="3" style="font-weight:bolder; font-size:15px;">GRAND TOTAL</td>
                <td style="font-weight:bolder; font-size:15px">{{ $total_debit_amount }}</td>
                <td style="font-weight:bolder; font-size:15px">{{ $total_credit_amount }}</td>
            </tr>
        </tfoot>
    </table>
</div>
