<div class="custom">
    <table class="table table-bordered mt-n2 display nowrap">
        <thead>
            <tr>
                <th>S#</th>
                <th>Party</th>
                <th>Cheque #</th>
                <th>Cheque Date</th>
                <th>Cost Center</th>
                @if ($report_type == 'all')
                    <th>Receipt</th>
                    <th>Payment</th>
                @elseif($report_type == 'payment')
                    <th>Payment</th>
                @elseif($report_type == 'receipt')
                    <th>Receipt</th>
                @endif
                <th>particular</th>
                <th>Voucher #</th>
                <th>V Date</th>

            </tr>
        </thead>
        <tbody>
            @php
                $total_receipt_amount = 0.0;
                $total_payment_amount = 0.0;
            @endphp
            @foreach ($voucherDetails as $parentAccountId => $voucherGroup)
                @php
                    $receipt_amount = 0.0;
                    $payment_amount = 0.0;
                @endphp
                <tr>
                    <td colspan="{{ $report_type == 'all' ? 10 : 9 }}"
                        style="background-color: LightGrey; font-weight:bolder; font-size:15px">
                        {{ $voucherGroup->first()->name }}</td>
                </tr>
                @foreach ($voucherGroup as $i => $voucher)
                    <tr>
                        <td>{{ $i + 1 }}</td>
                        <td>{{ @$voucher->transaction->party->name }}</td>
                        <td>{{ $voucher->transaction->cheque_number }}</td>
                        <td>{{ $voucher->transaction->cheque_date }}</td>
                        <td>HO</td>
                        @if ($report_type == 'all')
                            @if ($voucher->transaction->transaction_type_master_id == 2)
                                <td>{{ $voucher->debit_lc ?? $voucher->credit_lc }}</td>
                            @else
                                <td>0.00</td>
                            @endif
                            @if ($voucher->transaction->transaction_type_master_id == 1)
                                <td>{{ $voucher->debit_lc ?? $voucher->credit_lc }}</td>
                            @else
                                <td>0.00</td>
                            @endif
                        @elseif($report_type == 'payment')
                            @if ($voucher->transaction->transaction_type_master_id == 1)
                                <td>{{ $voucher->debit_lc ?? $voucher->credit_lc }}</td>
                            @else
                                <td>0.00</td>
                            @endif
                        @elseif($report_type == 'receipt')
                            @if ($voucher->transaction->transaction_type_master_id == 2)
                                <td>{{ $voucher->debit_lc ?? $voucher->credit_lc }}</td>
                            @else
                                <td>0.00</td>
                            @endif
                        @endif
                        <td>{{ $voucher->narration }}</td>
                        <td>{{ $voucher->voucher_no }}</td>
                        <td>{{ $voucher->date }}</td>
                    </tr>
                    @php
                        if ($report_type == 'all') {
                            if ($voucher->transaction->transaction_type_master_id == 2) {
                                $receipt_amount += $voucher->debit_lc ?? $voucher->credit_lc;
                                $payment_amount += 0;
                            } else {
                                $payment_amount += $voucher->debit_lc ?? $voucher->credit_lc;
                                $receipt_amount += 0;
                            }
                        } elseif ($report_type == 'payment') {
                            if ($voucher->transaction->transaction_type_master_id == 2) {
                                $receipt_amount += $voucher->debit_lc ?? $voucher->credit_lc;
                                $payment_amount += 0;
                            }
                        } elseif ($report_type == 'receipt') {
                            if ($voucher->transaction->transaction_type_master_id == 1) {
                                $payment_amount += $voucher->debit_lc ?? $voucher->credit_lc;
                                $receipt_amount += 0;
                            }
                        }

                    @endphp
                @endforeach
                <tr style="background-color: LightGrey;">
                    <td colspan="5" style="font-weight:bolder; font-size:15px; text-align:right">TOTAL</td>
                    @if ($report_type == 'all')
                        <td style="font-weight:bolder; font-size:15px">{{ $receipt_amount }}</td>
                        <td style="font-weight:bolder; font-size:15px">{{ $payment_amount }}</td>
                    @elseif($report_type == 'payment')
                        <td style="font-weight:bolder; font-size:15px">{{ $payment_amount }}</td>
                    @elseif($report_type == 'receipt')
                        <td style="font-weight:bolder; font-size:15px">{{ $receipt_amount }}</td>
                    @endif

                    <td colspan="3"></td>
                </tr>
                @php
                    $total_receipt_amount += $receipt_amount;
                    $total_payment_amount += $payment_amount;
                @endphp
            @endforeach


        </tbody>

    </table>
</div>
