@extends('layout.master')

@section('title')
    Income Statement Report-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Income Statement Report</a>
@endsection

<style>
    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }

    th,
    td {
        border: 1px solid #ddd;
        padding: 8px;
        text-align: left;
    }

    th {
        background-color: #f2f2f2;
    }

    .grey {
        background-color: rgba(45, 55, 72, 0.05) !important;
    }
</style>
@section('content')
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>

        <div class="intro-y g-col-12 d-flex justify-content-end mb-3">
            <button id="printButton" class="btn btn-primary me-3">
                <i class="fas fa-print"></i> Print
            </button>
            <!-- Export as Excel -->
            <form action="{{ url('/accounts/income-statement') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">

                <input type="hidden" name="export_type" value="xlsx">
                <button type="submit" class="btn btn-success me-3">Export to Excel</button>
            </form>

            <!-- Export as CSV -->
            <form action="{{ url('/accounts/income-statement') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">

                <input type="hidden" name="export_type" value="csv">
                <button type="submit" class="btn btn-primary">Export to CSV</button>
            </form>

        </div>

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <div class="custom">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th colspan="5" class="text-center">Revenue</th>
                        </tr>
                        <tr>
                            <th>S.No</th>
                            <th>Code</th>
                            <th>Account Title</th>
                            <th>Debit</th>
                            <th>Credit</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($revenue as $item)
                            <tr>
                                <td>{{ $item['s_no'] }}</td>
                                <td>{{ $item['code'] }}</td>
                                <td>{{ $item['account_title'] }}</td>
                                <td>{{ number_format($item['current_debit'], 2) }}</td>
                                <td>{{ number_format($item['current_credit'], 2) }}</td>
                            </tr>
                        @endforeach
                        @php
                            $totalDebitRevenue = array_sum(array_column($revenue, 'current_debit'));
                            $totalCreditRevenue = array_sum(array_column($revenue, 'current_credit'));
                        @endphp
                        <tr>
                            <td colspan="3"><strong>Total Revenue</strong></td>
                            <td>{{ number_format($totalDebitRevenue, 2) }}</td>
                            <td>{{ number_format($totalCreditRevenue, 2) }}</td>
                        </tr>

                        <tr>
                            <th colspan="5" class="text-center">Expense</th>
                        </tr>
                        <tr>
                            <th>S.No</th>
                            <th>Code</th>
                            <th>Account Title</th>
                            <th>Debit</th>
                            <th>Credit</th>
                        </tr>
                        @foreach ($expense as $item)
                            <tr>
                                <td>{{ $item['s_no'] }}</td>
                                <td>{{ $item['code'] }}</td>
                                <td>{{ $item['account_title'] }}</td>
                                <td>{{ number_format($item['current_debit'], 2) }}</td>
                                <td>{{ number_format($item['current_credit'], 2) }}</td>
                            </tr>
                        @endforeach
                        @php
                            $totalDebitExpense = array_sum(array_column($expense, 'current_debit'));
                            $totalCreditExpense = array_sum(array_column($expense, 'current_credit'));
                        @endphp
                        <tr>
                            <td colspan="3"><strong>Total Expense</strong></td>
                            <td>{{ number_format($totalDebitExpense, 2) }}</td>
                            <td>{{ number_format($totalCreditExpense, 2) }}</td>
                        </tr>

                        <tr>
                            <th colspan="5" class="text-center">Profit / Loss</th>
                        </tr>
                        @php
                            $profitLoss = $totalCreditRevenue - $totalDebitExpense;
                        @endphp
                        <tr>
                            <td>1</td>
                            <td></td>
                            <td>Profit / Loss</td>
                            <td>{{ $profitLoss < 0 ? number_format(abs($profitLoss), 2) : '' }}</td>
                            <td>{{ $profitLoss >= 0 ? number_format($profitLoss, 2) : '' }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        document.getElementById("printButton").addEventListener("click", function() {
            var printContents = document.querySelector(".custom").innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = `
                <html>
                    <head>
                        <title>Income Statement Report - YARAN</title>
                        <style>
                            html {
                                background-color: white;
                            }
                            body {
                                font-family: Arial, sans-serif;
                                background-color: white;
                            }
                            table {
                                width: 100%;
                                border-collapse: collapse;
                                margin-bottom: 20px;
                            }
                            th, td {
                                border: 1px solid #ddd;
                                padding: 8px;
                                text-align: left;
                            }
                            th {
                                background-color: #f2f2f2;
                            }
                            h1 {
                                text-align: center;
                            }
                            .grey {
                                background-color: rgba(45, 55, 72, 0.05) !important;
                            }
                        </style>
                    </head>
                    <body>
                        <div style="display: flex; flex-wrap: wrap; align-items: center; margin-top: 2rem; text-align: center; margin-bottom: 10px;">
                            <div style="flex-grow: 1;">
                                <h2 style="font-size: 20px !important; font-weight: bold; text-align: center; text-transform: uppercase;">
                                    Income Statement Report
                                </h2>
                        </div>
                        <div style="margin-top: 10px">
                            ${printContents}
                        </div>
                    </body>
                </html>
            `;

            window.print();
            document.body.innerHTML = originalContents;
            location.reload(); // Reload to restore the original content
        });
    </script>
@endsection
