@extends('layout.master')

@section('title')
    Invoice-Settelment-Report-YARAN
@endsection

@section('topbar')
    <a href="{{ url('/accounts/invoice-settelment') }}" class="breadcrumb-item"> Invoice Settelment Report</a><i
        data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Filters</a>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('accounts/invoice-settelment') }}"
                enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Invoice Settelment Report
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Generate Report</button>
                        {{-- <a href="{{ url('/accounts/chart_of_account') }}" type="back"
                            class="btn btn-secondary waves-effect">
                            Back
                        </a> --}}
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-4">
                                    <label for="date_from">Date From</label>
                                    <input type="date" value="{{ $date_from }}" name="date_from" id="date_from"
                                        class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label for="date_to">Date To</label>
                                    <input type="date" value="{{ $date_to }}" name="date_to" id="date_to"
                                        class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label> Account</label>
                                    <select data-placeholder="Select Account" id="parent_account_id" name="account_id"
                                        class="tom-select w-full">
                                        <option value="">Please Select Account</option>
                                        @foreach ($parent_accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2 ">
                                    <label>Company</label>
                                    <select data-placeholder="Select Company" id="company" name="company"
                                        class="tom-select w-full ">
                                        <option value="1" {{ request('company') == 1 ? 'selected' : '' }}>YARAN
                                            SHIPPING LINE</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label>Currency</label>
                                    <select data-placeholder="Select Currency" id="currency_id" name="currency_id"
                                        class="tom-select w-full">
                                        <option value="">Please Select Currency</option>
                                        @foreach ($currencies as $currency)
                                            <option value="{{ $currency->id }}">{{ $currency->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label for="cost_center">Cost Center</label>
                                    <select data-placeholder="Select Cost Center" id="cost_center" name="cost_center"
                                        class="tom-select w-full">
                                        <option value=""></option>
                                        <option {{ request('cost_center') == 'Head Office' ? 'selected' : '' }}
                                            value="Head Office">Head Office</option>
                                    </select>
                                </div>
                                {{-- <div class="col-md-4 mt-2">
                                    <label for="Voucher_no">Voucher No</label>
                                    <div>
                                        <input type="text" class="form-control" placeholder="Please Enter Voucher"
                                            name="Voucher_no">
                                    </div>
                                </div> --}}
                            </div>
                            {{-- <div class="row">
                                <div class="col-md-6">
                                    <fieldset class="mb-3">
                                        <legend>Report Type</legend>
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="report_option"
                                                id="all_radio" value="Voucher_Wise" checked>
                                            <label class="form-check-label" for="Voucher_Wise">VoucherWise</label>
                                        </div>

                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="report_option"
                                                value="Invoice_Wise">
                                            <label class="form-check-label" for="Invoice_Wise">Invoice Wise</label>
                                        </div>

                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="report_option"
                                                value="Settlement_Instrument_Wise">
                                            <label class="form-check-label" for="Settlement_Instrument_Wise">Settlement
                                                Instrument Wise</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="report_option"
                                                value="Settlement_Instrument_Report">
                                            <label class="form-check-label" for="Settlement_Instrument_Report">Settlement
                                                Instrument Report</label>
                                        </div>
                                    </fieldset>
                                </div>
                            </div> --}}
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
