@extends('layout.master')

@section('title')
    Invoice-Settelment-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Invoice Settelment Report</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            @if ($invoices)
                <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport"
                    style="display: none; width:100%">
                    <thead>
                        <tr>
                            <th>Code</th>
                            <th>Party</th>
                            <th>Voucher No</th>
                            <th>Voucher Date</th>
                            <th>Amount</th>
                            <th>Inv #</th>
                            <th>Inv Date</th>
                            <th>Inv Amount</th>
                            <th>Inv Adj</th>
                            <th>Inv Balance </th>
                            <th>Instrument #</th>
                            <th>Inst Date</th>
                            <th>Inst Amount</th>
                            <th>Inst Adj</th>
                            <th>Inst Bal</th>
                            <th>Narration</th>
                            <th>Cheque No</th>
                            <th>Cheque Date</th>
                            <th>Inv Age</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $current_date = \Carbon\Carbon::today()->format('Y-m-d');
                            $inv_age = 0;
                        @endphp
                        @foreach ($invoices as $invoice)
                            @if ($invoice->detail)
                                @foreach ($invoice->detail as $detail)
                                    <tr>
                                        <td>{{ $invoice->chart_of_accounts->account_code }}</td>
                                        <td>{{ $invoice->chart_of_accounts->name }}</td>
                                        <td>{{ $invoice->voucher_no }}</td>
                                        <td>{{ $invoice->date }}</td>
                                        <td>{{ $detail->debit_lc ? $detail->debit_lc : $detail->credit_lc }}</td>
                                        @if ($invoice->transaction)
                                            <td>{{ $invoice->transaction->tran_no }}</td>
                                            <td>{{ $invoice->transaction->inv_date }}</td>
                                            <td>{{ $invoice->transaction->grand_local_amount }}</td>
                                            @php
                                                $invoice_date = \Carbon\Carbon::parse($invoice->transaction->inv_date);
                                                $inv_age = $invoice_date->diffInDays($current_date);
                                            @endphp
                                            @if ($invoice->transaction->receipt_payment_details)
                                                @php
                                                    $totalReceived = 0;
                                                    $totalBalance = $invoice->transaction->grand_local_amount;
                                                @endphp
                                                @foreach ($invoice->transaction->receipt_payment_details as $receipt_payment_detail)
                                                    @php
                                                        $totalReceived += $receipt_payment_detail->rcvd_amount;
                                                    @endphp
                                                @endforeach
                                                @php
                                                    $totalBalance = $totalBalance - $totalReceived;
                                                @endphp
                                                <td>{{ $totalReceived }}</td>
                                                <td>{{ $totalBalance }}</td>
                                            @else
                                                <td>0.00</td>
                                                <td>{{ $invoice->transaction->grand_local_amount }}</td>
                                            @endif
                                        @elseif ($invoice->bill)
                                            <td>{{ $invoice->bill->tran_no }}</td>
                                            <td>{{ $invoice->bill->bill_date }}</td>
                                            <td>{{ $invoice->bill->grand_local_amount }}</td>
                                            @php
                                                $invoice_date = \Carbon\Carbon::parse($invoice->bill->bill_date);
                                                $inv_age = $invoice_date->diffInDays($current_date);
                                            @endphp
                                            @if ($invoice->bill->receipt_payment_details)
                                                @php
                                                    $totalReceived = 0;
                                                    $totalBalance = $invoice->bill->grand_local_amount;
                                                @endphp
                                                @foreach ($invoice->bill->receipt_payment_details as $receipt_payment_detail)
                                                    @php
                                                        $totalReceived += $receipt_payment_detail->rcvd_amount;
                                                    @endphp
                                                @endforeach
                                                @php
                                                    $totalBalance = $totalBalance - $totalReceived;
                                                @endphp
                                                <td>{{ $totalReceived }}</td>
                                                <td>{{ $totalBalance }}</td>
                                            @else
                                                <td>0.00</td>
                                                <td>{{ $invoice->bill->grand_local_amount }}</td>
                                            @endif
                                        @else
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        @endif
                                        <td></td>
                                        <td></td>
                                        <td>0.00</td>
                                        <td>0.00</td>
                                        <td>0.00</td>
                                        <td>{{ $detail->narration }}</td>
                                        <td>{{ $invoice->cheque_number }}</td>
                                        <td>{{ $invoice->cheque_date }}</td>
                                        <td>{{ $inv_age }}</td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td>{{ $invoice->chart_of_accounts->account_code }}</td>
                                    <td>{{ $invoice->chart_of_accounts->name }}</td>
                                    <td>{{ $invoice->voucher_no }}</td>
                                    <td>{{ $invoice->date }}</td>
                                    <td>{{ $invoice->total_debit ? $detail->total_debit : $detail->total_credit }}</td>
                                    @if ($invoice->transaction)
                                        <td>{{ $invoice->transaction->tran_no }}</td>
                                        <td>{{ $invoice->transaction->inv_date }}</td>
                                        <td>{{ $invoice->transaction->grand_local_amount }}</td>
                                        @php
                                            $invoice_date = \Carbon\Carbon::parse($invoice->transaction->inv_date);
                                            $inv_age = $invoice_date->diffInDays($current_date);
                                        @endphp
                                        @if ($invoice->transaction->receipt_payment_details)
                                            @php
                                                $totalReceived = 0;
                                                $totalBalance = $invoice->transaction->grand_local_amount;
                                            @endphp
                                            @foreach ($invoice->transaction->receipt_payment_details as $receipt_payment_detail)
                                                @php
                                                    $totalReceived += $receipt_payment_detail->rcvd_amount;
                                                @endphp
                                            @endforeach
                                            @php
                                                $totalBalance = $totalBalance - $totalReceived;
                                            @endphp
                                            <td>{{ $totalReceived }}</td>
                                            <td>{{ $totalBalance }}</td>
                                        @else
                                            <td>0.00</td>
                                            <td>{{ $invoice->transaction->grand_local_amount }}</td>
                                        @endif
                                    @elseif ($invoice->bill)
                                        <td>{{ $invoice->bill->tran_no }}</td>
                                        <td>{{ $invoice->bill->bill_date }}</td>
                                        <td>{{ $invoice->bill->grand_local_amount }}</td>
                                        @php
                                            $invoice_date = \Carbon\Carbon::parse($invoice->bill->bill_date);
                                            $inv_age = $invoice_date->diffInDays($current_date);
                                        @endphp
                                        @if ($invoice->bill->receipt_payment_details)
                                            @php
                                                $totalReceived = 0;
                                                $totalBalance = $invoice->bill->grand_local_amount;
                                            @endphp
                                            @foreach ($invoice->bill->receipt_payment_details as $receipt_payment_detail)
                                                @php
                                                    $totalReceived += $receipt_payment_detail->rcvd_amount;
                                                @endphp
                                            @endforeach
                                            @php
                                                $totalBalance = $totalBalance - $totalReceived;
                                            @endphp
                                            <td>{{ $totalReceived }}</td>
                                            <td>{{ $totalBalance }}</td>
                                        @else
                                            <td>0.00</td>
                                            <td>{{ $invoice->bill->grand_local_amount }}</td>
                                        @endif
                                    @else
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    @endif
                                    <td></td>
                                    <td></td>
                                    <td>0.00</td>
                                    <td>0.00</td>
                                    <td>0.00</td>
                                    <td></td>
                                    <td>{{ $invoice->cheque_number }}</td>
                                    <td>{{ $invoice->cheque_date }}</td>
                                    <td>{{ $inv_age }}</td>
                                </tr>
                            @endif
                        @endforeach
                    </tbody>
                </table>
            @else
                <div class="intro-y g-col-12 text-center">
                    <label class="form-label">No data available for the selected date range.</label>
                </div>
            @endif
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>


    <script>
        $(document).ready(function() {
            // Check if DataTable library is loaded
            if ($.fn.dataTable) {
                // Initialize the DataTable
                $('#jobBalancingReport').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                            extend: 'excelHtml5',
                            text: 'Export to Excel',
                            title: 'Invoice Settelment Report',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            }
                        },
                        // {
                        //     extend: 'pdfHtml5',
                        //     text: 'Export to PDF',
                        //     title: 'Job List with Summary Report',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     },
                        //     customize: function(doc) {
                        //         // Customize PDF output if needed
                        //         doc.content[1].margin = [0, 0, 0, 0]; // Adjust margins
                        //         doc.content[1].table.widths = '*'.repeat(doc.content[1].table.body[
                        //             0].length).split('');
                        //     }
                        // },
                        // {
                        //     extend: 'print',
                        //     text: 'Print Table',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     }
                        // }
                    ],
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#jobBalancingReport').show();
                    }
                });
            }
        });
    </script>
@endsection
