@extends('layout.master')

@section('title')
    PDCM-YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts/pdcm') }}" class="breadcrumb-item"> PDCM</a><i data-feather="chevron-right"
        class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Filters</a>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/accounts/pdcm') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            PDCM
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Generate Report</button>
                        {{-- <a href="{{ url('/accounts/chart_of_account') }}" type="back"
                            class="btn btn-secondary waves-effect">
                            Back
                        </a> --}}
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-3 mt-4">
                                    <div class="d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" name="up_till_cheque_date"
                                            id="up_till_cheque_date" value="1"
                                            {{ old('up_till_cheque_date') ? 'checked' : '' }}>
                                        <label class="form-check-label" for="up_till_cheque_date">Up Till Cheque
                                            Date</label>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <input type="date" value="{{ \Carbon\Carbon::now()->format('Y-m-d') }}"
                                        name="date" id="date" class="form-control">
                                </div>

                                <div class="col-md-3 mt-4">
                                    <input class="form-check-input" type="checkbox" name="show_unposted_record"
                                        id="show_unposted_record" value="1"
                                        {{ old('show_unposted_record') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="show_unposted_record">Show UnPosted Record</label>
                                </div>

                                <div class="col-md-3 mt-4">
                                    <label>Company</label>
                                    <select data-placeholder="Select Company" id="company" name="company"
                                        class="tom-select w-full ">
                                        <option value="1" {{ request('company') == 1 ? 'selected' : '' }}>YARAN
                                            SHIPPING LINE</option>
                                    </select>
                                </div>

                                <div class="col-md-3 mt-4">
                                    <label>Bank</label>
                                    <select data-placeholder="Select Bank" id="bank_id" name="bank_id"
                                        class="form-select w-full">
                                        <option value="">Please Select Bank</option>
                                        @foreach ($banks as $item)
                                            <option value="{{ $item->id }}"
                                                {{ old('bank_id') == $item->id ? 'selected' : '' }}>{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-3 mt-2">
                                    <label>Client</label>
                                    <select id="client_id" name="client_id" class="form-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($clients as $item)
                                            <option {{ request('client_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-3 mt-2">
                                    <label for="cost_center">Cost Center</label>
                                    <div class="d-flex align-items-center">
                                        <select data-placeholder="Select Cost Center" id="cost_center" name="cost_center"
                                            class="form-select w-full mt-2">
                                            <option value=""></option>
                                            <option {{ request('cost_center') == 'Head Office' ? 'selected' : '' }}
                                                value="Head Office">Head Office</option>
                                        </select>
                                    </div>
                                </div>
                            </div>


                            <div class="row">


                                <div class="col-md-12">
                                    <fieldset class="mb-3">
                                        <legend class="text-center fw-bold">Report Type</legend>

                                        <div class="row">
                                            <div class="col-md-4 mt-2">
                                                <input class="form-check-input" type="radio" name="report_type"
                                                    id="all_radio" value="all" checked>
                                                <label class="form-check-label" for="all_radio">All</label>
                                            </div>

                                            <div class="col-md-4 mt-2">
                                                <input class="form-check-input" type="radio" name="report_type" id="payment"
                                                    value="payment">
                                                <label class="form-check-label" for="payment">Payment</label>
                                            </div>

                                            <div class="col-md-4 mt-2">
                                                <input class="form-check-input" type="radio" name="report_type" id="receipt"
                                                    value="receipt">
                                                <label class="form-check-label" for="receipt">Receipt</label>
                                            </div>
                                        </div>



                                    </fieldset>
                                </div>



                            </div>

                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
