@extends('layout.master')

@section('title')
    PDCM-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">PDCM Matured Report</a>
@endsection

@section('content')
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 d-flex justify-content-end mb-3">
            <button id="printButton" class="btn btn-primary me-3">
                <i class="fas fa-print"></i>Print</button>
            <form action="{{ url('/accounts/pdcm') }}" method="POST">
                @csrf
                <input type="hidden" name="up_till_cheque_date" value="{{ request('up_till_cheque_date') }}">
                <input type="hidden" name="date" value="{{ request('date') }}">
                <input type="hidden" name="show_unposted_record" value="{{ request('show_unposted_record') }}">
                <input type="hidden" name="bank_id" value="{{ request('bank_id') }}">
                <input type="hidden" name="client_id" value="{{ request('client_id') }}">
                <input type="hidden" name="report_type" value="{{ request('report_type') }}">
                <input type="hidden" name="export_type" value="xlsx">
                <button type="submit" class="btn btn-success me-3">Export to Excel</button>
            </form>

            <!-- Export as CSV -->
            <form action="{{ url('/accounts/pdcm') }}" method="POST">
                @csrf
                <input type="hidden" name="up_till_cheque_date" value="{{ request('up_till_cheque_date') }}">
                <input type="hidden" name="date" value="{{ request('date') }}">
                <input type="hidden" name="show_unposted_record" value="{{ request('show_unposted_record') }}">
                <input type="hidden" name="bank_id" value="{{ request('bank_id') }}">
                <input type="hidden" name="client_id" value="{{ request('client_id') }}">
                <input type="hidden" name="report_type" value="{{ request('report_type') }}">

                <input type="hidden" name="export_type" value="csv">
                <button type="submit" class="btn btn-primary">Export to CSV</button>
            </form>
        </div>

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <div class="custom">
                <table class="table table-bordered mt-n2 display nowrap">
                    <thead>
                        <tr>
                            <th>S#</th>
                            <th>Party</th>
                            <th>Cheque #</th>
                            <th>Cheque Date</th>
                            <th>Cost Center</th>
                            @if ($report_type == 'all')
                                <th>Receipt</th>
                                <th>Payment</th>
                            @elseif($report_type == 'payment')
                                <th>Payment</th>
                            @elseif($report_type == 'receipt')
                                <th>Receipt</th>
                            @endif
                            <th>particular</th>
                            <th>Voucher #</th>
                            <th>V Date</th>

                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $total_receipt_amount = 0.0;
                            $total_payment_amount = 0.0;
                        @endphp
                        @foreach ($voucherDetails as $parentAccountId => $voucherGroup)
                            @php
                                $receipt_amount = 0.0;
                                $payment_amount = 0.0;
                            @endphp
                            <tr>
                                <td colspan="{{ $report_type == 'all' ? 10 : 9 }}"
                                    style="background-color: LightGrey; font-weight:bolder; font-size:15px">
                                    {{ $voucherGroup->first()->name }}</td>
                            </tr>
                            @foreach ($voucherGroup as $i => $voucher)
                                <tr>
                                    <td>{{ $i + 1 }}</td>
                                    <td>{{ @$voucher->transaction->party->name }}</td>
                                    <td>{{ $voucher->transaction->cheque_number }}</td>
                                    <td>{{ $voucher->transaction->cheque_date }}</td>
                                    <td>HO</td>
                                    @if ($report_type == 'all')
                                        @if ($voucher->transaction->transaction_type_master_id == 2)
                                            <td>{{ $voucher->debit_lc ?? $voucher->credit_lc }}</td>
                                        @else
                                            <td>0.00</td>
                                        @endif
                                        @if ($voucher->transaction->transaction_type_master_id == 1)
                                            <td>{{ $voucher->debit_lc ?? $voucher->credit_lc }}</td>
                                        @else
                                            <td>0.00</td>
                                        @endif
                                    @elseif($report_type == 'payment')
                                        @if ($voucher->transaction->transaction_type_master_id == 1)
                                            <td>{{ $voucher->debit_lc ?? $voucher->credit_lc }}</td>
                                        @else
                                            <td>0.00</td>
                                        @endif
                                    @elseif($report_type == 'receipt')
                                        @if ($voucher->transaction->transaction_type_master_id == 2)
                                            <td>{{ $voucher->debit_lc ?? $voucher->credit_lc }}</td>
                                        @else
                                            <td>0.00</td>
                                        @endif
                                    @endif
                                    <td>{{ $voucher->narration }}</td>
                                    <td>{{ $voucher->voucher_no }}</td>
                                    <td>{{ $voucher->date }}</td>
                                </tr>
                                @php
                                    if ($report_type == 'all') {
                                        if ($voucher->transaction->transaction_type_master_id == 2) {
                                            $receipt_amount += $voucher->debit_lc ?? $voucher->credit_lc;
                                            $payment_amount += 0;
                                        } else {
                                            $payment_amount += $voucher->debit_lc ?? $voucher->credit_lc;
                                            $receipt_amount += 0;
                                        }
                                    } elseif ($report_type == 'payment') {
                                        if ($voucher->transaction->transaction_type_master_id == 2) {
                                            $receipt_amount += $voucher->debit_lc ?? $voucher->credit_lc;
                                            $payment_amount += 0;
                                        }
                                    } elseif ($report_type == 'receipt') {
                                        if ($voucher->transaction->transaction_type_master_id == 1) {
                                            $payment_amount += $voucher->debit_lc ?? $voucher->credit_lc;
                                            $receipt_amount += 0;
                                        }
                                    }

                                @endphp
                            @endforeach
                            <tr style="background-color: LightGrey;">
                                <td colspan="5" style="font-weight:bolder; font-size:15px; text-align:right">TOTAL</td>
                                @if ($report_type == 'all')
                                    <td style="font-weight:bolder; font-size:15px">{{ $receipt_amount }}</td>
                                    <td style="font-weight:bolder; font-size:15px">{{ $payment_amount }}</td>
                                @elseif($report_type == 'payment')
                                    <td style="font-weight:bolder; font-size:15px">{{ $payment_amount }}</td>
                                @elseif($report_type == 'receipt')
                                    <td style="font-weight:bolder; font-size:15px">{{ $receipt_amount }}</td>
                                @endif

                                <td colspan="3"></td>
                            </tr>
                            @php
                                $total_receipt_amount += $receipt_amount;
                                $total_payment_amount += $payment_amount;
                            @endphp
                        @endforeach


                    </tbody>

                </table>
            </div>
        </div>
    </div>

       <script>
        document.getElementById("printButton").addEventListener("click", function() {
            var printContents = document.querySelector(".custom").innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = `
                <html>
                    <head>
                        <title>PDCM Matured Report - YARAN</title>
                        <style>
                            html {
                                background-color: white;
                            }
                            body {
                                font-family: Arial, sans-serif;
                                background-color: white;
                            }
                            table {
                                width: 100%;
                                border-collapse: collapse;
                                margin-bottom: 20px;
                            }
                            th, td {
                                border: 1px solid #ddd;
                                padding: 8px;
                                text-align: left;
                            }
                            th {
                                background-color: #f2f2f2;
                            }
                            h1 {
                                text-align: center;
                            }
                        </style>
                    </head>
                    <body>
                        <div style="display: flex; flex-wrap: wrap; align-items: center; margin-top: 2rem; text-align: center; margin-bottom: 10px;">
                            <div style="flex-grow: 1;">
                                <h2 style="font-size: 20px !important; font-weight: bold; text-align: center; text-transform: uppercase;">
                                    PDCM Matured Report
                                </h2>
                        </div>
                        <div style="margin-top: 10px">
                            ${printContents}
                        </div>
                    </body>
                </html>
            `;

            window.print();
            document.body.innerHTML = originalContents;
            location.reload(); // Reload to restore the original content
        });
    </script>
@endsection
