@extends('layout.master')

@section('title')
    Trial Balance Report-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Trial Balance Report</a>
@endsection

<style>
    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }

    th,
    td {
        border: 1px solid #ddd;
        padding: 8px;
        text-align: left;
    }

    th {
        background-color: #f2f2f2;
    }

    .grey {
        background-color: rgba(45, 55, 72, 0.05) !important;
    }
</style>

@section('content')
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>

        <div class="intro-y g-col-12 d-flex justify-content-end mb-3">
            <button id="printButton" class="btn btn-primary me-3">
                <i class="fas fa-print"></i> Print
            </button>
            <!-- Export as Excel -->
            <form action="{{ url('/accounts/trial-balance') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">

                {{-- @if (is_array(request('parent_account_id'))) --}}
                {{-- @foreach (request('parent_account_id') as $parent_id) --}}
                <input type="hidden" name="parent_account_id" value="{{ request('parent_account_id') }}">
                {{-- @endforeach --}}
                {{-- @endif --}}

                @if (is_array(request('child_account')))
                    @foreach (request('child_account') as $child_id)
                        <input type="hidden" name="child_account[]" value="{{ $child_id }}">
                    @endforeach
                @endif


                <input type="hidden" name="export_type" value="xlsx">
                <button type="submit" class="btn btn-success me-3">Export to Excel</button>
            </form>

            <!-- Export as CSV -->
            <form action="{{ url('/accounts/trial-balance') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">


                {{-- @if (is_array(request('parent_account_id'))) --}}
                {{-- @foreach (request('parent_account_id') as $parent_id) --}}
                <input type="hidden" name="parent_account_id" value="{{ request('parent_account_id') }}">
                {{-- @endforeach --}}
                {{-- @endif --}}

                @if (is_array(request('child_account')))
                    @foreach (request('child_account') as $child_id)
                        <input type="hidden" name="child_account[]" value="{{ $child_id }}">
                    @endforeach
                @endif

                <input type="hidden" name="export_type" value="csv">
                <button type="submit" class="btn btn-primary">Export to CSV</button>
            </form>

        </div>

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <div class="custom">

                <table class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>Account Code</th>
                            <th>Account Name</th>
                            @if ($report_type == 2)
                                <th>Debit (Opening)</th>
                                <th>Credit (Opening)</th>
                                <th>Debit (Current Period)</th>
                                <th>Credit (Current Period)</th>
                            @endif
                            <th>Debit (Balance)</th>
                            <th>Credit (Balance)</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            if (!function_exists('toRoman')) {
                                function toRoman($num, $lower = false)
                                {
                                    $map = [
                                        'M' => 1000,
                                        'CM' => 900,
                                        'D' => 500,
                                        'CD' => 400,
                                        'C' => 100,
                                        'XC' => 90,
                                        'L' => 50,
                                        'XL' => 40,
                                        'X' => 10,
                                        'IX' => 9,
                                        'V' => 5,
                                        'IV' => 4,
                                        'I' => 1,
                                    ];
                                    $return = '';
                                    foreach ($map as $roman => $int) {
                                        while ($num >= $int) {
                                            $return .= $roman;
                                            $num -= $int;
                                        }
                                    }
                                    return $lower ? strtolower($return) : $return;
                                }
                            }

                            if (!function_exists('renderFixedRomanAccounts')) {
                                function renderFixedRomanAccounts(
                                    $accounts,
                                    $grouped,
                                    $report_type = 1,
                                    &$totals = [],
                                    $depth = 1,
                                ) {
                                    if ($depth > 10) {
                                        return;
                                    }

                                    // Define background colors by level
                                    $bgColors = [
                                        1 => '#808080',
                                        2 => '#a4a4a4',
                                        3 => '#e9e5e4',
                                        4 => '#c5daf0',
                                    ];

                                    foreach ($accounts as $account) {
                                        $hasChildren = isset($grouped[$account->id]);

                                        $balance_opening = $account->opening_debit - $account->opening_credit;
                                        $balance_current = $account->current_debit - $account->current_credit;
                                        $balance = $account->balance_debit - $account->balance_credit;

                                        // Track child totals to print subtotals
                                        $childTotals = [
                                            'opening_debit' => max(0, $balance_opening),
                                            'opening_credit' => max(0, -$balance_opening),
                                            'current_debit' => max(0, $balance_current),
                                            'current_credit' => max(0, -$balance_current),
                                            'balance_debit' => max(0, $balance),
                                            'balance_credit' => max(0, -$balance),
                                        ];

                                        $totals['opening_debit'] += $childTotals['opening_debit'];
                                        $totals['opening_credit'] += $childTotals['opening_credit'];
                                        $totals['current_debit'] += $childTotals['current_debit'];
                                        $totals['current_credit'] += $childTotals['current_credit'];
                                        $totals['balance_debit'] += $childTotals['balance_debit'];
                                        $totals['balance_credit'] += $childTotals['balance_credit'];
                                        $shouldRender = true;
                                        if (!empty(request('exclude_zero_balance'))) {
                                            $shouldRender = ($balance_opening != 0 || $balance_current != 0 || $balance != 0 || $hasChildren);
                                        }
                                        
                                        if ($shouldRender) {
    
                                            $label = toRoman($depth) . '.';
                                            $padding = ($depth - 1) * 20;
                                            $bgColor = $bgColors[$depth] ?? '#ffffff';
    
                                            echo '<tr style="background-color:' . $bgColor . '">';
                                            echo '<td rowspan="2">' . $account->account_id . '</td>';
                                            echo '<td rowspan="2" style="padding-left:' .
                                                $padding .
                                                'px;">' .
                                                $label .
                                                ' ' .
                                                $account->account_name .
                                                '</td>';
    
                                            if ($report_type == 2) {
                                                echo '<td>' .
                                                    ($balance_opening > 0 ? number_format($balance_opening, 2) : '') .
                                                    '</td>';
                                                echo '<td>' .
                                                    ($balance_opening < 0 ? number_format(abs($balance_opening), 2) : '') .
                                                    '</td>';
                                                echo '<td>' .
                                                    ($balance_current > 0 ? number_format($balance_current, 2) : '') .
                                                    '</td>';
                                                echo '<td>' .
                                                    ($balance_current < 0 ? number_format(abs($balance_current), 2) : '') .
                                                    '</td>';
                                            }
    
                                            echo '<td>' . ($balance > 0 ? number_format($balance, 2) : '') . '</td>';
                                            echo '<td>' . ($balance < 0 ? number_format(abs($balance), 2) : '') . '</td>';
                                            echo '</tr><tr></tr>';
                                        }   
                                        // Render child accounts recursively
                                        if ($hasChildren) {
                                            $childTotals = [
                                                'opening_debit' => 0,
                                                'opening_credit' => 0,
                                                'current_debit' => 0,
                                                'current_credit' => 0,
                                                'balance_debit' => 0,
                                                'balance_credit' => 0,
                                            ];

                                            renderFixedRomanAccounts(
                                                $grouped[$account->id],
                                                $grouped,
                                                $report_type,
                                                $childTotals,
                                                $depth + 1,
                                            );

                                            // After recursive call, add child's totals to parent totals
                                            $totals['opening_debit'] += $childTotals['opening_debit'];
                                            $totals['opening_credit'] += $childTotals['opening_credit'];
                                            $totals['current_debit'] += $childTotals['current_debit'];
                                            $totals['current_credit'] += $childTotals['current_credit'];
                                            $totals['balance_debit'] += $childTotals['balance_debit'];
                                            $totals['balance_credit'] += $childTotals['balance_credit'];

                                            // Render subtotal row after children
                                            echo '<tr style="font-weight: bold; background-color: #f2f2f2;">';
                                            echo '<td colspan="2" style="text-align:right;">SUBTOTAL FOR ' . $account->account_name . '</td>';

                                            if ($report_type == 2) {
                                                echo '<td>' . number_format($childTotals['opening_debit'], 2) . '</td>';
                                                echo '<td>' . number_format($childTotals['opening_credit'], 2) . '</td>';
                                                echo '<td>' . number_format($childTotals['current_debit'], 2) . '</td>';
                                                echo '<td>' . number_format($childTotals['current_credit'], 2) . '</td>';
                                            }

                                            echo '<td>' . number_format($childTotals['balance_debit'], 2) . '</td>';
                                            echo '<td>' . number_format($childTotals['balance_credit'], 2) . '</td>';
                                            echo '</tr>';
                                        }
                                    }
                                }
                            }

                            $grouped = collect($trialBalance)->groupBy('parent_account_id');
                            $totals = [
                                'opening_debit' => 0,
                                'opening_credit' => 0,
                                'current_debit' => 0,
                                'current_credit' => 0,
                                'balance_debit' => 0,
                                'balance_credit' => 0,
                            ];

                            $topLevel = $grouped[null] ?? ($grouped[0] ?? []);

                            foreach ($topLevel as $parentAccount) {
                                $hasChildren = isset($grouped[$parentAccount->id]);
                                // Render I. parent account
                                $balance_opening = $parentAccount->opening_debit - $parentAccount->opening_credit;
                                $balance_current = $parentAccount->current_debit - $parentAccount->current_credit;
                                $balance = $parentAccount->balance_debit - $parentAccount->balance_credit;
                                
                                $shouldRender = true;
                                if (!empty(request('exclude_zero_balance'))) {
                                    $shouldRender = ($balance_opening != 0 || $balance_current != 0 || $balance != 0 || $hasChildren);
                                }
                            
                                if (!$shouldRender) {
                                    continue; // skip this parent if truly empty and no children
                                }


                                $totals['opening_debit'] += max(0, $balance_opening);
                                $totals['opening_credit'] += max(0, -$balance_opening);
                                $totals['current_debit'] += max(0, $balance_current);
                                $totals['current_credit'] += max(0, -$balance_current);
                                $totals['balance_debit'] += max(0, $balance);
                                $totals['balance_credit'] += max(0, -$balance);

                                echo '<tr style="background-color:#808080; font-weight: bold;">';
                                echo '<td rowspan="2">' . $parentAccount->account_id . '</td>';
                                echo '<td rowspan="2"><strong>I.</strong> ' . $parentAccount->account_name . '</td>';

                                if ($report_type == 2) {
                                    echo '<td>' .
                                        ($balance_opening > 0 ? number_format($balance_opening, 2) : '') .
                                        '</td>';
                                    echo '<td>' .
                                        ($balance_opening < 0 ? number_format(abs($balance_opening), 2) : '') .
                                        '</td>';
                                    echo '<td>' .
                                        ($balance_current > 0 ? number_format($balance_current, 2) : '') .
                                        '</td>';
                                    echo '<td>' .
                                        ($balance_current < 0 ? number_format(abs($balance_current), 2) : '') .
                                        '</td>';
                                }

                                echo '<td>' . ($balance > 0 ? number_format($balance, 2) : '') . '</td>';
                                echo '<td>' . ($balance < 0 ? number_format(abs($balance), 2) : '') . '</td>';
                                echo '</tr><tr></tr>';

                                // Render children
                                if (isset($grouped[$parentAccount->id])) {
                                    renderFixedRomanAccounts(
                                        $grouped[$parentAccount->id],
                                        $grouped,
                                        $report_type,
                                        $totals,
                                        2, // child starts from level 2
                                    );
                                }
                            }
                        @endphp
                    </tbody>
                    <tfoot>
                        <tr>
                            <th class="fw-bold">Total</th>
                            <th></th>
                            @if ($report_type == 2)
                                <th class="fw-bold">{{ number_format($totals['opening_debit'], 2) }}</th>
                                <th class="fw-bold">{{ number_format($totals['opening_credit'], 2) }}</th>
                                <th class="fw-bold">{{ number_format($totals['current_debit'], 2) }}</th>
                                <th class="fw-bold">{{ number_format($totals['current_credit'], 2) }}</th>
                            @endif
                            <th class="fw-bold">{{ number_format($totals['balance_debit'], 2) }}</th>
                            <th class="fw-bold">{{ number_format($totals['balance_credit'], 2) }}</th>
                        </tr>
                    </tfoot>


                </table>
            </div>
        </div>
        <!-- Container-fluid Ends-->
    </div>

    <script>
        document.getElementById("printButton").addEventListener("click", function() {
            var printContents = document.querySelector(".custom").innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = `
                <html>
                    <head>
                        <title>Trial Balance Report - YARAN</title>
                        <style>
                            html {
                                background-color: white;
                            }
                            body {
                                font-family: Arial, sans-serif;
                                background-color: white;
                            }
                            table {
                                width: 100%;
                                border-collapse: collapse;
                                margin-bottom: 20px;
                            }
                            th, td {
                                border: 1px solid #ddd;
                                padding: 8px;
                                text-align: left;
                            }
                            th {
                                background-color: #f2f2f2;
                            }
                            h1 {
                                text-align: center;
                            }
                            .grey {
                                background-color: rgba(45, 55, 72, 0.05) !important;
                            }
                        </style>
                    </head>
                    <body>
                        <div style="display: flex; flex-wrap: wrap; align-items: center; margin-top: 2rem; text-align: center; margin-bottom: 10px;">
                            <div style="flex-grow: 1;">
                                <h2 style="font-size: 20px !important; font-weight: bold; text-align: center; text-transform: uppercase;">
                                    Trial Balance Report
                                </h2>
                        </div>
                        <div style="margin-top: 10px">
                            ${printContents}
                        </div>
                    </body>
                </html>
            `;

            window.print();
            document.body.innerHTML = originalContents;
            location.reload(); // Reload to restore the original content
        });
    </script>
@endsection
