@extends('layout.master')

@section('title')
    ADD-AIRPORTS-YARAN
@endsection

@section('topbar')
    <a href="/airports" class="breadcrumb-item">Airports</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a
        href="" class="breadcrumb--active">Add</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ route('airports.store') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Add Airport
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="col-md-6">
                                    <label for="regular-form-1" class="form-label">Name</label>
                                    <input id="regular-form-1" type="text" class="form-control name-validate"
                                        placeholder="Enter Name" name="name">
                                    <span class="text-danger validation-name" style="display: none;">
                                        <i class="mdi mdi-alert"></i> Name is invalid
                                    </span>
                                </div>
                                <div class="col-md-6">
                                    <label>City</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select City" id="city_id" name="city_id"
                                            class="tom-select w-full">
                                            @foreach ($cities as $city)
                                                <option value="{{ $city->id }}">{{ $city->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6 mt-2">
                                    <label>Country</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Country" id="country_id" name="country_id"
                                            class="tom-select w-full">
                                            @foreach ($countries as $country)
                                                <option value="{{ $country->id }}">{{ $country->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6 mt-2">
                                    <label>Status</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Status" id="status" name="status"
                                            class="tom-select w-full">
                                            <option value="1">Active</option>
                                            <option value="0">In Active</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
            </form>
        </div>
    </div>
    </div>
    </div>
    </div>
@endsection
