@extends('layout.master')

@section('title')
EDIT-AIRPORTS-YARAN
@endsection

@section('topbar')
<a href="/airports" class="breadcrumb-item">Airports</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            {{ Form::model($airport, ['route' => ['airports.update', $airport->id], 'method' => 'PUT']) }}
            <div class="intro-y box">
                <div
                    class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                    <h2 class="fw-medium fs-base me-auto">
                        Edit Airport
                    </h2>
                    
                    <button type="submit" class="btn btn-primary submitBtn"
                        id="submitBtn">Save</button>
                    <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                        Back
                    </a>
                </div>

                <div id="input" class="p-5">
                    <div class=" col-md-12">
                        <div class="row mb-5">
                            <div class="col-md-6">
                                <label for="regular-form-1" class="form-label">Name</label>
                                <input id="regular-form-1" type="text" class="form-control name-validate"
                                    value="{{ $airport->name }}" placeholder="Enter Name" name="name">
                                <span class="text-danger validation-name" style="display: none;">
                                    <i class="mdi mdi-alert"></i> Name is invalid
                                </span>
                            </div>
                            <div class="col-md-6">
                                <label>City</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select City" id="city_id" name="city_id"
                                        class="tom-select w-full">
                                        @foreach ($cities as $city)
                                            <option {{ $airport->city_id == $city->id ? 'selected' : '' }}
                                                value="{{ $city->id }}">{{ $city->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6 mt-2">
                                <label>Country</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Country" id="country_id" name="country_id"
                                        class="tom-select w-full">
                                        @foreach ($countries as $country)
                                            <option {{ $airport->country_id == $country->id ? 'selected' : '' }}
                                                value="{{ $country->id }}">{{ $country->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6 mt-2">
                                <label>Status</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select your favorite Status" id="status" name="status"
                                        class="tom-select w-full">
                                        <option {{ $airport->status == 1 ? 'selected' : '' }} value="1">
                                            Active
                                        </option>
                                        <option {{ $airport->status == 0 ? 'selected' : '' }} value="0">
                                            InActive
                                        </option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
