@extends('layout.master')

@section('title')
AIRPORTS-YARAN
@endsection


@section('topbar')
<a href="/airports" class="breadcrumb--active">Airports</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Airports
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('airports.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $airports->firstItem() }} to
                {{ $airports->lastItem() }} of {{ $airports->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Name</th>
                        <th>City</th>
                        <th>Country</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($airports as $chargescategory)
                        <tr>
                            <td>{{ $chargescategory->id }}</td>
                            <td>{{ $chargescategory->name }}</td>
                            <td>{{ $chargescategory->city->name }}</td>
                            <td>{{ $chargescategory->country->name }}</td>
                            <td>{{ $chargescategory->status == 1 ? 'Active' : 'InActive' }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('airports.edit', [$chargescategory->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['airports.destroy', $chargescategory->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
