@extends('auth.layout.app')
@section('content')
    <!-- BEGIN: Login Info -->
    <div class="g-col-2 g-col-xl-1 d-none d-xl-flex flex-column min-vh-screen">
        <a href="" class="-intro-x d-flex align-items-center pt-5">
            <img alt="Rubick Bootstrap HTML Admin Template" class="" width="200px"
                src="{{ url('/logo-white-1-1.png') }}">
            {{-- <span class="text-white fs-lg ms-3"> Ru<span class="fw-medium">bick</span> </span> --}}
        </a>
        <div class="my-auto">
            <img alt="Rubick Bootstrap HTML Admin Template" class="-intro-x w-1/2 mt-n16" src="dist/images/illustration.svg">
            <div class="-intro-x text-white fw-medium fs-4xl lh-base mt-10">
                YARAN SHIPPING<br> LINE
            </div>
            {{-- <div class="-intro-x mt-5 fs-lg text-white text-opacity-70 dark-text-gray-500">Manage all your e-commerce accounts in one place</div> --}}
        </div>
    </div>
    <!-- END: Login Info -->
    <!-- BEGIN: Login Form -->
    <div class="g-col-2 g-col-xl-1 h-screen h-xl-auto d-flex py-5 py-xl-0 my-10 my-xl-0">
        <div
            class="my-auto mx-auto ms-xl-20 bg-white dark-bg-dark-1 bg-xl-transparent px-5 px-sm-8 py-8 p-xl-0 rounded-2 shadow-md shadow-xl-none w-full w-sm-3/4 w-lg-2/4 w-xl-auto">
            <h2 class="intro-x fw-bold fs-2xl fs-xl-3xl text-center text-xl-start">
                Forgot Password
            </h2>
            {{-- <div class="intro-x mt-2 text-gray-500 d-xl-none text-center">A few more clicks to sign in to your account.
                Manage all your e-commerce accounts in one place</div> --}}

            <form action="{{ route('forgot.password.link') }}" method="post" id="formAuthentication" class="mb-3"
                action="auth-reset-password-cover.html">
                @if (Session::get('fail'))
                    <div class="alert alert-danger">
                        {{ Session::get('fail') }}
                    </div>
                @endif

                @if (Session::get('success'))
                    <div class="alert alert-success">
                        {{ Session::get('success') }}
                    </div>
                @endif
                @csrf
                <div class="intro-x mt-8">
                    <input type="text" class="intro-x login__input form-control py-3 px-4 border-gray-300 d-block"
                        placeholder="Email" value="{{ old('email') }}"  name="email">
                    <span class="text-danger">
                        @error('email')
                            {{ $message }}
                        @enderror
                    </span>

                </div>

                <div class="intro-x mt-5 mt-xl-8 text-center text-xl-start">
                    <button class="btn btn-primary py-3 px-4  align-top">Send Reset Link</button>
                    {{-- <button class="btn btn-outline-secondary py-3 px-4 w-full w-xl-32 mt-3 mt-xl-0 align-top">Sign up</button> --}}
                </div>
            </form>
            <div class="text-center mt-20">
                <a href="/"></i>
                    Back to login
                </a>
            </div>
            {{-- <div class="intro-x mt-10 mt-xl-24 text-gray-700 dark-text-gray-600 text-center text-xl-start">
                By signin up, you agree to our
                <br>
                <a class="text-theme-1 dark-text-theme-10" href="">Terms and Conditions</a> & <a class="text-theme-1 dark-text-theme-10" href="">Privacy Policy</a>
            </div> --}}
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.27/dist/sweetalert2.all.min.js"></script>


    @if (session()->has('password_success'))
        <script>
            Swal.fire({
                toast: true,
                position: 'top-end',
                icon: 'success',
                title: 'We have e-mailed your password reset link!',
                showConfirmButton: false,
                heightAuto: false,
                timer: 4000
            })
        </script>
    @endif
@endsection
