@extends('layout.master')

@section('title')
EDIT-Charges Category-YARAN
@endsection

@section('topbar')
<a href="/charges" class="breadcrumb-item">Charges</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            {{ Form::model($charge, ['route' => ['charges.update', $charge->id], 'method' => 'PUT']) }}
            <div class="intro-y box">
                <div
                    class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                    <h2 class="fw-medium fs-base me-auto">
                        Edit Charges
                    </h2>

                    <button type="submit" class="btn btn-primary submitBtn"
                        id="submitBtn">Save</button>
                    <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                        Back
                    </a>
                </div>

                <div id="input" class="p-5">
                    <div class=" col-md-12">
                        <div class="row mb-5">
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Code</label>
                                <input id="regular-form-1" type="text" class="form-control" placeholder="Enter Code" value="{{ $charge->code }}"
                                    name="code">
                            </div>
                            <div class="col-md-6 mt-2">
                                <label>Currency</label>
                                <div class="mt-2">
                                  <select data-placeholder="Select Currency" id="currency_id" name="currency_id"
                                        class="tom-select w-full">
                                        <option value="">Please select</option>
                                        <option {{ $charge->currency_id == 1 ? 'selected' : '' }}
                                            value="1">PKR</option>
                                        <option {{ $charge->currency_id == 2 ? 'selected' : '' }}
                                            value="2">USD</option>
                                        <option {{ $charge->currency_id == 3 ? 'selected' : '' }}
                                            value="3">AED</option>
                                        <option {{ $charge->currency_id == 4 ? 'selected' : '' }}
                                            value="4">GBP</option>
                                        <option {{ $charge->currency_id == 5 ? 'selected' : '' }}
                                            value="5">EUR</option>
                                        <option {{ $charge->currency_id == 6 ? 'selected' : '' }}
                                            value="6">BDT</option>
                                        <option {{ $charge->currency_id == 7 ? 'selected' : '' }}
                                            value="7">OMR</option>
                                    </select>
                                    <!--<select data-placeholder="Select Currency" id="currency_id" name="currency_id"-->
                                    <!--    class="tom-select w-full">-->
                                    <!--    <option {{ $charge->currency_id == 1 ? 'selected' : '' }} value="1">USD-->
                                    <!--    </option>-->
                                    <!--    <option {{ $charge->currency_id == 2 ? 'selected' : '' }} value="2">PKR-->
                                    <!--    </option>-->
                                    <!--    <option {{ $charge->currency_id == 3 ? 'selected' : '' }} value="3">AED-->
                                    <!--    </option>-->
                                    <!--    <option {{ $charge->currency_id == 4 ? 'selected' : '' }} value="4">BDT-->
                                    <!--    </option>-->
                                    <!--    <option {{ $charge->currency_id == 5 ? 'selected' : '' }} value="5">OMR-->
                                    <!--    </option>-->
                                    <!--    <option {{ $charge->currency_id == 6 ? 'selected' : '' }} value="6">EUR-->
                                    <!--    </option>-->
                                    <!--    <option {{ $charge->currency_id == 7 ? 'selected' : '' }} value="7">GBP-->
                                    <!--    </option>-->
                                    <!--</select>-->
                                </div>
                            </div>
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Name</label>
                                <input id="regular-form-1" value="{{ $charge->name }}" type="text" class="form-control"
                                    placeholder="Enter Name" name="name">
                            </div>
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Short Name</label>
                                <input id="regular-form-1" type="text" class="form-control"
                                    placeholder="Enter Short Name" value="{{ $charge->short_name }}" name="short_name">
                            </div>
                            <div class="col-md-6 mt-2">
                                <label>Charge Type</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Charge Type" id="charges_type" name="charges_type"
                                        class="tom-select w-full">
                                        <option {{ $charge->charges_type == 1 ? 'selected' : '' }} value="1">
                                            Principle</option>
                                        <option {{ $charge->charges_type == 2 ? 'selected' : '' }} value="2">Agency
                                        </option>
                                        <option {{ $charge->charges_type == 3 ? 'selected' : '' }} value="3">None
                                        </option>
                                        <option {{ $charge->charges_type == 4 ? 'selected' : '' }} value="4">
                                            Reimbursement</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Order</label>
                                <input id="regular-form-1" value="{{ $charge->order }}" type="text" class="form-control"
                                    placeholder="Enter Order" name="order">
                            </div>
                            <div class="col-md-6 mt-2">
                                <label>Type</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Type" id="type" name="type"
                                        class="tom-select w-full">
                                        <option {{ $charge->type == 1 ? 'selected' : '' }} value="1">Import</option>
                                        <option {{ $charge->type == 2 ? 'selected' : '' }} value="2">Clearing
                                        </option>
                                        <option {{ $charge->type == 3 ? 'selected' : '' }} value="3">Dentention
                                        </option>
                                        <option {{ $charge->type == 4 ? 'selected' : '' }} value="4">Plugin Charges
                                        </option>
                                        <option {{ $charge->type == 5 ? 'selected' : '' }} value="5">Late Charges
                                        </option>
                                        <option {{ $charge->type == 6 ? 'selected' : '' }} value="6">Storage</option>
                                        <option {{ $charge->type == 7 ? 'selected' : '' }} value="7">Cleaning
                                        </option>
                                        <option {{ $charge->type == 8 ? 'selected' : '' }} value="8">Placement
                                            Charges</option>
                                        <option {{ $charge->type == 9 ? 'selected' : '' }} value="9">Depot Per Move
                                            Charges</option>
                                        <option {{ $charge->type == 10 ? 'selected' : '' }} value="10">Depot Storage
                                            Charges</option>
                                        <option {{ $charge->type == 11 ? 'selected' : '' }} value="11">Tax</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6 mt-2">
                                <label>Reporting Group</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Reporting Group" id="reporting_group"
                                        name="reporting_group" class="tom-select w-full">
                                        <option {{ $charge->reporting_group == 1 ? 'selected' : '' }} value="1">
                                            Freight</option>
                                        <option {{ $charge->reporting_group == 2 ? 'selected' : '' }} value="2">
                                            Insurance</option>
                                        <option {{ $charge->reporting_group == 3 ? 'selected' : '' }} value="3">D/O
                                        </option>
                                        <option {{ $charge->reporting_group == 4 ? 'selected' : '' }} value="4">THC
                                        </option>
                                        <option {{ $charge->reporting_group == 5 ? 'selected' : '' }} value="5">CSC
                                        </option>
                                        <option {{ $charge->reporting_group == 6 ? 'selected' : '' }} value="6">
                                            Movement</option>
                                        <option {{ $charge->reporting_group == 7 ? 'selected' : '' }} value="7">
                                            Detention</option>
                                        <option {{ $charge->reporting_group == 8 ? 'selected' : '' }} value="8">
                                            Washing</option>
                                        <option {{ $charge->reporting_group == 9 ? 'selected' : '' }} value="9">
                                            Repairing</option>
                                        <option {{ $charge->reporting_group == 10 ? 'selected' : '' }} value="10">
                                            Terminal</option>
                                        <option {{ $charge->reporting_group == 11 ? 'selected' : '' }} value="11">
                                            Yard</option>
                                        <option {{ $charge->reporting_group == 12 ? 'selected' : '' }} value="12">
                                            Other</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">TAG</label>
                                <input id="regular-form-1" value="{{ $charge->tag }}" type="text"
                                    class="form-control" placeholder="Enter TAG" name="tag">
                            </div>
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Printing Name</label>
                                <input id="regular-form-1" type="text" class="form-control"
                                    placeholder="Enter Printing Name" value="{{ $charge->printing_name }}"
                                    name="printing_name">
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Calculation Type</label>
                                <div class="d-flex flex-coloumn flex-sm-row mt-2">
                                    <div class="form-check me-2">
                                        <input id="calculation_type" class="form-check-input" type="radio"
                                            name="calculation_type"
                                            {{ $charge->calculation_type == 'per-unit' ? 'checked' : '' }}
                                            value="per-unit">
                                        <label class="form-check-label" for="calculation_type">Per Unit</label>
                                    </div>
                                    <div class="form-check me-2 mt-2 mt-sm-0">
                                        <input id="calculation_type" class="form-check-input" type="radio"
                                            name="calculation_type"
                                            {{ $charge->calculation_type == 'per-shipment' ? 'checked' : '' }}
                                            value="per-shipment">
                                        <label class="form-check-label" for="calculation_type">Per Shipment</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-5 mt-4">
                                <div class="d-flex flex-column flex-sm-row mt-5">
                                    <div class="form-check me-2">
                                        <input id="tax_recievable" {{ $charge->tax_recievable == 1 ? 'checked' : '' }}
                                            name="tax_recievable" class="form-check-input" type="checkbox"
                                            value="1">
                                        <label class="form-check-label" for="tax_recievable">Tax Recievable</label>
                                    </div>
                                    <div class="form-check me-2 mt-2 mt-sm-0">
                                        <input id="tax_payable" name="tax_payable"
                                            {{ $charge->tax_payable == 1 ? 'checked' : '' }} class="form-check-input"
                                            type="checkbox" value="1">
                                        <label class="form-check-label" for="tax_payable">Tax Payable</label>
                                    </div>
                                    <div class="form-check me-2 mt-2 mt-sm-0">
                                        <input id="tax_on_principal" {{ $charge->tax_on_principal == 1 ? 'checked' : '' }}
                                            name="tax_on_principal" class="form-check-input" type="checkbox"
                                            value="1">
                                        <label class="form-check-label" for="tax_on_principal">Tax On Prinicpal
                                            Payment</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 mt-2">
                                <label for="c_category" class="form-label">C Category</label>
                                <input id="c_category" type="text" value="{{ $charge->c_category }}"
                                    class="form-control" placeholder="Enter C Category" name="c_category">
                            </div>
                            <div class="col-md-5 mt-2">
                                <label>Default Payable Party Type</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Default Payable Party Type" id="default_payable"
                                        name="default_payable" class="tom-select w-full">
                                        <option {{ $charge->default_payable == 1 ? 'selected' : '' }} value="1">
                                            L-Agent</option>
                                        <option {{ $charge->default_payable == 2 ? 'selected' : '' }} value="2">
                                            O-Agent</option>
                                        <option {{ $charge->default_payable == 3 ? 'selected' : '' }} value="3">
                                            Terminal</option>
                                        <option {{ $charge->default_payable == 4 ? 'selected' : '' }} value="4">CFS
                                            Facility</option>
                                        <option {{ $charge->default_payable == 5 ? 'selected' : '' }} value="5">
                                            Others</option>
                                        <option {{ $charge->default_payable == 6 ? 'selected' : '' }} value="6">
                                            Principal</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-5 mt-2">
                                <label>Default Recievable Party Type</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Default Recievable Party Type"
                                        id="default_recievable" name="default_recievable" class="tom-select w-full">
                                        <option {{ $charge->default_recievable == 1 ? 'selected' : '' }} value="1">
                                            Client</option>
                                        <option {{ $charge->default_recievable == 2 ? 'selected' : '' }} value="2">
                                            O-Agent</option>
                                        <option {{ $charge->default_recievable == 3 ? 'selected' : '' }} value="3">
                                            Terminal</option>
                                        <option {{ $charge->default_recievable == 4 ? 'selected' : '' }} value="4">
                                            CFS Facility</option>
                                        <option {{ $charge->default_recievable == 5 ? 'selected' : '' }} value="5">
                                            Others</option>
                                        <option {{ $charge->default_recievable == 6 ? 'selected' : '' }} value="6">
                                            Principal</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2 mt-5">
                                <div class="form-check me-2 mt-5">
                                    <input id="sys_gen" {{ $charge->sys_gen == 1 ? 'checked' : '' }} name="sys_gen"
                                        class="form-check-input" type="checkbox" value="1">
                                    <label class="form-check-label" for="sys_gen">Sys Gen</label>
                                </div>
                            </div>
                            <div class="col mt-2-md-8 mt-5">
                                <div class="d-flex flex-column flex-sm-row mt-5">
                                    <div class="form-check me-3">
                                        <input id="sea_import" name="sea_import"
                                            {{ $charge->sea_import == 1 ? 'checked' : '' }} class="form-check-input"
                                            type="checkbox" value="1">
                                        <label class="form-check-label" for="sea_import">Sea Import</label>
                                    </div>
                                    <div class="form-check me-3 mt-2 mt-sm-0">
                                        <input id="sea_export" name="sea_export"
                                            {{ $charge->sea_export == 1 ? 'checked' : '' }} class="form-check-input"
                                            type="checkbox" value="1">
                                        <label class="form-check-label" for="sea_export">Sea Export</label>
                                    </div>
                                    <div class="form-check me-3 mt-2 mt-sm-0">
                                        <input id="air_import" name="air_import"
                                            {{ $charge->air_import == 1 ? 'checked' : '' }} class="form-check-input"
                                            type="checkbox" value="1">
                                        <label class="form-check-label" for="air_import">Air Import</label>
                                    </div>
                                    <div class="form-check me-3 mt-2 mt-sm-0">
                                        <input id="air_export" name="air_export"
                                            {{ $charge->air_export == 1 ? 'checked' : '' }} class="form-check-input"
                                            type="checkbox" value="1">
                                        <label class="form-check-label" for="air_export">Air Export</label>
                                    </div>
                                    <div class="form-check me-3 mt-2 mt-sm-0">
                                        <input id="logistic" name="logistic"
                                            {{ $charge->logistic == 1 ? 'checked' : '' }} class="form-check-input"
                                            type="checkbox" value="1">
                                        <label class="form-check-label" for="logistic">Logistic</label>
                                    </div>
                                    <div class="form-check me-3 mt-2 mt-sm-0">
                                        <input id="warehouse" name="warehouse"
                                            {{ $charge->warehouse == 1 ? 'checked' : '' }} class="form-check-input"
                                            type="checkbox" value="1">
                                        <label class="form-check-label" for="warehouse">Warehouse</label>
                                    </div>
                                    <div class="form-check me-3 mt-2 mt-sm-0">
                                        <input id="other" name="other" {{ $charge->other == 1 ? 'checked' : '' }}
                                            class="form-check-input" type="checkbox" value="1">
                                        <label class="form-check-label" for="other">Other</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 mt-2">
                                <label>Operation Type</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Type" id="operation_type" name="operation_type"
                                        class="tom-select w-full">
                                        <option {{ $charge->operation_type == 'carrier' ? 'selected' : '' }}
                                            value="carrier">Carrier</option>
                                        <option {{ $charge->operation_type == 'agent' ? 'selected' : '' }} value="agent">
                                            Agent</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 mt-2">
                                <label>Carrier</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Type" id="carrier" name="carrier_id"
                                        class="tom-select w-full">
                                        <option {{ $charge->carrier_id == 1 ? 'selected' : '' }} value="1">Carrier
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 mt-2">
                                <label>Billing Type</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Type" id="billing_type" name="billing_type"
                                        class="tom-select w-full">
                                        <option {{ $charge->billing_type == 'customer' ? 'selected' : '' }}
                                            value="customer">Customer</option>
                                        <option {{ $charge->billing_type == 'vendor' ? 'selected' : '' }} value="vendor">
                                            Vendor</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 mt-2">
                                <label>Customer / Vendor</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Type" id="customer_id" name="customer_id"
                                        class="tom-select w-full">
                                        <option {{ $charge->customer_id == 1 ? 'selected' : '' }} value="1">
                                            Customer</option>
                                        <option {{ $charge->customer_id == 2 ? 'selected' : '' }} value="2">
                                            Vendor</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
