@extends('layout.master')

@section('title')
Charges-YARAN
@endsection

@section('topbar')
<a href="/charges" class="breadcrumb--active">Charges</a>
@endsection
@section('content')
    <div class="intro-y d-flex align-items-center">
        <div class="d-flex align-items-center">
            <h2 class="intro-y fs-lg fw-medium mt-10">
                Charges
            </h2>
        </div>
        <div class="ms-auto mt-10">
            <button class="btn btn-primary dark-text-theme-10" type="button" data-bs-toggle="collapse"
                data-bs-target="#charges-filter-collapse" aria-expanded="true" aria-controls="charges-filter-collapse">
                <i data-feather="filter" class="w-4 h-4 me-3"></i> Filters
            </button>
        </div>
    </div>
    <div id="charges-filter-collapse" class="accordion-collapse collapse mt-5" aria-labelledby="charges-filter-content"
        data-bs-parent="#charges-filter-accordion">
        <div class="grid columns-12 gap-6 mt-5">
            <div class="intro-y g-col-12 g-col-lg-12">
                <div class="intro-y box p-5">
                    <form method="GET" action="{{ route('charges.index') }}">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="currency_id" class="form-label">Currency</label>
                                <select name="currency_id" id="currency_id" class="form-control">
                                    <option value="">All</option>
                                    <option value="1" {{ request('currency_id') == 1 ? 'selected' : '' }}>USD</option>
                                    <option value="2" {{ request('currency_id') == 2 ? 'selected' : '' }}>PKR</option>
                                    <option value="3" {{ request('currency_id') == 3 ? 'selected' : '' }}>AED</option>
                                    <option value="4" {{ request('currency_id') == 4 ? 'selected' : '' }}>BDT</option>
                                    <option value="5" {{ request('currency_id') == 5 ? 'selected' : '' }}>OMR</option>
                                    <option value="6" {{ request('currency_id') == 6 ? 'selected' : '' }}>EUR</option>
                                    <option value="7" {{ request('currency_id') == 7 ? 'selected' : '' }}>GBP</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="code" class="form-label">Code</label>
                                <select name="code" id="code" class="form-control">
                                    <option value="">All</option>
                                    @foreach($codes as $code)
                                        <option value="{{ $code }}" {{ request('code') == $code ? 'selected' : '' }}>{{ $code }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="name" class="form-label">Name</label>
                                <select name="name" id="name" class="form-control">
                                    <option value="">All</option>
                                    @foreach($names as $name)
                                        <option value="{{ $name }}" {{ request('name') == $name ? 'selected' : '' }}>{{ $name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="charges_type" class="form-label">Charges Type</label>
                                <select name="charges_type" id="charges_type" class="form-control">
                                    <option value="">All</option>
                                    <option value="1" {{ request('charges_type') == 1 ? 'selected' : '' }}>Principle</option>
                                    <option value="2" {{ request('charges_type') == 2 ? 'selected' : '' }}>Agency</option>
                                    <option value="3" {{ request('charges_type') == 3 ? 'selected' : '' }}>None</option>
                                    <option value="4" {{ request('charges_type') == 4 ? 'selected' : '' }}>Reimbursement</option>
                                </select>
                            </div>
                            <div class="col-md-12 mt-3">
                                <label class="form-label">Operations</label>
                                <div class="d-flex flex-wrap gap-2">
                                    @foreach(['sea_import','sea_export','air_import','air_export','logistic','warehouse','other'] as $op)
                                        <div class="form-check me-2">
                                            <input class="form-check-input" type="checkbox" name="{{ $op }}" id="{{ $op }}" value="1" {{ request($op) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="{{ $op }}">{{ ucwords(str_replace('_',' ', $op)) }}</label>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="col-md-3 mt-4">
                                <button type="submit" class="btn btn-sm btn-elevated-primary w-24">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <circle cx="11" cy="11" r="8" />
                                        <line x1="21" x2="16.65" y1="21" y2="16.65" />
                                    </svg>
                                    Search</button>
                                <a href="{{ route('charges.index') }}" type="button"
                                    class="btn btn-sm btn-elevated-danger w-24">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <line x1="18" x2="6" y1="6" y2="18" />
                                        <line x1="6" x2="18" y1="6" y2="18" />
                                    </svg>
                                    Clear</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!-- END: Form Layout -->
        </div>
    </div>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('charges.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $charges->firstItem() }} to
                {{ $charges->lastItem() }} of {{ $charges->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Name</th>
                        <th>Order</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($charges as $charge)
                        <tr>
                            <td>{{ $charge->id }}</td>
                            <td>{{ $charge->name }}</td>
                            <td>{{ $charge->order }}</td>
                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('charges.edit', [$charge->id]) }}" class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['charges.destroy', $charge->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            {{ $charges->links('pagination::bootstrap-4') }}
        </div>
    </div>
@endsection
