@extends('layout.master')

@section('title')
    Add-Chart of Account-YARAN
@endsection

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.3.12/themes/default/style.min.css" />

@section('topbar')
    <a href="{{ url('accounts/chart_of_account') }}" class="breadcrumb-item">Chart of Account</a><i
        data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-md-7">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('accounts/chart_of_account/add') }}"
                enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Add Chart of Account
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-6">
                                    <label>Parent Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Account" id="parent_account_id"
                                            name="parent_account_id" class="tom-select w-full">
                                            <option value="">Please Select Parent Account</option>
                                            @foreach ($parent_accounts as $account)
                                                <option value="{{ $account->id }}">
                                                    {{ $account->name . ' - ' . $account->account_code }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label for="regular-form-1" class="form-label">Account Code</label>
                                    <input required type="text" class="form-control name-validate"
                                        placeholder="Enter Account Code" name="account_code" id="account_code">
                                    <button class="btn btn-outline-secondary" type="button" id="generateCode">Generate
                                        Code</button>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Name</label>
                                    <input id="name" required type="text" class="form-control name-validate"
                                        placeholder="Enter Name" name="name">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Alias</label>
                                    <input id="alias" type="text" class="form-control name-validate"
                                        placeholder="Enter Alias" name="alias">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Max Child Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Max Child Account" id="max_child_account"
                                            name="max_child_account" class="tom-select w-full">
                                            <option value="99">99</option>
                                            <option value="999">999</option>
                                            <option value="999">999</option>
                                            <option value="9999">9999</option>
                                            <option value="99999">99999</option>
                                            <option value="999999">999999</option>
                                            <option value="9999999">9999999</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Category</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Category" id="category_id" name="category_id"
                                            class="tom-select w-full">
                                            <option value="">Please Select Category</option>
                                            @foreach ($account_categories as $category)
                                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Sub Category</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Sub Category" id="sub_category_id"
                                            name="sub_category_id" class="tom-select w-full">
                                            <option value="">Please Select Sub Category</option>
                                            @foreach ($account_sub_categories as $sub_category)
                                                <option value="{{ $sub_category->id }}">{{ $sub_category->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Reference No</label>
                                    <input id="reference_number" type="text" class="form-control name-validate"
                                        placeholder="Enter Reference No" name="reference_number">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Status</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Status" id="status" name="status"
                                            class="tom-select w-full">
                                            <option value="1">Active</option>
                                            <option value="0">In Active</option>
                                        </select>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>


        <!-- Right side: Tree View -->
        <div class="col-md-5">
            <div id="coaTree"></div>
        </div>

    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.3.12/jstree.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#generateCode').on('click', function() {
                let ref_id = $('#parent_account_id').val();
                $.ajax({
                    url: '/api/generate-account-code?ref_id=' + ref_id,
                    type: 'GET',
                    success: function(response) {
                        $('#account_code').val(response.code);
                    },
                    error: function(xhr) {
                        console.error('Error generating code:', xhr.responseText);
                    }
                });
            });
        })

        $('#coaTree').jstree({
            'core': {
                'data': function(obj, callback) {
                    $.ajax({
                        url: "{{ url('api/get-chart-of-accounts') }}",
                        method: "GET",
                        success: function(data) {
                            callback(data);
                        }
                    });
                }
            }
        });

        $('#coaTree').on("select_node.jstree", function(e, data) {
            let account = data.node.original;
            console.log('account', account);

            $('#account_code').val(account.account_code);
            $('#name').val(account.text);
            $('#alias').val(account.alias);
            $('#reference_number').val(account.reference_no);

            // Update dropdowns for Tom Select properly
            let categorySelect = $('#category_id')[0].tomselect;
            let subCategorySelect = $('#sub_category_id')[0].tomselect;
            let parentAccountSelect = $('#parent_account_id')[0].tomselect;

            if (categorySelect) {
                categorySelect.setValue(account.category);
            }

            if (subCategorySelect) {
                subCategorySelect.setValue(account.sub_category);
            }

            if (parentAccountSelect) {
                parentAccountSelect.setValue(account.parent);
            }
        });
    </script>
@endsection
