@extends('layout.master')


@section('title')
    EDIT-Chart of Account-YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts/chart_of_account/edit', $account->id) }}" class="breadcrumb-item">Chart of Account</a><i
        data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('accounts/chart_of_account/edit', $account->id) }}"
                enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Edit Chart of Account
                        </h2>
                        
                        <button type="submit" class="btn btn-primary submitBtn"
                            id="submitBtn">Save</button>
                        <a href="javascript:history.back()"
                            class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-6">
                                    <label>Parent Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Account" id="parent_account_id"
                                            name="parent_account_id" class="tom-select w-full">
                                            <option value="">Please Select Parent Account</option>
                                            @foreach ($parent_accounts as $parent_account)
                                                <option
                                                    {{ $account->parent_account_id == $parent_account->id ? 'selected' : '' }}
                                                    value="{{ $parent_account->id }}">{{ $parent_account->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label for="regular-form-1" class="form-label">Account Code</label>
                                    <input value="{{ $account->account_code }}" id="regular-form-1" required type="text"
                                        class="form-control name-validate" placeholder="Enter Account Code"
                                        name="account_code">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Name</label>
                                    <input value="{{ $account->name }}" id="regular-form-1" required type="text"
                                        class="form-control name-validate" placeholder="Enter Name" name="name">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Alias</label>
                                    <input value="{{ $account->alias }}" id="regular-form-1" required type="text"
                                        class="form-control name-validate" placeholder="Enter Alias" name="alias">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Max Child Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Max Child Account" id="max_child_account"
                                            name="max_child_account" class="tom-select w-full">
                                            <option {{ $account->max_child_account == '99' ? 'selected' : '' }}
                                                value="99">99</option>
                                            <option {{ $account->max_child_account == '999' ? 'selected' : '' }}
                                                value="999">999</option>
                                            <option {{ $account->max_child_account == '999' ? 'selected' : '' }}
                                                value="999">999</option>
                                            <option {{ $account->max_child_account == '9999' ? 'selected' : '' }}
                                                value="9999">9999</option>
                                            <option {{ $account->max_child_account == '99999' ? 'selected' : '' }}
                                                value="99999">99999</option>
                                            <option {{ $account->max_child_account == '999999' ? 'selected' : '' }}
                                                value="999999">999999</option>
                                            <option {{ $account->max_child_account == '9999999' ? 'selected' : '' }}
                                                value="9999999">9999999</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Category</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Category" id="category_id" name="category_id"
                                            class="tom-select w-full">
                                            <option value="">Please Select Category</option>
                                            @foreach ($account_categories as $category)
                                                <option {{ $account->category_id == $category->id ? 'selected' : '' }}
                                                    value="{{ $category->id }}">{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Sub Category</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Sub Category" id="sub_category_id"
                                            name="sub_category_id" class="tom-select w-full">
                                            <option value="">Please Select Sub Category</option>
                                            @foreach ($account_sub_categories as $sub_category)
                                                <option
                                                    {{ $account->sub_category_id == $sub_category->id ? 'selected' : '' }}
                                                    value="{{ $sub_category->id }}">{{ $sub_category->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Reference No</label>
                                    <input value="{{ $account->reference_number }}" id="regular-form-1" required
                                        type="text" class="form-control name-validate" placeholder="Enter Reference No"
                                        name="reference_number">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Status</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Status" id="status" name="status"
                                            class="tom-select w-full">
                                            <option {{ $account->status == 1 ? 'selected' : '' }} value="1">Active
                                            </option>
                                            <option {{ $account->status == 0 ? 'selected' : '' }} value="0">In Active
                                            </option>
                                        </select>
                                    </div>
                                </div>

                            </div>
            </form>
        </div>
    </div>
    </div>
    </div>
    </div>
@endsection
