@extends('layout.master')

@section('title')
    Manage-Chart of Account-YARAN
@endsection

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.3.12/themes/default/style.min.css" />

@section('topbar')
    <a href="{{ url('accounts/chart_of_account') }}" class="breadcrumb-item">Chart of Account</a>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-md-7">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('accounts/chart_of_account/add') }}"
                enctype="multipart/form-data" class="row g-3">
                <input type="hidden" name="hidden_parent_account_id">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Chart of Account
                        </h2>

                        <button type="button" id="btnAdd" class="btn btn-primary me-2">Add New</button>
                        <button type="button" id="btnEdit" class="btn btn-primary me-2">Edit</button>
                        <button type="button" id="btnDelete" class="btn btn-danger me-2" disabled>Delete</button>
                        <button type="submit" id="btnSubmit" disabled class="btn btn-primary me-2">Submit</button>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-6 d-none">
                                    <label>Parent Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Account" id="parent_account_id"
                                            name="parent_account_id" class="tom-select w-full">
                                            <option value="">Please Select Parent Account</option>
                                            @foreach ($parent_accounts as $account)
                                                <option value="{{ $account->id }}">
                                                    {{ $account->name . ' - ' . $account->account_code }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label for="regular-form-1" class="form-label">Account Code</label>
                                    <input required type="text" class="form-control name-validate"
                                        placeholder="Enter Account Code" name="account_code" id="account_code">
                                    {{-- <button class="btn btn-outline-secondary" type="button" id="generateCode">Generate
                                        Code</button> --}}
                                </div>

                                <div class="col-md-6">
                                    <label for="regular-form-1" class="form-label">Name</label>
                                    <input id="name" required type="text" class="form-control name-validate"
                                        placeholder="Enter Name" name="name">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Alias</label>
                                    <input id="alias" type="text" class="form-control name-validate"
                                        placeholder="Enter Alias" name="alias">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Max Child Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Max Child Account" id="max_child_account"
                                            name="max_child_account" class="tom-select w-full">
                                            <option value="99">99</option>
                                            <option value="999">999</option>
                                            <option value="999">999</option>
                                            <option value="9999">9999</option>
                                            <option value="99999">99999</option>
                                            <option value="999999">999999</option>
                                            <option value="9999999">9999999</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Category</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Category" id="category_id" name="category_id"
                                            class="tom-select w-full">
                                            <option value="">Please Select Category</option>
                                            @foreach ($account_categories as $category)
                                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Sub Category</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Sub Category" id="sub_category_id"
                                            name="sub_category_id" class="tom-select w-full">
                                            <option value="">Please Select Sub Category</option>
                                            @foreach ($account_sub_categories as $sub_category)
                                                <option value="{{ $sub_category->id }}">{{ $sub_category->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Reference No</label>
                                    <input id="reference_number" type="text" class="form-control name-validate"
                                        placeholder="Enter Reference No" name="reference_number">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Allow Voucher Entry</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Allow Voucher Entry" id="allow_voucher_entry"
                                            name="allow_voucher_entry" class="tom-select w-full">
                                            <option value="1">Yes</option>
                                            <option value="0">No</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Status</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Status" id="status" name="status"
                                            class="form-control w-full">
                                            <option value="1">Active</option>
                                            <option value="0">In Active</option>
                                        </select>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>


        <!-- Right side: Tree View -->
        <div class="col-md-5">
            <div class="row">
                <div class="col-md-6 mb-5">
                    <label for="search-input" class="form-label">Search Accounts</label>
                    <input type="text" id="search-input" class="form-control" placeholder="Search by Account Code or Name">
                </div>
                <div class="col-md-6 mt-5">
                    <button type="button" id="exportBtn" class="btn btn-success me-2 mt-2">Export to Excel</button>
                </div>
            </div>

            <div id="coaTree"></div>
        </div>

    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.1/xlsx.full.min.js"></script>


    <script>
        $(document).ready(function () {

            let working_type = '';
            let parent_account;
            let url = '';
            let account_id = '';

            $('#generateCode').on('click', function () {
                let ref_id = $('#parent_account_id').val();
                $.ajax({
                    url: '/api/generate-account-code?ref_id=' + ref_id,
                    type: 'GET',
                    success: function (response) {
                        $('#account_code').val(response.code);
                    },
                    error: function (xhr) {
                        console.error('Error generating code:', xhr.responseText);
                    }
                });
            });

            $('#coaTree').jstree({
                'core': {
                    'data': function (obj, callback) {
                        $.ajax({
                            url: "{{ url('api/get-chart-of-accounts') }}",
                            method: "GET",
                            success: function (data) {
                                console.log('data', data);
                                callback(data);
                            }
                        });
                    }
                },
                "plugins": ["search", "themes"]
            });

            $('#search-input').on('keyup', function () {
                var searchTerm = $(this).val().toLowerCase();
                // console.log('searchTerm', searchTerm);
                $('#coaTree').jstree(true).search(searchTerm);
                // $('#coaTree').jstree("search", searchTerm);
            });

            $('#exportBtn').on('click', function () {
                // Fetch the data from the API instead of using jstree data
                $.ajax({
                    url: "{{ url('api/get-chart-of-accounts-excel') }}",  // Replace with your API endpoint
                    method: "GET",
                    success: function (data) {
                        // Prepare data for export
                        let accountsData = [];

                        // Process the response from the API to the format you need
                        data.forEach(function (node) {
                            accountsData.push({
                                "Account No": node.account_code || "",  // Account code (Account No)
                                "Account Title": node.name,  // Account Title (splitting the text if needed)
                                "Category": node.category || "",  // Category Name (use your logic here)
                                "Sub Category": node.sub_category || ""  // Sub Category Name (use your logic here)
                            });
                        });

                        // Create Excel file using SheetJS (xlsx)
                        const ws = XLSX.utils.json_to_sheet(accountsData);
                        const wb = XLSX.utils.book_new();
                        XLSX.utils.book_append_sheet(wb, ws, "Chart of Accounts");

                        // Download the Excel file
                        XLSX.writeFile(wb, "chart_of_accounts.xlsx");
                    },
                    error: function (xhr, status, error) {
                        console.error("Error fetching data for export: ", error);
                        alert("Error fetching data for export. Please try again.");
                    }
                });
            });


            $('#coaTree').on("select_node.jstree", function (e, data) {
                let account = data.node.original;
                // console.log('account', account);
                account_id = account.id;

                $('#btnDelete').removeAttr('disabled');

                $('#account_code').val(account.account_code);
                $('#name').val(account.text.split('-')[0].trim());
                $('#alias').val(account.alias);
                $('#reference_number').val(account.reference_no);
                $('#parent_account_id').val(account.id);
                $('#status').val(account.status);

                // Update dropdowns for Tom Select properly
                let categorySelect = $('#category_id')[0].tomselect;
                let subCategorySelect = $('#sub_category_id')[0].tomselect;
                let parentAccountSelect = $('#parent_account_id')[0].tomselect;
                let allowVoucherEntry = $('#allow_voucher_entry')[0].tomselect;

                if (categorySelect) {
                    categorySelect.setValue(account.category);
                }

                if (subCategorySelect) {
                    subCategorySelect.setValue(account.sub_category);
                }

                if (parentAccountSelect) {
                    parentAccountSelect.setValue(account.id);
                }

                if (allowVoucherEntry) {
                    allowVoucherEntry.setValue(account.allow_voucher_entry);
                }

                parent_account = account.id;
            });

            function clearForm() {
                // $('#account_code').val('');
                $('#name').val('');
                $('#alias').val('');
                $('#max_child_account').val('');
                let categorySelect = $('#category_id')[0].tomselect;
                let subCategorySelect = $('#sub_category_id')[0].tomselect;
                let parentAccountSelect = $('#parent_account_id')[0].tomselect;

                if (categorySelect) {
                    categorySelect.setValue('');
                }

                if (subCategorySelect) {
                    subCategorySelect.setValue('');
                }

                // if (parentAccountSelect) {
                //     parentAccountSelect.setValue('');
                // }

                let ref_id = parent_account;
                $('#hidden_parent_account_id').val(ref_id);
                console.log('ref_id', ref_id)
                if (ref_id) {
                    $.ajax({
                        url: '/api/generate-account-code?ref_id=' + ref_id,
                        type: 'GET',
                        success: function (response) {
                            $('#account_code').val(response.code);
                        },
                        error: function (xhr) {
                            console.error('Error generating code:', xhr.responseText);
                        }
                    });
                }
            }

            $('#btnAdd').click(function () {
                clearForm();
                working_type = 'add';
                url = "{{ url('accounts/chart_of_account/add') }}";
                $('#myForm').attr('action', url); // Update form action
                $('#btnSubmit').removeAttr('disabled');
            });

            $('#btnEdit').click(function () {
                working_type = 'edit';
                url = "{{ url('accounts/chart_of_account/edit') }}/" + account_id;
                $('#myForm').attr('action', url); // Update form action
                $('#btnSubmit').removeAttr('disabled');
            });

            $('#btnDelete').click(function () {
                if (!account_id) {
                    alert("Please select an account to delete.");
                    return;
                }

                if (!confirm("Are you sure you want to delete this account?")) {
                    return;
                }

                $.ajax({
                    url: "{{ url('accounts/chart_of_account/delete') }}/" + account_id,
                    type: "POST",
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function (response) {
                        alert(response.message);
                        $('#coaTree').jstree(true).refresh(); // Reload tree after deletion
                        $('#btnSubmit').attr('disabled', true);
                        $('#btnDelete').attr('disabled', true);
                        clearForm(); // Clear form after deletion
                    },
                    error: function (xhr) {
                        console.log('xhr', xhr)
                        alert("Error deleting account: " + xhr.responseJSON.message);
                    }
                });
            });
        });
    </script>
@endsection