@extends('layout.master')

@section('title')
    Add-Cheque Book-YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts/cheque_book/add') }}" class="breadcrumb-item">Cheque Book</a><i data-feather="chevron-right"
        class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('accounts/cheque_book/add') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Add Cheque Book
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Save</button>
                        <a href="javascript:history.back()"
                            class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-6">
                                    <label>Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Account" id="account_id" name="account_id"
                                            class="tom-select w-full">
                                            <option value="">Please Select Account</option>
                                            @foreach ($chart_of_accounts as $account)
                                                <option value="{{ $account->id }}">{{ $account->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label for="prefix" class="form-label">Prefix</label>
                                    <input id="prefix" type="text" class="form-control name-validate"
                                        placeholder="Enter Prefix" name="prefix">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="starting_no" class="form-label">Starting #</label>
                                    <input id="starting_no" type="text" class="form-control name-validate"
                                        placeholder="Enter Starting #" name="starting_no">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="number_of_leafs" class="form-label">Number of Leafs</label>
                                    <input id="number_of_leafs" type="text" class="form-control name-validate"
                                        placeholder="Enter Number of Leafs" name="number_of_leafs">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="date_of_request" class="form-label">Request Date</label>
                                    <input id="date_of_request" type="date" class="form-control name-validate"
                                        name="date_of_request">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="issue_date" class="form-label">Issue Date</label>
                                    <input id="issue_date" required type="date" class="form-control name-validate"
                                        name="issue_date">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="activation_date" class="form-label">Activation Date</label>
                                    <input id="activation_date" type="date" class="form-control name-validate"
                                        name="activation_date">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Status</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Status" id="status" name="status"
                                            class="tom-select w-full">
                                            <option value="1">Active</option>
                                            <option value="0">In Active</option>
                                        </select>
                                    </div>
                                </div>

                            </div>
            </form>
        </div>
    </div>
@endsection
