@extends('layout.master')

@section('title')
    Edit-Cheque Book-YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts/cheque_book/edit/', $cheque_book_master->id) }}" class="breadcrumb-item">Cheque Book</a><i
        data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('accounts/cheque_book/edit/', $cheque_book_master->id) }}"
                enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Edit Cheque Book
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Update</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-6">
                                    <label>Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Account" id="account_id" name="account_id"
                                            class="tom-select w-full">
                                            <option value="">Please Select Account</option>
                                            @foreach ($chart_of_accounts as $account)
                                                <option
                                                    {{ $cheque_book_master->account_id == $account->id ? 'selected' : '' }}
                                                    value="{{ $account->id }}">{{ $account->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label for="prefix" class="form-label">Prefix</label>
                                    <input id="prefix" type="text" value="{{ $cheque_book_master->prefix }}"
                                        class="form-control name-validate" placeholder="Enter Prefix" name="prefix">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="starting_no" class="form-label">Starting #</label>
                                    <input id="starting_no" type="text" value="{{ $cheque_book_master->starting_no }}"
                                        class="form-control name-validate" placeholder="Enter Starting #"
                                        name="starting_no">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="number_of_leafs" class="form-label">Number of Leafs</label>
                                    <input id="number_of_leafs" type="text"
                                        value="{{ $cheque_book_master->number_of_leafs }}"
                                        class="form-control name-validate" placeholder="Enter Number of Leafs"
                                        name="number_of_leafs">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="date_of_request" class="form-label">Request Date</label>
                                    <input id="date_of_request" type="date"
                                        value="{{ $cheque_book_master->date_of_request }}"
                                        class="form-control name-validate" name="date_of_request">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="issue_date" class="form-label">Issue Date</label>
                                    <input id="issue_date" required type="date"
                                        value="{{ $cheque_book_master->issue_date }}" class="form-control name-validate"
                                        name="issue_date">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="activation_date" class="form-label">Activation Date</label>
                                    <input id="activation_date" type="date"
                                        value="{{ $cheque_book_master->activation_date }}"
                                        class="form-control name-validate" name="activation_date">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Status</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Status" id="status" name="status"
                                            class="tom-select w-full">
                                            <option {{ $cheque_book_master->status == 1 ? 'selected' : '' }}
                                                value="1">Active</option>
                                            <option {{ $cheque_book_master->status == 0 ? 'selected' : '' }}
                                                value="0">In Active</option>
                                        </select>
                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                </div>

                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Cheques
                        </h2>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Cheque Number</th>
                                            <th>Utlizied</th>
                                            <th>Voucher No</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                            <th>Action</th> <!-- New column for the clone button -->
                                        </tr>
                                    </thead>

                                    <tbody>
                                        @foreach ($cheque_book_master->detail as $detail)
                                            <tr>
                                                <td>{{ $detail->cheque_number }}</td>
                                                <td>{{ $detail->utilised ? 'Yes' : 'No' }}</td>
                                                <td>{{ $detail->utilised ? $detail->utilised->voucher_no : '' }}</td>
                                                <td>{{ $detail->utilised ? $detail->utilised->total_debit : '' }}</td>
                                                <td>
                                                    @if ($detail->status == 0)
                                                        Cancelled
                                                    @elseif ($detail->status == 1)
                                                        Not Utilised
                                                    @elseif ($detail->status == 2)
                                                        Utilised
                                                    @else
                                                        Unknown
                                                    @endif
                                                </td>
                                                <td>
                                                    <!-- Clone button -->
                                                    <button type="button" class="btn btn-sm btn-primary clone-btn"
                                                        data-cheque-id="{{ $detail->id }}">
                                                        Clone
                                                    </button>

                                                    <!-- Cancel button -->
                                                    @if (!$detail->utilised)
                                                        <button type="button" class="btn btn-sm btn-warning cancel-btn"
                                                            data-cheque-id="{{ $detail->id }}">
                                                            Cancel
                                                        </button>
                                                    @endif

                                                    <!-- Delete button -->
                                                    <button type="button" class="btn btn-sm btn-danger delete-btn"
                                                        data-cheque-id="{{ $detail->id }}">
                                                        Delete
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>

                                </table>

                            </div>

                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal for Cloning Cheque -->
    <div class="modal fade" id="cloneChequeModal" tabindex="-1" aria-labelledby="cloneChequeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="cloneChequeModalLabel">Clone Cheque</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="cloneChequeForm">
                        <div class="mb-3">
                            <label for="cheque_number" class="form-label">Cheque Number</label>
                            <input type="text" class="form-control" id="cheque_number" name="cheque_number">
                        </div>
                        {{-- <div class="mb-3">
                            <label for="voucher_no" class="form-label">Voucher No</label>
                            <input type="text" class="form-control" id="voucher_no" name="voucher_no">
                        </div>
                        <div class="mb-3">
                            <label for="amount" class="form-label">Amount</label>
                            <input type="text" class="form-control" id="amount" name="amount">
                        </div> --}}
                        <input type="hidden" id="cheque_master_id" name="cheque_master_id"
                            value="{{ $detail->cheque_book_master_id }}">

                        <!-- Add more fields as needed -->
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="saveClonedCheque">Save changes</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.clone-btn').on('click', function() {
                // Get the cheque ID from the data attribute
                var chequeId = $(this).data('cheque-id');

                // Fetch the cheque details (you can use AJAX to fetch details from the server)
                // For now, let's assume you have the details in a JavaScript object
                var chequeDetails = {
                    id: chequeId,
                    cheque_number: $(this).closest('tr').find('td:eq(0)').text(),
                    utilised: $(this).closest('tr').find('td:eq(1)').text(),
                    voucher_no: $(this).closest('tr').find('td:eq(2)').text(),
                    amount: $(this).closest('tr').find('td:eq(3)').text()
                };

                // Populate a form or modal with the cheque details
                // Example: Open a modal and fill in the details
                $('#cloneChequeModal').modal('show');
                $('#cloneChequeModal #cheque_number').val(chequeDetails.cheque_number);
                $('#cloneChequeModal #voucher_no').val(chequeDetails.voucher_no);
                $('#cloneChequeModal #amount').val(chequeDetails.amount);
                // Add more fields as needed
            });

            $('#saveClonedCheque').on('click', function() {
                // Get the form data
                var formData = $('#cloneChequeForm').serialize();
                var cheque_master_id = $('#cheque_master_id').val();
                formData.cheque_master_id = cheque_master_id;

                // Send an AJAX request to save the cloned cheque
                $.ajax({
                    url: '{{ url('api/accounts/cheque_book/clone') }}',
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        // Handle the response (e.g., show a success message, reload the page, etc.)
                        alert('Cheque cloned successfully!');
                        $('#cloneChequeModal').modal('hide');
                        location.reload(); // Reload the page to see the changes
                    },
                    error: function(xhr, status, error) {
                        // Handle errors
                        alert('An error occurred while cloning the cheque.');
                    }
                });
            });

            $('.cancel-btn').on('click', function() {
                if (confirm('Are you sure you want to cancel this cheque?')) {
                    var chequeId = $(this).data('cheque-id');

                    $.ajax({
                        url: '{{ url('api/accounts/cheque_book/cancel') }}',
                        method: 'POST',
                        data: {
                            _token: '{{ csrf_token() }}',
                            cheque_id: chequeId
                        },
                        success: function(response) {
                            alert('Cheque cancelled successfully!');
                            location.reload();
                        },
                        error: function(xhr) {
                            alert('Failed to cancel cheque.');
                        }
                    });
                }
            });

            // Delete Cheque
            $('.delete-btn').on('click', function() {
                if (confirm('Are you sure you want to permanently delete this cheque?')) {
                    var chequeId = $(this).data('cheque-id');

                    $.ajax({
                        url: '{{ url('api/accounts/cheque_book/delete') }}',
                        method: 'DELETE',
                        data: {
                            _token: '{{ csrf_token() }}',
                            cheque_id: chequeId
                        },
                        success: function(response) {
                            alert('Cheque deleted successfully!');
                            location.reload();
                        },
                        error: function(xhr) {
                            alert('Failed to delete cheque.');
                        }
                    });
                }
            });
        });
    </script>
@endsection
