@extends('layout.master')

@section('title')
Cheque Book-YARAN
@endsection


@section('topbar')
    <a href="{{ url('accounts/cheque_book') }}" class="breadcrumb--active">Cheque Book</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Cheque Book
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ url('/accounts/cheque_book/add') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $cheque_books->firstItem() }} to
                {{ $cheque_books->lastItem() }} of {{ $cheque_books->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <form id="MyForm" method="post" action="{{ url('/role/index') }}">
                        @csrf
                        <tr>
                            <th>Id</th>
                            <th>Account</th>
                            <th>Issue Date</th>
                            <th>Starting #</th>
                            <th># of Leafs</th>
                            <th>Status</th>
                            <th>Actions</th>
                    </form>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($cheque_books as $cheque_book)
                        <tr>
                            <td>{{ $cheque_book->id }}</td>
                            <td>{{ @$cheque_book->account->name }}</td>
                            <td>{{ $cheque_book->issue_date }}</td>
                            <td>{{ $cheque_book->starting_no }}</td>
                            <td>{{ $cheque_book->number_of_leafs }}</td>
                            <td>{{ $cheque_book->status == 1 ? 'Active' : 'InActive' }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <a class="btn btn-primary me-2 p-2" href="{{ url('accounts/cheque_book/edit/' . $cheque_book->id) }}"><i
                                            data-feather="edit" class="w-4 h-4"></i> </a>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
