@extends('layout.master')

@section('title')
    Add-Commodity-YARAN
@endsection

@section('topbar')
    <a href="/commodities" class="breadcrumb-item">Commodity</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a
        href="" class="breadcrumb--active">Add</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ route('commodities.store') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Add Commodity
                        </h2>
                        
                        <button type="submit" class="btn btn-primary submitBtn"
                            id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class="col-md-12">
                            <div class="mb-5">
                                <ul class="nav nav-pills rounded-2" role="tablist">
                                    <li id="commodity_tab" class="nav-item flex-1" role="presentation">
                                        <button class="nav-link w-full pt-2 pb-2.5 active" data-bs-toggle="pill"
                                            data-bs-target="#commodity" type="button" role="tab"
                                            aria-controls="commodity_tab" aria-selected="true">Commodity</button>
                                    </li>
                                    <li id="hazmat_tab" class="nav-item flex-1" role="presentation">
                                        <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                            data-bs-target="#hazmat" type="button" role="tab"
                                            aria-controls="hazmat_tab" aria-selected="false">Hazmat Details</button>
                                    </li>
                                    <li id="duty_tab" class="nav-item flex-1" role="presentation">
                                        <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                            data-bs-target="#duty" type="button" role="tab" aria-controls="duty_tab"
                                            aria-selected="false">Duty Details</button>
                                    </li>
                                </ul>
                            </div>
                            <div class="tab-content mt-2">
                                <div class="tab-pane fade show active" id="commodity" role="tabpanel"
                                    aria-labelledby="commodity_tab">
                                    <div class="row mb-5">
                                        <div class="col-md-4 mt-2">
                                            <label for="regular-form-1" class="form-label">Code</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter Code" name="code">
                                        </div>
                                        <div class="col-md-4 mt-2">
                                            <label for="regular-form-1" class="form-label">Name</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter Name" name="name">
                                        </div>
                                        <div class="col-md-4 mt-2">
                                            <label for="regular-form-1" class="form-label">Short Code</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter Short Code" name="short_code">
                                        </div>
                                        <div class="col-md-4 mt-2">
                                            <label for="regular-form-1" class="form-label">Hs Code</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter Hs Code" name="hs_code_id" id="hs_code_id">
                                        </div>
                                        <div class="col-md-4 mt-2">
                                            <label for="regular-form-1" class="form-label">Cargo Type</label>
                                            <select class="tom-select" name="cargo_type" id="cargo_type">
                                                <option value="gi">GI</option>
                                                <option value="car">Car</option>
                                            </select>
                                        </div>
                                        <div class="col-md-4 mt-2">
                                            <label for="regular-form-1" class="form-label">Commodity Group</label>
                                            <select class="tom-select" name="commodity_group_id" id="commodity_group_id">
                                                <option value="">Please Select</option>
                                                @foreach ($commodity_groups as $item)
                                                    <option value="{{ $item->id }}">{{ $item->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-4 mt-2">
                                            <label>Status</label>
                                            <div class="mt-2">
                                                <select data-placeholder="Select Status" id="status" name="status"
                                                    class="tom-select w-full">
                                                    <option value="1">Active</option>
                                                    <option value="0">In Active</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="hazmat" role="tabpanel" aria-labelledby="hazmat_tab">
                                    <div class="row mb-5">
                                        <div class="col-md-2 mt-2">
                                            <label>Hazmat Product ?</label>
                                            <div class="d-flex align-items-center mt-2">
                                                <div class="form-check me-2"> <input id="radio-switch-5"
                                                        class="form-check-input" type="radio" name="hazmat_product"
                                                        value="yes"> <label class="form-check-label"
                                                        for="radio-switch-5">Yes</label>
                                                </div>
                                                <div class="form-check me-2"> <input id="radio-switch-4"
                                                        class="form-check-input" type="radio" name="hazmat_product"
                                                        value="no"> <label class="form-check-label"
                                                        for="radio-switch-4">No</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-5 mt-2">
                                            <label for="regular-form-1" class="form-label">Packaging Group</label>
                                            <select class="tom-select" name="packaging_group" id="packaging_group">
                                                <option value="none">None</option>
                                                <option value="I-high_danger">I (High Danger)</option>
                                                <option value="II-med_danger">II (Med. Danger)</option>
                                                <option value="III-low_danger">III (Low Danger)</option>
                                            </select>
                                        </div>
                                        <div class="col-md-5 mt-2">
                                            <label for="regular-form-1" class="form-label">Hazmat Class</label>
                                            <select class="tom-select" name="hazmat_class" id="hazmat_class">
                                                <option value="class_not_specified">Class Not Specified</option>
                                                <option value="class_1">Class 1 Explosive: division not specified</option>
                                                <option value="class_1.1">Class 1.1 Explosive: mass</option>
                                                <option value="class_1.2">Class 1.2 Explosive: projection</option>
                                                <option value="class_1.3">Class 1.3 Explosive: fire and minor
                                                    blast/projection</option>
                                                <option value="class_1.4">Class 1.4 Explosive: minor</option>
                                            </select>
                                        </div>
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">UNO Code</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter UNO Code" name="uno_code">
                                        </div>
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">Hazmat Code</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter Hazmat Code" name="hazmat_code">
                                        </div>
                                        <div class="col-md-6 mt-2">
                                            <label for="regular-form-1" class="form-label">Chemical Name</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter Chemical Name" name="chemical_name">
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="duty" role="tabpanel" aria-labelledby="duty_tab">
                                    <div class="row">
                                        <div class="col-md-6 mt-2">
                                            <label for="regular-form-1" class="form-label">SRO</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter SRO" name="sro">
                                        </div>
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">Insurance</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter Insurance" name="insurance">
                                        </div>
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">Landing / Ins. %</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter Landing/Ins." name="landing_ins">
                                        </div>
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">CD %</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter CD %" name="cd">
                                        </div>
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">Add STax %</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter Add STax" name="stax">
                                        </div>
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">Add Cd %</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter Add Cd" name="add_cd">
                                        </div>
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">I.Tax %</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter I.Tax" name="itax">
                                        </div>
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">S. ITax %</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter S.ITax" name="s_itax">
                                        </div>
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">FED %</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter FED" name="fed">
                                        </div>
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">Fine</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter Fine" name="fine">
                                        </div>
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">E.T.O</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter E.T.O" name="eto">
                                        </div>
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">RD %</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter RD %" name="rd">
                                        </div>
                                        <div class="col-md-4 d-flex align-items-end">
                                            <div class="form-group me-5">
                                                <input id="regular-form-1" type="checkbox" class="form-check-input"
                                                    name="shipping_item" value="1">
                                                <label class="form-label" for="shipping_item">
                                                    Shipping Item
                                                </label>
                                            </div>
                                            <div class="form-group">
                                                <input id="regular-form-1" type="checkbox" class="form-check-input"
                                                    name="warehouse_item" value="1">
                                                <label class="form-label" for="warehouse_item">
                                                    Warehouse Item
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
            </form>
        </div>
    </div>
    </div>
    </div>
    </div>
@endsection
