@extends('layout.master')

@section('title')
Commodity Group-YARAN
@endsection

@section('topbar')
<a href="/commodity_groups" class="breadcrumb--active">Commodity Group</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Commodity Groups
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('commodity_groups.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $commodity_groups->firstItem() }} to
                {{ $commodity_groups->lastItem() }} of {{ $commodity_groups->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Name</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($commodity_groups as $commodity_group)
                        <tr>
                            <td>{{ $commodity_group->id }}</td>
                            <td>{{ $commodity_group->name }}</td>
                            <td>{{ $commodity_group->status == 1 ? 'Active' : 'InActive' }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('commodity_groups.edit', [$commodity_group->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['commodity_groups.destroy', $commodity_group->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
