@extends('layout.master')

@section('title')
Commodity Mapping-YARAN
@endsection

@section('topbar')
<a href="/commoditymappings" class="breadcrumb--active">Commodity Mapping</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Commodity Mappings
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('commoditymappings.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $commoditymappings->firstItem() }} to
                {{ $commoditymappings->lastItem() }} of {{ $commoditymappings->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Integration Code</th>
                        <th>Integration Name</th>
                        <th>CSUL Code</th>
                        <th>CSUL Name</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($commoditymappings as $commoditymapping)
                        <tr>
                            <td>{{ $commoditymapping->id }}</td>
                            <td>{{ $commoditymapping->integration_code }}</td>
                            <td>{{ $commoditymapping->integration_name }}</td>
                            <td>{{ $commoditymapping->csul_code }}</td>
                            <td>{{ $commoditymapping->csul_name }}</td>
                            <td>{{ $commoditymapping->status == 1 ? 'Active' : 'InActive' }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('commoditymappings.edit', [$commoditymapping->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['commoditymappings.destroy', $commoditymapping->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
