@extends('layout.master')

@section('title')
Cost Center-YARAN
@endsection

@section('topbar')
<a href="{{ url('accounts/cost_center') }}" class="breadcrumb--active">Cost Center</a>
@endsection
@section('content')
<h2 class="intro-y fs-lg fw-medium mt-10">
    Cost Center
</h2>
<div class="grid columns-12 gap-6 mt-5">
    <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
        <a class="btn btn-primary shadow-md me-2" href="{{ url('accounts/cost_center/add') }}">Add New</a>
        <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $cost_center->firstItem() }} to
            {{ $cost_center->lastItem() }} of {{ $cost_center->total() }} entries</div>
    </div>
    <!-- BEGIN: Data List -->

    <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
        <table class="table table-bordered mt-n2">
            <thead>
                <tr>
                    <th>Id</th>
                    <th>Code</th>
                    <th>Name</th>
                    <th>Remarks</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($cost_center as $account)
                <tr>
                    <td>{{ $account->id }}</td>
                    <td>{{ $account->short_code }}</td>
                    <td>{{ $account->name }}</td>
                    <td>{{ @$account->remarks }}</td>
                    <td>{{ $account->status == 1 ? 'Active' : 'InActive' }}</td>

                    <td>
                        <div class="d-flex gap-2">
                            <a href="{{ url('accounts/cost_center/edit', $account->id) }}"
                                class="btn btn-primary">Edit</a>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        <div class="grid columns-12 gap-6 mt-4">
            <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center">
                <div class="d-flex d-md-block mx-auto text-gray-600">
                    <?php echo $cost_center->appends(request()->query())->links('pagination::bootstrap-4'); ?>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection