@extends('layout.master')

@section('title')
Customer Group-YARAN
@endsection

@section('topbar')
<a href="/customergroups" class="breadcrumb--active">Customer Group</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Customer Groups
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('customergroups.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $customergroups->firstItem() }} to
                {{ $customergroups->lastItem() }} of {{ $customergroups->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Name</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($customergroups as $customergroup)
                        <tr>
                            <td>{{ $customergroup->id }}</td>
                            <td>{{ $customergroup->name }}</td>
                            <td>{{ $customergroup->status == 1 ? 'Active' : 'InActive' }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('customergroups.edit', [$customergroup->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['customergroups.destroy', $customergroup->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
