@extends('layout.master')

@section('title')
Employee Mapping-YARAN
@endsection

@section('topbar')
<a href="/employeemappings" class="breadcrumb--active">Employee Mapping</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Employee Mappings
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('employeemappings.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $employeemappings->firstItem() }} to
                {{ $employeemappings->lastItem() }} of {{ $employeemappings->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Integration Code</th>
                        <th>Integration Name</th>
                        <th>CSUL Code</th>
                        <th>CSUL Name</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($employeemappings as $employeemapping)
                        <tr>
                            <td>{{ $employeemapping->id }}</td>
                            <td>{{ $employeemapping->integration_code }}</td>
                            <td>{{ $employeemapping->integration_name }}</td>
                            <td>{{ $employeemapping->csul_code }}</td>
                            <td>{{ $employeemapping->csul_name }}</td>
                            <td>{{ $employeemapping->status == 1 ? 'Active' : 'InActive' }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('employeemappings.edit', [$employeemapping->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['employeemappings.destroy', $employeemapping->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
