@extends('layout.master')

@section('title')
    EDIT-Equipment Size Type-YARAN
@endsection

@section('topbar')
    <a href="/equipmentsizetypes" class="breadcrumb-item">Equipment Size Type</a><i data-feather="chevron-right"
        class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            {{ Form::model($equipmentsizetype, ['route' => ['equipmentsizetypes.update', $equipmentsizetype->id], 'method' => 'PUT']) }}
            <div class="intro-y box">
                <div
                    class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                    <h2 class="fw-medium fs-base me-auto">
                        Edit Equipment Size Type
                    </h2>
                    
                    <button type="submit" class="btn btn-primary submitBtn"
                        id="submitBtn">Save</button>
                    <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                        Back
                    </a>
                </div>

                <div id="input" class="p-5">
                    <div class=" col-md-12">
                        <div class="row mb-5">
                            <div class="col-md-4">
                                <label for="regular-form-1" class="form-label">Code</label>
                                <input id="regular-form-1" type="text" class="form-control"
                                    value="{{ $equipmentsizetype->code }}" placeholder="Enter Code" name="code">
                            </div>
                            <div class="col-md-4">
                                <label>Size</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Size" id="size" name="size"
                                        class="tom-select w-full">
                                        <option {{ $equipmentsizetype->size == 10 ? 'selected' : '' }} value="10">10
                                        </option>
                                        <option {{ $equipmentsizetype->size == 20 ? 'selected' : '' }} value="20">20
                                        </option>
                                        <option {{ $equipmentsizetype->size == 40 ? 'selected' : '' }} value="40">40
                                        </option>
                                        <option {{ $equipmentsizetype->size == 43 ? 'selected' : '' }} value="43">43
                                        </option>
                                        <option {{ $equipmentsizetype->size == 45 ? 'selected' : '' }} value="45">45
                                        </option>
                                        <option {{ $equipmentsizetype->size == 60 ? 'selected' : '' }} value="60">60
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label>Type</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Type" id="type" name="type"
                                        class="tom-select w-full">
                                        <option {{ $equipmentsizetype->type == 'dry_container' ? 'selected' : '' }}
                                            value="dry_container">Dry Container</option>
                                        <option {{ $equipmentsizetype->type == 'flat_track' ? 'selected' : '' }}
                                            value="flat_track">Flat Track</option>
                                        <option {{ $equipmentsizetype->type == 'high_cube' ? 'selected' : '' }}
                                            value="high_cube">High Cube</option>
                                        <option {{ $equipmentsizetype->type == 'hdc' ? 'selected' : '' }} value="hdc">
                                            HDC</option>
                                        <option {{ $equipmentsizetype->type == 'open_top' ? 'selected' : '' }}
                                            value="open_top">Open Top</option>
                                        <option {{ $equipmentsizetype->type == 'tank' ? 'selected' : '' }} value="tank">
                                            Tank</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 mt-2">
                                <label for="regular-form-1" class="form-label">TEU</label>
                                <input id="regular-form-1" value="{{ $equipmentsizetype->teu }}" type="text"
                                    class="form-control" placeholder="Enter Teu" name="teu">
                            </div>
                            <div class="col-md-4 mt-2">
                                <label for="regular-form-1" class="form-label">Old ISO Code</label>
                                <input id="regular-form-1" value="{{ $equipmentsizetype->old_iso_code }}" type="text"
                                    class="form-control" placeholder="Enter Code" name="old_iso_code">
                            </div>
                            <div class="col-md-4 mt-2">
                                <label for="regular-form-1" class="form-label">ISO Code</label>
                                <input id="regular-form-1" value="{{ $equipmentsizetype->iso_code }}" type="text"
                                    class="form-control" placeholder="Enter Code" name="iso_code">
                            </div>
                            <div class="col-md-4 mt-2">
                                <label for="regular-form-1" class="form-label">Weight</label>
                                <input id="regular-form-1" value="{{ $equipmentsizetype->weight }}" type="text"
                                    class="form-control" placeholder="Enter Weight" name="weight">
                            </div>
                            <div class="col-md-4 mt-2">
                                <label>Status</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Status" id="status" name="status"
                                        class="tom-select w-full">
                                        <option {{ $equipmentsizetype->status == 1 ? 'selected' : '' }} value="1">
                                            Active</option>
                                        <option {{ $equipmentsizetype->status == 0 ? 'selected' : '' }} value="2">In
                                            Active</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
