@extends('layout.master')

@section('title')
Equipment Size Type-YARAN
@endsection

@section('topbar')
<a href="/equipmentsizetypes" class="breadcrumb--active">Equipment Size Type</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Equipment Size Types
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('equipmentsizetypes.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $equipmentsizetypes->firstItem() }} to
                {{ $equipmentsizetypes->lastItem() }} of {{ $equipmentsizetypes->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Code</th>
                        <th>Size</th>
                        <th>Type</th>
                        <th>TEU</th>
                        <th>Weight</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($equipmentsizetypes as $equipmentsizetype)
                        <tr>
                            <td>{{ $equipmentsizetype->id }}</td>
                            <td>{{ $equipmentsizetype->code }}</td>
                            <td>{{ $equipmentsizetype->size }}</td>
                            <td>{{ $equipmentsizetype->type }}</td>
                            <td>{{ $equipmentsizetype->teu }}</td>
                            <td>{{ $equipmentsizetype->weight }}</td>
                            <td>{{ $equipmentsizetype->status == 1 ? 'Active' : 'InActive' }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('equipmentsizetypes.edit', [$equipmentsizetype->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['equipmentsizetypes.destroy', $equipmentsizetype->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
