@extends('layout.master')

@section('title')
    Add-General Voucher-YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts/general-voucher') }}" class="breadcrumb-item">General Voucher</a><i data-feather="chevron-right"
        class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
@endsection
<style>
    /* Ensure table cells allow dropdowns to be visible */
    td {
        position: relative;
        overflow: visible !important;
    }

    /* Fix TomSelect dropdown positioning */
    .ts-wrapper {
        position: relative;
        z-index: 10000 !important;
    }

    .ts-dropdown {
        position: absolute !important;
        z-index: 10001 !important;
        background: #fff;
        border: 1px solid #ccc;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
    }
</style>
@section('content')
    <div class="row mt-5">
        <div class="col-md-12">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('accounts/general-voucher/add') }}"
                enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Add General Voucher
                        </h2>

                        <button type="button" class="btn btn-primary" id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Date</label>
                                    <input id="regular-form-1" required type="date" class="form-control name-validate"
                                        name="date">
                                </div>

                                <div class="col-md-3 mt-2">
                                    <label>Payment Type</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Type" id="transaction_type_master_id"
                                            name="transaction_type_master_id" class="form-control">
                                            <option value="">Please Select Transaction Type</option>
                                            @foreach ($payment_type_master as $type)
                                                <option value="{{ $type->id }}">{{ $type->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-3 mt-2">
                                    <label>Voucher Type</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Type" id="voucher_type_id" name="voucher_type_id"
                                            class="form-control">
                                            <option value="">Please Select Voucher Type</option>
                                            {{-- @foreach ($transaction_type_master as $type)
                                        <option value="{{ $type->id }}">{{ $type->name }}</option>
                                        @endforeach --}}
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-3 mt-2">
                                    <label>Cost Center</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Cost Center" id="cost_center_id"
                                            name="cost_center_id" class="tom-select w-full">
                                            <option value="">Please Select Cost Center</option>
                                            @foreach ($cost_centers as $cost_center)
                                                <option value="{{ $cost_center->id }}">{{ $cost_center->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                {{-- <span id="bank_fields"> --}}
                                <div class="col-md-3 mt-2">
                                    <label class="lbl_account_1">Account</label>
                                    <div class="mt-2">
                                        <select id="account_id" required name="master_account_id">
                                            <option value="">Please Select Account</option>
                                            {{-- @foreach ($bank_accounts as $account)
                                                    <option value="{{ $account->id }}">{{ $account->name }}</option>
                                                @endforeach --}}
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-3 mt-2">
                                    <label class="lbl_account_1">Party Account</label>
                                    <div class="mt-2">
                                        <select id="party_id" required title="Select Party Account" name="party_id"
                                            class="">
                                            <option value="">Please Select Party Account</option>
                                            {{-- @foreach ($bank_accounts as $account)
                                                    <option value="{{ $account->id }}">{{ $account->name }}</option>
                                                @endforeach --}}
                                        </select>
                                    </div>
                                </div>
                                {{-- </span> --}}

                                {{-- <div class="col-md-3 mt-2">
                                    <label>Settlement Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Settlement Account" id="settlement_account"
                                            name="settlement_account" class="tom-select w-full">
                                            <option value="">Please Select Settlement Account</option>
                                            @foreach ($chart_of_accounts as $account)
                                                <option value="{{ $account->id }}">
                                                    {{ $account->name . ' - ' . $account->account_code }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div> --}}

                                <div class="col-md-3 mt-2">
                                    <label>Currency</label>
                                    <div class="mt-2">
                                        <select id="currency_id" name="currency_id" class="form-control w-full">
                                            <option value="">Please Select Currency</option>
                                            @foreach ($currencies as $index => $currency)
                                                <option {{ $index == 0 ? 'selected' : '' }} value="{{ $currency->id }}">
                                                    {{ $currency->name }}</option>
                                            @endforeach
                                            {{-- <option selected value="1">PAK RUPEES</option>
                                            <option value="2">US DOLLAR</option>
                                            <option value="3">DIRHAM</option>
                                            <option value="4">POUND</option>
                                            <option value="5">EURO</option>
                                            <option value="6">BDT</option>
                                            <option value="7">OMANI RIYAL</option> --}}
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Exchange Rate</label>
                                    <input id="exchange_rate" required type="number" class="form-control name-validate"
                                        placeholder="Enter Exchange Rate" value="1.000000" name="exchange_rate">
                                </div>

                                <div class="col-md-3 mt-2">
                                    <label for="nature" class="form-label">Nature</label>
                                    <select name="nature" required id="nature" class="form-control">
                                        <option value="">Please select Nature</option>
                                        <option value="Online Transfer">Online Transfer</option>
                                        <option value="Credit Card">Credit Card</option>
                                        <option value="Cheque">Cheque</option>
                                        <option value="Pay Order">Pay Order</option>
                                        <option value="TT">TT</option>
                                        <option value="Cash">Cash</option>
                                    </select>
                                </div>

                                <div class="col-md-3 mt-2 cheque_fields" style="display: none;">
                                    <label for="cheque_number" class="form-label">Cheque Number</label>
                                    <input readonly id="cheque_number" type="text" class="form-control name-validate"
                                        placeholder="Enter Cheque Number" name="reference_number[]">
                                    <button type="button" id="btnPickCheque"
                                        class="btn btn-primary btn-xs">Pick</button>
                                </div>

                                <div class="col-md-3 mt-2 cheque_fields" style="display: none;">
                                    <label for="regular-form-1" class="form-label">Cheque Date</label>
                                    <input id="regular-form-1" type="date" class="form-control name-validate"
                                        placeholder="Enter Cheque Date" name="reference_date[]">
                                </div>

                                <div class="col-md-3 mt-2 online_transfer_fields" style="display: none;">
                                    <label for="online_transfer_or_cash_date" class="form-label">Date</label>
                                    <input id="online_transfer_or_cash_date" type="date"
                                        class="form-control name-validate" name="reference_date[]">
                                </div>

                                <div class="col-md-3 mt-2 online_transfer_fields" style="display: none;">
                                    <label for="online_transfer_reference_no" class="form-label">Reference Number</label>
                                    <input id="online_transfer_reference_no" type="text"
                                        class="form-control name-validate" placeholder="Enter Reference Number"
                                        name="reference_number[]">
                                </div>

                                <div class="col-md-3 mt-2 cash_fields" style="display: none;">
                                    <label for="online_transfer_date" class="form-label">Date</label>
                                    <input id="online_transfer_date" type="date" class="form-control name-validate"
                                        name="reference_date[]">
                                </div>

                                <div class="col-md-3 mt-2 cash_fields" style="display: none;">
                                    <label for="cash_reference_no" class="form-label">Reference Number</label>
                                    <input id="cash_reference_no" type="text" class="form-control name-validate"
                                        placeholder="Enter Reference Number" name="reference_number[]">
                                </div>

                                <div class="col-md-3 mt-2 pay_order_fields" style="display: none;">
                                    <label for="pay_order_date" class="form-label">Date</label>
                                    <input id="pay_order_date" type="date" class="form-control name-validate"
                                        name="reference_date[]">
                                </div>

                                <div class="col-md-3 mt-2 pay_order_fields" style="display: none;">
                                    <label for="pay_order_number" class="form-label">Cheque / Pay Order Number</label>
                                    <input id="pay_order_number" type="text" class="form-control name-validate"
                                        placeholder="Enter Reference Number" name="reference_number[]">
                                </div>

                                <div class="col-md-3 mt-2 credit_card_fields" style="display: none;">
                                    <label for="credit_card_date" class="form-label">Date</label>
                                    <input id="credit_card_date" type="date" class="form-control name-validate"
                                        name="reference_date[]">
                                </div>

                                <div class="col-md-3 mt-2 credit_card_fields" style="display: none;">
                                    <label for="credit_card_reference_no" class="form-label">Reference Number</label>
                                    <input id="credit_card_reference_no" type="text"
                                        class="form-control name-validate" placeholder="Enter Reference Number"
                                        name="reference_number[]">
                                </div>

                                <div class="col-md-3 mt-2 tt_fields" style="display: none;">
                                    <label for="tt_date" class="form-label">Date</label>
                                    <input id="tt_date" type="date" class="form-control name-validate"
                                        name="reference_date[]">
                                </div>

                                <div class="col-md-3 mt-2 tt_fields" style="display: none;">
                                    <label for="tt_reference_no" class="form-label">Reference Number</label>
                                    <input id="tt_reference_no" type="text" class="form-control name-validate"
                                        placeholder="Enter Reference Number" name="reference_number[]">
                                </div>

                            </div>

                            <div class="row mb-5">
                                <div class="mt-5">
                                    <div class="g-col-12 g-col-lg-4 g-col-xxl-3">
                                        <div class="intro-y pe-1">
                                            <div class="box p-2">
                                                <ul class="nav nav-pills rounded-2" role="tablist">
                                                    <li id="invoice_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5 active"
                                                            data-bs-toggle="pill" data-bs-target="#invoice"
                                                            type="button" role="tab" aria-controls="invoice_tab"
                                                            aria-selected="true">Detail</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="tab-content mt-2">
                                            <div class="tab-pane fade show active" id="charges" role="tabpanel"
                                                aria-labelledby="charges_tab">
                                                <div class="text-end mt-3 me-5">
                                                    <button id="addRowReceivableButton" disabled type="button"
                                                        class="btn btn-primary mb-2">Add Row</button>
                                                </div>
                                                <div class="row">
                                                    <div class="intro-y g-col-12 overflow-auto">
                                                        <table id="receiveableTable" class="table table-bordered mt-n2">
                                                            <thead>
                                                                <tr>
                                                                    <th class="text-nowrap">Actions</th>
                                                                    <th class="text-nowrap">S.No</th>
                                                                    <th class="text-nowrap">Account</th>
                                                                    {{-- <th class="text-nowrap">Cost Center</th> --}}
                                                                    {{-- <th class="text-nowrap">Debit (VC)</th>
                                                                <th class="text-nowrap">Credit (VC)</th> --}}
                                                                    <th class="text-nowrap">Debit</th>
                                                                    <th class="text-nowrap">Credit</th>
                                                                    <th class="text-nowrap">Narration</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                {{-- <tr>
                                                                    <td>1</td>
                                                                    <td>
                                                                        <select class="form-control" name="account_id[]"
                                                                            id="account_id">
                                                                            <option value="">Select Account</option>
                                                                            @foreach ($chart_of_accounts as $account)
                                                                                <option value="{{ $account->id }}">
                                                                                    {{ $account->name . ' - ' . $account->account_code }}
                                                                                </option>
                                                                            @endforeach
                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <input class="form-control w-24" type="text"
                                                                            name="debit[]">
                                                                    </td>
                                                                    <td>
                                                                        <input class="form-control w-24" type="text"
                                                                            name="credit[]">
                                                                    </td>
                                                                    <td>
                                                                        <input class="form-control w-24" type="text"
                                                                            name="narration[]">
                                                                    </td>
                                                                </tr> --}}
                                                            </tbody>
                                                        </table>
                                                    </div>

                                                </div>
                                            </div>

                                            <div class="row mb-5">

                                                <div class="col-md-3 mt-2">
                                                    <label for="regular-form-1" class="form-label">Debit</label>
                                                    <input readonly type="text" class="form-control name-validate"
                                                        placeholder="Total Debit" id="total_debit" name="total_debit">
                                                </div>

                                                <div class="col-md-3 mt-2">
                                                    <label for="regular-form-1" class="form-label">Credit</label>
                                                    <input readonly type="text" class="form-control name-validate"
                                                        placeholder="Total Credit" id="total_credit" name="total_credit">
                                                </div>

                                                <div class="col-md-3 mt-2">
                                                    <label for="regular-form-1" class="form-label">Debit
                                                        (Converted)</label>
                                                    <input readonly type="text" class="form-control name-validate"
                                                        placeholder="Total Debit" id="total_debit_converted"
                                                        name="total_debit_converted">
                                                </div>

                                                <div class="col-md-3 mt-2">
                                                    <label for="regular-form-1" class="form-label">Credit
                                                        (Converted)</label>
                                                    <input readonly type="text" class="form-control name-validate"
                                                        placeholder="Total Credit" id="total_credit_converted"
                                                        name="total_credit_converted">
                                                </div>

                                            </div>

                                            <div class="row">
                                                <div class="col-md-4 mt-2">
                                                    <label for="regular-form-1" class="form-label">Narration</label>
                                                    <textarea class="form-control" name="summary_narration" id="summary_narration"></textarea>
                                                </div>

                                                <div class="col-md-4 mt-5">
                                                    <input type="checkbox" name="checkbox" value="1"
                                                        id="manual_narration">
                                                    <label for="manual_narration" class="form-label">Manual
                                                        Narration</label>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
            </form>
        </div>
    </div>

    <!-- BEGIN: Modal Content -->
    <div id="pickChequeModal" class="modal fade" tabindex="-1" aria-hidden="true"
        data-api-url="{{ url('/api/se_job/add/commodity') }}">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Bank</th>
                                    <th>#</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody id="tbodyChequeDetails"></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div> <!-- END: Modal Content -->
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.27/dist/sweetalert2.all.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<link href="https://cdn.jsdelivr.net/npm/tom-select@1.7.4/dist/css/tom-select.default.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/tom-select@1.7.4/dist/js/tom-select.complete.min.js"></script>

<script>
    $(document).ready(function() {

        document.addEventListener("DOMContentLoaded", function() {
            new TomSelect(".select_account", {
                create: false, // Users cannot add new options
                sortField: {
                    field: "text",
                    direction: "asc"
                }
            });
        });

        // setInterval(() => {
        //     console.log('test');
        //     document.querySelectorAll(".select_account").forEach(select => {
        //         if (!select.tomselect) {
        //             new TomSelect(select);
        //         }
        //     });
        // }, 100);

        var tomSelectInstance = new TomSelect('#party_id', {
            create: false,
            sortField: {
                field: "text",
                direction: "asc"
            }
        });

        var tomSelectInstance2 = new TomSelect('#account_id', {
            create: false,
            sortField: {
                field: "text",
                direction: "asc"
            }
        });

        let rowReceivableCounter = 0;
        let debit = 0;
        let credit = 0;
        let auto_write = '';
        let total_debit = 0;
        let total_credit = 0;
        let converted_total_debit = 0;
        let converted_total_credit = 0;

        $('#transaction_type_master_id').change(function() {

            var nature_value = $('#nature').val();
            var type_select = $('#transaction_type_master_id option:selected').text();

            if (nature_value == 'Cheque' && (type_select == 'Payment' || type_select == 'Adjustment')) {
                $('#cheque_number').prop('readonly', true);
                $('#btnPickCheque').css('display', 'block');
            } else {
                $('#cheque_number').removeAttr('readonly');
                $('#btnPickCheque').css('display', 'none');
            }

            // console.log($(this).val());
            $('#receiveableTable tbody').html('');
            rowReceivableCounter = 0;
            $('#voucher_type_id').html('');
            $('#voucher_type_id').append('<option value="">Please Select</option>');
            $.ajax({
                url: "{{ url('api/get_voucher_types') }}" + '/' + $(this).val(),
                type: 'GET',
                success: function(response) {
                    // console.log('response', response)
                    Object.keys(response.data).forEach(function(key) {
                        $('#voucher_type_id').append('<option value="' + response
                            .data[key]
                            .id + '">' + response.data[key].name + '</option>');
                    });
                    // var optionHtml = '<option value="' + response.data.id + '">' + response
                    //     .data.name + '</option>';
                    // var selectElement = $('#' + clickedLabel);
                    // selectElement.append(optionHtml);
                },
                error: function(xhr, status, error) {
                    // Handle error response
                    console.error(xhr.responseText);
                    // Optionally, display an error message
                }
            });
        })

        $('#currency_id').change(function() {
            // Get the selected currency value
            var selectedCurrency = $(this).val();

            // Make an AJAX request to get the conversion rate
            $.ajax({
                url: "{{ url('api/get-conversion-rate') }}" + "/" + selectedCurrency,
                type: 'GET',
                success: function(data) {
                    // Update the conversion rate container with the fetched value
                    $('#exchange_rate').val(data.conversion_rate);
                },
                error: function() {
                    // console.log('Error fetching conversion rate.');
                }
            });
        });

        $('#voucher_type_id').change(function() {
            $('#account_id').html('');
            $('#account_id').append('<option value="">Please Select</option>');
            $('#party_id').html('');
            $('#party_id').append('<option value="">Please Select</option>');

            var voucher_type_id = $(this).val();

            console.log('voucher_type_id', voucher_type_id);

            if (voucher_type_id == 6 || voucher_type_id == 9) {
                $('#nature').removeAttr('required');
            } else {
                $('#nature').attr('required', true);
            }

            $.ajax({
                url: "{{ url('api/get_accounts') }}",
                type: 'POST',
                data: {
                    voucher_type_id: voucher_type_id,
                },
                success: function(response) {
                    // console.log('response', response)
                    // Object.keys(response.data.from_account).forEach(function(key) {
                    //     $('#account_id').append('<option value="' + response
                    //         .data.from_account[key]
                    //         .id + '">' + response.data.from_account[key].name +
                    //         '</option>');
                    // });

                    Object.keys(response.data.from_account).forEach(function(key) {
                        var account2 = response.data.from_account[key];
                        tomSelectInstance2.addOption({
                            value: account2.id,
                            text: account2.name
                        });
                    });

                    var party_id_dropdown = $('#party_id');

                    Object.keys(response.data.to_account).forEach(function(key) {
                        var account = response.data.to_account[key];
                        tomSelectInstance.addOption({
                            value: account.id,
                            text: account.name
                        });
                    });

                    // Object.keys(response.data.to_account).forEach(function(key) {
                    //     $('#party_id').append('<option value="' + response
                    //         .data.to_account[key]
                    //         .id + '">' + response.data.to_account[key].name +
                    //         '</option>');
                    // });
                },
                error: function(xhr, status, error) {
                    // Handle error response
                    console.error(xhr.responseText);
                    // Optionally, display an error message
                }
            });
        })

        function addRowWithValues(account_id, type) {
            console.log('account_id', account_id);
            console.log('type', type);
            let existingRow = $('#receiveableTable tbody tr.' + type);

            var row_length = $('#receiveableTable tbody tr').length;

            if (row_length == 1 || row_length > 1) {
                $('#addRowReceivableButton').removeAttr('disabled');
            } else {
                $('#addRowReceivableButton').attr('disabled', true);
            }

            if (existingRow.length == 1) {
                // Update the existing row's account_id
                existingRow.find('select[name="account_id[]"]').val(account_id).trigger('change');
                return; // Exit function after updating
            }

            let accountExists = false;
            $('#receiveableTable tbody tr').each(function() {
                let existingAccountId = $(this).find('select[name="account_id[]"]').val();
                if (existingAccountId == account_id) {
                    accountExists = true;
                    return false; // Break out of the loop
                }
            });

            if (accountExists) {
                // alert('This account already exists in the table.');
                return; // Exit the function if the account already exists
            }

            // console.log($('#receiveableTable tbody tr.' + type));

            let transaction_type_master_id = $('#transaction_type_master_id').val();
            if (rowReceivableCounter == 0 && (transaction_type_master_id == 1 || transaction_type_master_id ==
                    2 || transaction_type_master_id ==
                    3)) {
                let row = '<tr class="' + type + '">' +
                    '<td></td>' +
                    '<td class="text-nowrap w-12">' + (rowReceivableCounter + 1) +
                    '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' +
                    '</td>' +
                    '<td class="text-nowrap w-64">' + createDynamicDropdown('account_id[]', dropdownOptions
                        .chart_of_accounts, account_id, '') +
                    '</td>' +
                    // '<td class="text-nowrap">' + createDynamicDropdown('cost_center_id[]', dropdownOptions
                    //     .cost_centers) + '</td>' +
                    // '<td class="text-nowrap">' + createInput('text', 'debit_vc[]', '') + '</td>' +
                    // '<td class="text-nowrap">' + createInput('text', 'credit_vc[]', '') + '</td>' +
                    '<td style="width: 0;" class="text-nowrap td_debit w-40">' + createInput('text', 'debit[]',
                        '',
                        'input_debit', 'readonly') +
                    '</td>' +
                    '<td style="width: 0;" class="text-nowrap td_credit w-40">' + createInput('text',
                        'credit[]', '',
                        'input_credit', 'readonly') +
                    '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'narration[]', '', 'input_narration', 'required') +
                    '</td>' +
                    '</tr>';
                $('#receiveableTable tbody').append(row);

            } else {
                let row = '<tr class="' + type + '">' +
                    '<td></td>' +
                    '<td class="text-nowrap w-12">' + (rowReceivableCounter + 1) +
                    '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' +
                    '</td>' +
                    '<td class="text-nowrap w-64">' + createDynamicDropdown('account_id[]', dropdownOptions
                        .chart_of_accounts, account_id, '') +
                    '</td>' +
                    // '<td class="text-nowrap">' + createDynamicDropdown('cost_center_id[]', dropdownOptions
                    //     .cost_centers) + '</td>' +
                    // '<td class="text-nowrap">' + createInput('text', 'debit_vc[]', '') + '</td>' +
                    // '<td class="text-nowrap">' + createInput('text', 'credit_vc[]', '') + '</td>' +
                    '<td class="text-nowrap td_debit w-40">' + createInput('text', 'debit[]', '',
                        'input_debit') +
                    '</td>' +
                    '<td class="text-nowrap td_credit w-40">' + createInput('text', 'credit[]', '',
                        'input_credit') +
                    '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'narration[]', '', 'input_narration', 'required') +
                    '</td>' +
                    '</tr>';
                $('#receiveableTable tbody').append(row);

            }
            rowReceivableCounter++;
        }

        tomSelectInstance2.on('blur', function() {
            var voucher_type_id = document.getElementById('voucher_type_id').value;
            var account_id = tomSelectInstance2.getValue();

            // console.log('account_id', account_id);
            if (account_id) {
                addRowWithValues(account_id, 'account')
            }

        })

        tomSelectInstance.on('blur', function() {
            var voucher_type_id = document.getElementById('voucher_type_id').value;
            var party_id = tomSelectInstance.getValue();

            if (party_id) {
                addRowWithValues(party_id, 'party');
            }

        });

        // $('#party_id').focusout(function() {
        //     var voucher_type_id = $('#voucher_type_id').val();
        //     var party_id = $('#party_id').val();

        //     addRowWithValues(party_id)
        // })

        // function calculateDebit() {
        //     debit = 0;
        //     $('#receiveableTable > tbody  > tr').each(function(index, value) {
        //         if ($(this).find('.input_debit').val()) {
        //             debit += parseFloat($(this).find('.input_debit').val());
        //         }
        //     });
        //     $('.input_debit').first().val(credit);
        // }

        // function calculateCredit() {
        //     credit = 0;
        //     $('#receiveableTable > tbody  > tr').each(function(index, value) {
        //         if ($(this).find('.input_credit').val()) {
        //             credit += parseFloat($(this).find('.input_credit').val());
        //         }
        //         // $('#BillGrossAmt').val(BillGrossAmount);
        //     });
        //     $('#total_credit').val(credit);
        // }

        // function calculateTotalDebit() {
        //     debit = 0;
        //     $('#receiveableTable > tbody  > tr').each(function(index, value) {
        //         // console.log("input_debit", $(this).find('.input_debit').val());
        //         if ($(this).find('.input_debit').val()) {
        //             debit += parseFloat($(this).find('.input_debit').val());
        //         }
        //         // $('#BillGrossAmt').val(BillGrossAmount);
        //     });
        //     $('#total_debit').val(debit);
        // }

        var sum_debit = 0;
        var sum_credit = 0;

        function calculateDebit(e) {
            var transaction_type_master_id = $('#transaction_type_master_id').val();
            var transaction_type_name = $('#transaction_type_master_id option:selected').text();
            let totalCredit = 0;
            let totalDebit = 0;
            // console.log('transaction_type_master_id', transaction_type_master_id);
            // console.log('transaction_type_name', transaction_type_name);

            if (transaction_type_name == 'Payment') {
                var editedField = $(e?.target).hasClass('input_debit') ? 'debit' : 'credit';
                var editedRow = $(e?.target).closest('tr');
                var editedRowIndex = editedRow.index();

                $('#receiveableTable > tbody > tr').each(function(index, value) {
                    if (index == 0) {
                        return;
                    } else {
                        // Find debit and credit input fields inside the row
                        let debit = parseFloat($(this).find('.input_debit').val()) || 0;
                        let credit = parseFloat($(this).find('.input_credit').val()) || 0;
                        // Sum up the values
                        totalDebit += debit;
                        totalCredit += credit;
                        let balance = totalDebit - totalCredit;
                        $('#receiveableTable > tbody > tr').eq(0).find('.input_credit').val(balance);
                    }
                });

                if (editedField == 'debit') {
                    editedRow.find('.input_credit').val('');
                } else {
                    editedRow.find('.input_debit').val('');
                }
            } else if (transaction_type_name == 'Received' || transaction_type_name == 'Adjustment' ||
                transaction_type_name == 'Invoices') {
                // Handle Received logic here (if needed)
                editedField = $(e?.target).hasClass('input_credit') ? 'credit' : 'debit';
                editedRow = $(e?.target).closest('tr');
                editedRowIndex = editedRow.index();

                totalDebit = 0;
                totalCredit = 0;

                $('#receiveableTable > tbody > tr').each(function(index, value) {
                    if (index == 0) {
                        return;
                    } else {
                        debit = parseFloat($(this).find('.input_debit').val()) || 0;
                        credit = parseFloat($(this).find('.input_credit').val()) || 0;
                        totalDebit += debit;
                        totalCredit += credit;
                        balance = totalCredit - totalDebit;
                        $('#receiveableTable > tbody > tr').eq(0).find('.input_debit').val(balance);
                    }
                });

                if (editedField == 'credit') {
                    editedRow.find('.input_debit').val('');
                } else {
                    editedRow.find('.input_credit').val('');
                }
            } else {
                // Handle other transaction types here (if needed)
            }

            // Recalculate totals after auto-calculation
            // $('#receiveableTable > tbody > tr').each(function(index, value) {
            //     totalDebit += parseFloat($(this).find('.input_debit').val()) || 0;
            //     totalCredit += parseFloat($(this).find('.input_credit').val()) || 0;
            // });
            TotalCalculate();
            // Update total fields
            // $('#total_debit').val(totalDebit.toFixed(2));
            // $('#total_credit').val(totalCredit.toFixed(2));

            // Update converted totals (if you still need these)
            // var exchange_rate = parseFloat($('#exchange_rate').val()) || 1;
            // $('#total_debit_converted').val((totalDebit / exchange_rate).toFixed(2));
            // $('#total_credit_converted').val((totalCredit / exchange_rate).toFixed(2));
        }

        function TotalCalculate() {
            let totalD = 0;
            let totalC = 0;
            let exchangeRate = $('#exchange_rate').val();

            if (!exchangeRate) {
                exchangeRate = 1;
            }

            $('#receiveableTable > tbody > tr').each(function() {
                let $debitInput = $(this).find('.input_debit');
                let $creditInput = $(this).find('.input_credit');

                let debit = parseFloat($debitInput.val()) || 0;
                let credit = parseFloat($creditInput.val()) || 0;

                // Ensure inputs are not empty (helps when typing and removing values)
                // if ($debitInput.val() === '') $debitInput.val(0);
                // if ($creditInput.val() === '') $creditInput.val(0);


                totalD += isNaN(debit) ? 0 : debit;
                totalC += isNaN(credit) ? 0 : credit;
            });

            $('#total_debit').val(totalD.toFixed(2));

            $('#total_debit_converted').val((totalD * exchangeRate).toFixed(2));

            $('#total_credit').val(totalC.toFixed(2));
            $('#total_credit_converted').val((totalC * exchangeRate).toFixed(2));
        }

        // Attach the calculateDebit function to both debit and credit input fields
        $(document).on('input', '.input_debit, .input_credit', calculateDebit);

        $('#btnPickCheque').click(function() {
            $('#tbodyChequeDetails').html('');
            var account_id = $('#account_id').val();
            $.ajax({
                url: "{{ url('api/get_cheques') }}",
                type: 'GET',
                data: {
                    account_id: account_id
                },
                success: function(response) {
                    Object.keys(response.data).forEach(function(key) {
                        $('#tbodyChequeDetails').append(
                            '<tr><td class="tdChequeId">' + response.data[key]
                            .id + '</td><td>' + response.data[key].id +
                            '</td><td class="tdChequeNumber">' + response.data[
                                key].cheque_number +
                            '</td><td><button class="btn btn-primary btn-sm chequeId" type="button">Pick</button></td></tr>'
                        )
                    })
                },
                error: function(xhr, status, error) {
                    // Handle error response
                    console.error(xhr.responseText);
                    // Optionally, display an error message
                }
            });

            $('#pickChequeModal').modal('show');
        })

        $(document).on('click', '.chequeId', function(e) {
            // console.log($(this).closest('tr'))
            var row = $(this).closest('tr');
            var cheque_id = row.find('.tdChequeId')[0].innerHTML;
            var cheque_number = row.find('.tdChequeNumber')[0].innerHTML;

            $('#cheque_number').val(cheque_number);

            $('#pickChequeModal').modal('hide');
        })



        // function calculateCredit() {
        //     var transaction_type_master_id = $('#transaction_type_master_id').val();

        //     // Payment
        //     if (transaction_type_master_id == 1) {
        //         // User will write in Credit so we will calculate Debit
        //         auto_write = 'Debit';
        //     } else if (transaction_type_master_id == 2) {
        //         // User will write in Debit so we will calculate Credit
        //         auto_write == 'Credit';
        //     }

        //     credit = 0;
        //     $('#receiveableTable > tbody  > tr').each(function(index, value) {
        //         if ($(this).find('.input_credit').val()) {
        //             credit += parseFloat($(this).find('.input_credit').val());
        //         }
        //     });
        //     total_credit = credit;
        //     $('#total_credit').val(total_credit);

        //     if (auto_write == 'Debit') {
        //         $('#total_debit').val(total_credit);
        //         $('.input_debit').first().val(total_credit);
        //     }
        // }

        $(document).on('change', '.input_debit', function(e) {
            calculateDebit(e);
        })

        $(document).on('change', '.input_credit', function(e) {
            calculateDebit(e);
        })

        $('#summary_narration').keyup(function(e) {
            if ($('#manual_narration').is(':checked')) {
                // console.log('true');
            } else {
                $('.input_narration').val($(this).val());
            }
        })

        $('#submitBtn').click(function(e) {
            $('.select_account').removeAttr('disabled');
            e.preventDefault(); // Prevent default form submission

            // Check if all required fields are filled
            var isValid = true;
            $('input[required], select[required], textarea[required]').each(function() {
                if ($(this).val() === '') {
                    isValid = false;
                    $(this).addClass('is-invalid');
                } else {
                    $(this).removeClass('is-invalid');
                }
            });

            if (!isValid) {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: 'Please fill all required fields!',
                    showConfirmButton: false,
                    timer: 2500
                });
                return;
            }

            let hasNegative = false;

            // Check for negative values in debit and credit inputs
            $('.input_debit, .input_credit').each(function() {
                const val = parseFloat($(this).val());
                if (!isNaN(val) && val < 0) {
                    hasNegative = true;
                    return false; // Break out of loop early
                }
            });

            if (hasNegative) {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: 'Negative values are not allowed!',
                    showConfirmButton: false,
                    timer: 2500
                });
            } else if ($('#total_debit').val() == $('#total_credit').val() && $('#total_debit').val() >
                0 && $(
                    '#total_credit').val() > 0) {
                $('#myForm').submit();
            } else if ($('#total_debit').val() == 0 && $('#total_credit').val() == 0) {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: 'The amounts cannot be negative!',
                    showConfirmButton: false,
                    timer: 2500
                });
            } else {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: 'Debit and Credit should be equal!',
                    showConfirmButton: false,
                    timer: 2500
                });
            }
        });

        $('#nature').change(function() {
            var nature_value = $('#nature').val();
            // console.log('nature_value', nature_value)
            if (nature_value == 'Cheque') {
                $('.cheque_fields').css('display', 'block');
            } else {
                $('.cheque_fields').css('display', 'none');
            }

            var type_select = $('#transaction_type_master_id option:selected').text();

            if (nature_value == 'Cheque' && (type_select == 'Payment' || type_select == 'Adjustment')) {
                $('#cheque_number').prop('readonly', true);
                $('#btnPickCheque').css('display', 'block');
            } else {
                $('#cheque_number').removeAttr('readonly');
                $('#btnPickCheque').css('display', 'none');
            }

            if (nature_value == 'Online Transfer') {
                $('.online_transfer_fields').css('display', 'block');
            } else {
                $('.online_transfer_fields').css('display', 'none');
            }

            if (nature_value == 'Cash') {
                $('.cash_fields').css('display', 'block');
            } else {
                $('.cash_fields').css('display', 'none');
            }

            if (nature_value == 'Pay Order') {
                $('.pay_order_fields').css('display', 'block');
            } else {
                $('.pay_order_fields').css('display', 'none');
            }

            if (nature_value == 'Credit Card') {
                $('.credit_card_fields').css('display', 'block');
            } else {
                $('.credit_card_fields').css('display', 'none');
            }

            if (nature_value == 'TT') {
                $('.tt_fields').css('display', 'block');
            } else {
                $('.tt_fields').css('display', 'none');
            }

        })

        const dropdownOptions = {
            chart_of_accounts: {!! json_encode($chart_of_accounts) !!},
            cost_centers: {!! json_encode($cost_centers) !!}
        };

        function createDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control">';
            options.forEach(option => {
                dropdown += '<option value="' + option + '">' + option + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createDynamicDropdown(name, options, selected_id = null, attribute = null) {
            // console.log('selected_id', selected_id)
            // console.log('createDynamicDropdown');
            let dropdown = '<select disabled name="' + name + '" class="select_account w-56">';

            let counter = $('#receiveableTable tbody tr').length;

            if (counter > 1) {
                dropdown = '<select name="' + name + '" class="select_account w-56">';
            }

            dropdown += '<option value="">Select Account</option>';
            if (selected_id) {
                options.forEach(option => {
                    if (option.id == selected_id) {
                        dropdown += '<option ' + attribute + ' selected value="' + option.id + '">' +
                            option.name +
                            ' - ' + option.account_code + '</option>';
                    } else {
                        dropdown += '<option ' + attribute + ' value="' + option.id + '">' + option
                            .name + ' - ' + option
                            .account_code + '</option>';
                    }
                });
            } else {
                options.forEach(option => {
                    dropdown += '<option ' + attribute + ' value="' + option.id + '">' + option.name +
                        ' - ' + option
                        .account_code + '</option>';
                });
            }
            dropdown += '</select>';

            return dropdown;
        }


        function createInput(type, name, placeholder, class_name = null, attribute = null) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '"value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                if (class_name) {
                    return '<input ' + attribute + ' type="' + type + '" name="' + name +
                        '" class="form-control ' + class_name + '" placeholder="' +
                        placeholder + '">';
                } else {
                    return '<input type="' + type + '" name="' + name +
                        '" class="form-control" placeholder="' +
                        placeholder + '">';
                }
            }
        }

        function addRowReceivable() {
            let row = '<tr>' +
                '<td><button type="button" class="btn btn-danger btn-sm delete-row">Delete</button></td>' +
                '<td style="width: 0;" class="text-nowrap">' + (rowReceivableCounter + 1) +
                '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' + '</td>' +
                '<td style="width: 0;" class="text-nowrap">' + createDynamicDropdown('account_id[]',
                    dropdownOptions
                    .chart_of_accounts) +
                '</td>' +
                // '<td class="text-nowrap">' + createDynamicDropdown('cost_center_id[]', dropdownOptions
                //     .cost_centers) + '</td>' +
                // '<td class="text-nowrap">' + createInput('text', 'debit_vc[]', '') + '</td>' +
                // '<td class="text-nowrap">' + createInput('text', 'credit_vc[]', '') + '</td>' +
                '<td style="width: 0;" class="text-nowrap">' + createInput('text', 'debit[]', '',
                    'input_debit w-40') + '</td>' +
                '<td style="width: 0;" class="text-nowrap">' + createInput('text', 'credit[]', '',
                    'input_credit w-40') +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'narration[]', '', 'input_narration', 'required') +
                '</td>' +
                '</tr>';
            $('#receiveableTable tbody').append(row);

            setTimeout(() => {
                $('#receiveableTable tbody tr:last .select_account').each(function() {
                    if (!this.tomselect) {
                        new TomSelect(this, {
                            dropdownParent: 'body' // Ensures dropdown appears outside the table
                        });
                    }
                });
            }, 10);

            rowReceivableCounter++;
        }

        $('#addRowReceivableButton').click(addRowReceivable);

        $(document).on("click", ".delete-row", function() {
            $(this).closest("tr").remove();
            calculateDebit();
            TotalCalculate();
        });

        $('#exchange_rate').keyup(function() {
            TotalCalculate();
        })

        $('#currency_id').change(function() {
            setTimeout(() => {
                TotalCalculate();
            }, 100);
        })
    });
</script>
