@extends('layout.master')

@section('title')
    EDIT-General Voucher-YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts/general-voucher/edit/' . $transaction_master->id) }}" class="breadcrumb-item">General
        Voucher</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href=""
        class="breadcrumb--active">Edit</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('accounts/general-voucher/edit/' . $transaction_master->id) }}"
                enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Edit General Voucher
                        </h2>
                        
                        <button type="button" class="btn btn-primary" id="submitBtn">Save</button>
                        <a href="javascript:history.back()"
                            class="btn btn-secondary waves-effect">
                            Back
                        </a>
                        <div class="d-flex align-items-center">
                            @can('voucher_approver')
                                @if ($transaction_master->status == 1)
                                    <a title="Approve" class="tooltip btn btn-success me-2 p-2"
                                        href="{{ url('/accounts/general-voucher/status/' . $transaction_master->id . '/' . 2) }}"><i
                                            data-feather="check" class="w-4 h-4 me-1"></i>
                                        Approve </a>
                                @endcan
                            @endif
                            @can('voucher_director_approver')
                                @if ($transaction_master->status == 2)
                                    <a title="Approve" class="tooltip btn btn-success me-2 p-2"
                                        href="{{ url('/accounts/general-voucher/status/' . $transaction_master->id . '/' . 3) }}"><i
                                            data-feather="check" class="w-4 h-4 me-1"></i>
                                        Director Approve </a>
                                @endcan
                            @endif
                            @can('voucher_post')
                                @if ($transaction_master->status == 3)
                                    <a title="Approve" class="tooltip btn btn-success me-2 p-2"
                                        href="{{ url('/accounts/general-voucher/status/' . $transaction_master->id . '/' . 4) }}"><i
                                            data-feather="check" class="w-4 h-4 me-1"></i>
                                        Post </a>
                                @endcan
                            @endif
                            {{-- <a title="CRO" class="tooltip btn btn-warning me-2 p-2"
                            href="{{ url('/cro/add/' . $job_master->id) }}"><i data-feather="file-text" class="w-4 h-4 me-1"></i>
                            CRO </a> --}}
                        </div>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Date</label>
                                    <input id="regular-form-1" value="{{ $transaction_master->date }}" required
                                        type="date" class="form-control name-validate" name="date">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Payment Type</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Type" id="transaction_type_master_id"
                                            name="transaction_type_master_id" class="form-control">
                                            <option value="">Please Select Transaction Type</option>
                                            @foreach ($payment_type_master as $type)
                                                <option
                                                    {{ $transaction_master->transaction_type_master_id == $type->id ? 'selected' : '' }}
                                                    value="{{ $type->id }}">{{ $type->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Voucher Type</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Type" id="voucher_type_id" name="voucher_type_id"
                                            class="form-control">
                                            <option value="">Please Select Voucher Type</option>
                                            @foreach ($transaction_type_master as $type)
                                                <option
                                                    {{ $type->id == $transaction_master->voucher_type_id ? 'selected' : '' }}
                                                    value="{{ $type->id }}">{{ $type->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                {{-- <span id="bank_fields"> --}}
                                <div class="col-md-6 mt-2">
                                    <label class="lbl_account_1">Account</label>
                                    <div class="mt-2">
                                        <select id="account_id" name="master_account_id" class="form-control">
                                            <option value="">Please Select Account</option>
                                            @foreach ($chart_of_accounts as $account)
                                                <option
                                                    {{ $transaction_master->account_id == $account->id ? 'selected' : '' }}
                                                    value="{{ $account->id }}">{{ $account->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label class="lbl_account_1">Party Account</label>
                                    <div class="mt-2">
                                        <select id="party_id" name="party_id" class="form-control">
                                            <option value="">Please Select Party Account</option>
                                            @foreach ($chart_of_accounts as $account)
                                                <option
                                                    {{ $transaction_master->party_id == $account->id ? 'selected' : '' }}
                                                    value="{{ $account->id }}">{{ $account->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                {{-- </span> --}}

                                {{-- <div class="col-md-6 mt-2">
                                    <label>Settlement Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Settlement Account" id="settlement_account"
                                            name="settlement_account" class="tom-select w-full">
                                            <option value="">Please Select Settlement Account</option>
                                            @foreach ($chart_of_accounts as $account)
                                                <option value="{{ $account->id }}">
                                                    {{ $account->name . ' - ' . $account->account_code }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div> --}}

                                <div class="col-md-6 mt-2">
                                    <label>Cost Center</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Cost Center" id="cost_center_id"
                                            name="cost_center_id" class="tom-select w-full">
                                            <option value="">Please Select Cost Center</option>
                                            @foreach ($cost_centers as $cost_center)
                                                <option
                                                    {{ $transaction_master->cost_center_id == $cost_center->id ? 'selected' : '' }}
                                                    value="{{ $cost_center->id }}">{{ $cost_center->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Currency</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Currency" id="currency_id" name="currency_id"
                                            class="tom-select w-full">
                                            <option value="">Please Select Currency</option>
                                            <option {{ $transaction_master->currency_id == 1 ? 'selected' : '' }}
                                                value="1">PAK RUPEES</option>
                                            <option {{ $transaction_master->currency_id == 2 ? 'selected' : '' }}
                                                value="2">US DOLLAR</option>
                                            <option {{ $transaction_master->currency_id == 3 ? 'selected' : '' }}
                                                value="3">DIRHAM</option>
                                            <option {{ $transaction_master->currency_id == 4 ? 'selected' : '' }}
                                                value="4">POUND</option>
                                            <option {{ $transaction_master->currency_id == 5 ? 'selected' : '' }}
                                                value="5">EURO</option>
                                            <option {{ $transaction_master->currency_id == 6 ? 'selected' : '' }}
                                                value="6">BDT</option>
                                            <option {{ $transaction_master->currency_id == 7 ? 'selected' : '' }}
                                                value="7">OMANI RIYAL</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Exchange Rate</label>
                                    <input value="{{ @$transaction_master->exchange_rate }}" id="regular-form-1" required
                                        type="number" class="form-control name-validate"
                                        placeholder="Enter Exchange Rate" value="1.000000" name="exchange_rate">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Cheque Number</label>
                                    <input value="{{ @$transaction_master->cheque_number }}" id="regular-form-1"
                                        type="text" class="form-control name-validate"
                                        placeholder="Enter Cheque Number" name="cheque_number">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Cheque Date</label>
                                    <input value="{{ @$transaction_master->cheque_date }}" id="regular-form-1"
                                        type="date" class="form-control name-validate" placeholder="Enter Cheque Date"
                                        name="cheque_date">
                                </div>

                            </div>

                            <div class="row mb-5">
                                <div class="mt-5">
                                    <div class="g-col-12 g-col-lg-4 g-col-xxl-3">
                                        <div class="intro-y pe-1">
                                            <div class="box p-2">
                                                <ul class="nav nav-pills rounded-2" role="tablist">
                                                    <li id="invoice_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5 active"
                                                            data-bs-toggle="pill" data-bs-target="#invoice"
                                                            type="button" role="tab" aria-controls="invoice_tab"
                                                            aria-selected="true">Detail</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="tab-content mt-2">
                                            <div class="tab-pane fade show active" id="charges" role="tabpanel"
                                                aria-labelledby="charges_tab">
                                                <div class="text-end mt-3 me-5">
                                                    <button id="addRowReceivableButton" type="button"
                                                        class="btn btn-primary">Add
                                                        Row</button>
                                                </div>
                                                <div class="row">
                                                    <div class="intro-y g-col-12 overflow-auto">
                                                        <table id="receiveableTable" class="table table-bordered mt-n2">
                                                            <thead>
                                                                <tr>
                                                                    <th class="text-nowrap">S.No</th>
                                                                    <th class="text-nowrap">Account</th>
                                                                    {{-- <th class="text-nowrap">Cost Center</th> --}}
                                                                    {{-- <th class="text-nowrap">Debit (VC)</th>
                                                                <th class="text-nowrap">Credit (VC)</th> --}}
                                                                    <th class="text-nowrap">Debit</th>
                                                                    <th class="text-nowrap">Credit</th>
                                                                    <th class="text-nowrap">Narration</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach ($transaction_master->detail as $index => $detail)
                                                                    <tr>
                                                                        <td>1</td>
                                                                        <td>
                                                                            <select class="form-control"
                                                                                name="account_id[]" id="account_id">
                                                                                <option value="">Select Account
                                                                                </option>
                                                                                @foreach ($chart_of_accounts as $account)
                                                                                    <option
                                                                                        {{ $detail->account_id == $account->id ? 'selected' : '' }}
                                                                                        value="{{ $account->id }}">
                                                                                        {{ $account->name . ' - ' . $account->account_code }}
                                                                                    </option>
                                                                                @endforeach
                                                                            </select>
                                                                        </td>
                                                                        <td>
                                                                            <input value="{{ $detail->debit_lc }}"
                                                                                class="form-control w-24" type="text"
                                                                                name="debit[]">
                                                                        </td>
                                                                        <td>
                                                                            <input value="{{ $detail->credit_lc }}"
                                                                                class="form-control w-24" type="text"
                                                                                name="credit[]">
                                                                        </td>
                                                                        <td>
                                                                            <input value="{{ $detail->narration }}"
                                                                                class="form-control w-24" type="text"
                                                                                name="narration[]">
                                                                        </td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>

                                                </div>
                                            </div>

                                            <div class="row mb-5">
                                                <div class="col-md-4 mt-2">
                                                    <label for="regular-form-1" class="form-label">Debit</label>
                                                    <input value="{{ $transaction_master->total_debit }}" readonly
                                                        type="text" class="form-control name-validate"
                                                        placeholder="Total Debit" id="total_debit" name="total_debit">
                                                </div>

                                                <div class="col-md-4 mt-2">
                                                    <label for="regular-form-1" class="form-label">Credit</label>
                                                    <input value="{{ $transaction_master->total_credit }}" readonly
                                                        type="text" class="form-control name-validate"
                                                        placeholder="Total Credit" id="total_credit" name="total_credit">
                                                </div>

                                            </div>

                                            <div class="row">
                                                <div class="col-md-6 mt-2">
                                                    <label for="regular-form-1" class="form-label">Narration</label>
                                                    <textarea class="form-control" name="summary_narration" id="summary_narration">{{ $transaction_master->narration }}</textarea>
                                                </div>

                                                <div class="col-md-4 mt-5">
                                                    <input type="checkbox" name="checkbox" value="1"
                                                        id="manual_narration">
                                                    <label for="manual_narration" class="form-label">Manual
                                                        Narration</label>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
            </form>
        </div>
    </div>
    </div>
    </div>
    </div>
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.27/dist/sweetalert2.all.min.js"></script>

<script>
    $(document).ready(function() {

        let rowReceivableCounter = 0;
        let debit = 0;
        let credit = 0;

        $('#transaction_type_master_id').change(function() {
            // console.log($(this).val());
            $('#voucher_type_id').html('');
            $('#voucher_type_id').append('<option value="">Please Select</option>');
            $.ajax({
                url: "{{ url('api/get_voucher_types') }}" + '/' + $(this).val(),
                type: 'GET',
                success: function(response) {
                    console.log('response', response)
                    Object.keys(response.data).forEach(function(key) {
                        $('#voucher_type_id').append('<option value="' + response
                            .data[key]
                            .id + '">' + response.data[key].name + '</option>');
                    });
                    // var optionHtml = '<option value="' + response.data.id + '">' + response
                    //     .data.name + '</option>';
                    // var selectElement = $('#' + clickedLabel);
                    // selectElement.append(optionHtml);
                },
                error: function(xhr, status, error) {
                    // Handle error response
                    console.error(xhr.responseText);
                    // Optionally, display an error message
                }
            });
        })

        $('#voucher_type_id').change(function() {
            $('#account_id').html('');
            $('#account_id').append('<option value="">Please Select</option>');
            $('#party_id').html('');
            $('#party_id').append('<option value="">Please Select</option>');

            var voucher_type_id = $(this).val();

            $.ajax({
                url: "{{ url('api/get_accounts') }}",
                type: 'POST',
                data: {
                    voucher_type_id: voucher_type_id,
                },
                success: function(response) {
                    console.log('response', response)
                    Object.keys(response.data.from_account).forEach(function(key) {
                        $('#account_id').append('<option value="' + response
                            .data.from_account[key]
                            .id + '">' + response.data.from_account[key].name +
                            '</option>');
                    });
                    Object.keys(response.data.to_account).forEach(function(key) {
                        $('#party_id').append('<option value="' + response
                            .data.to_account[key]
                            .id + '">' + response.data.to_account[key].name +
                            '</option>');
                    });
                },
                error: function(xhr, status, error) {
                    // Handle error response
                    console.error(xhr.responseText);
                    // Optionally, display an error message
                }
            });
        })

        function addRowWithValues(account_id) {
            let row = '<tr>' +
                '<td class="text-nowrap">' + (rowReceivableCounter + 1) +
                '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('account_id[]', dropdownOptions
                    .chart_of_accounts, account_id) +
                '</td>' +
                // '<td class="text-nowrap">' + createDynamicDropdown('cost_center_id[]', dropdownOptions
                //     .cost_centers) + '</td>' +
                // '<td class="text-nowrap">' + createInput('text', 'debit_vc[]', '') + '</td>' +
                // '<td class="text-nowrap">' + createInput('text', 'credit_vc[]', '') + '</td>' +
                '<td class="text-nowrap td_debit">' + createInput('text', 'debit[]', '', 'input_debit') +
                '</td>' +
                '<td class="text-nowrap td_credit">' + createInput('text', 'credit[]', '', 'input_credit') +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'narration[]', '', 'input_narration') +
                '</td>' +
                '</tr>';
            $('#receiveableTable tbody').append(row);
            rowReceivableCounter++;
        }

        $('#account_id').change(function() {
            var voucher_type_id = $('#voucher_type_id').val();
            var account_id = $('#account_id').val();

            addRowWithValues(account_id)
        })

        $('#party_id').change(function() {
            var voucher_type_id = $('#voucher_type_id').val();
            var party_id = $('#party_id').val();

            addRowWithValues(party_id)
        })

        function calculateDebit() {
            console.log('test')
            debit = 0;
            credit = 0;
            $('#receiveableTable > tbody  > tr').each(function(index, value) {
                console.log("input_debit", $(this).find('.input_debit').val());
                console.log("input_credit", parseFloat($(this).find('.input_credit').val()));
                if ($(this).find('.input_debit').val()) {
                    debit += parseFloat($(this).find('.input_debit').val());
                }
                if ($(this).find('.input_credit').val()) {
                    credit += parseFloat($(this).find('.input_credit').val());
                }
                // $('#BillGrossAmt').val(BillGrossAmount);
            });
            $('#total_debit').val(debit);
            $('#total_credit').val(credit);
            console.log('debit', debit);
            console.log('credit', credit);
            // $('#BillIncAmt').val(BillGrossAmount);
            // CalBillGST();
        }

        $(document).on('keyup', '.input_debit', function(e) {
            calculateDebit();
        })

        $(document).on('keyup', '.input_credit', function(e) {
            calculateDebit();
        })

        $('#summary_narration').keyup(function(e) {
            if ($('#manual_narration').is(':checked')) {
                console.log('true');
            } else {
                $('.input_narration').val($(this).val());
            }
        })

        $('#submitBtn').click(function() {
            if (debit == credit) {
                $('#myForm').submit();
            } else {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: 'Debit and Credit should be equal!',
                    showConfirmButton: false,
                    timer: 2500
                })
            }
        })

        const dropdownOptions = {
            chart_of_accounts: {!! json_encode($chart_of_accounts) !!},
            cost_centers: {!! json_encode($cost_centers) !!}
        };

        function createDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control">';
            options.forEach(option => {
                dropdown += '<option value="' + option + '">' + option + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createDynamicDropdown(name, options, selected_id = null) {
            console.log('selected_id', selected_id)
            let dropdown = '<select name="' + name + '" class="form-control">';
            dropdown += '<option value="">Select Account</option>';
            if (selected_id) {
                options.forEach(option => {
                    if (option.id == selected_id) {
                        dropdown += '<option selected value="' + option.id + '">' + option.name +
                            ' - ' + option.account_code + '</option>';
                    } else {
                        dropdown += '<option  value="' + option.id + '">' + option.name + ' - ' + option
                            .account_code + '</option>';
                    }
                });
            } else {
                options.forEach(option => {
                    dropdown += '<option value="' + option.id + '">' + option.name + ' - ' + option
                        .account_code + '</option>';
                });
            }
            dropdown += '</select>';
            return dropdown;
        }

        function createInput(type, name, placeholder, class_name = null) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '"value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                if (class_name) {
                    return '<input type="' + type + '" name="' + name +
                        '" class="form-control w-24 ' + class_name + '" placeholder="' +
                        placeholder + '">';
                } else {
                    return '<input type="' + type + '" name="' + name +
                        '" class="form-control w-24" placeholder="' +
                        placeholder + '">';
                }
            }
        }

        function addRowReceivable() {
            let row = '<tr>' +
                '<td class="text-nowrap">' + (rowReceivableCounter + 1) +
                '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('account_id[]', dropdownOptions
                    .chart_of_accounts) +
                '</td>' +
                // '<td class="text-nowrap">' + createDynamicDropdown('cost_center_id[]', dropdownOptions
                //     .cost_centers) + '</td>' +
                // '<td class="text-nowrap">' + createInput('text', 'debit_vc[]', '') + '</td>' +
                // '<td class="text-nowrap">' + createInput('text', 'credit_vc[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'debit[]', '', 'input_debit') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'credit[]', '', 'input_credit') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'narration[]', '', 'input_narration') +
                '</td>' +
                '</tr>';
            $('#receiveableTable tbody').append(row);
            rowReceivableCounter++;
        }

        $('#addRowReceivableButton').click(addRowReceivable);
    });
</script>
