@extends('layout.master')

@section('title')
    General Voucher-YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts/general-voucher') }}" class="breadcrumb--active">General Voucher</a>
@endsection
@section('content')
    {{-- <h2 class="intro-y fs-lg fw-medium mt-10">
    General Voucher
</h2> --}}
    <div class="intro-y d-flex align-items-center">
        <div class="d-flex align-items-center">
            <h2 class="intro-y fs-lg fw-medium mt-6">
                General Voucher
            </h2>
        </div>
        <div class="ms-auto mt-10">
            <button class="btn btn-primary dark-text-theme-10" type="button" data-bs-toggle="collapse"
                data-bs-target="#faq-accordion-collapse-1" aria-expanded="true" aria-controls="faq-accordion-collapse-1"> <i
                    data-feather="filter" class="w-4 h-4 me-3"></i> Filters
            </button>
        </div>
    </div>
    {{-- start filter --}}
    <div id="faq-accordion-collapse-1" class="accordion-collapse collapse show mt-5" aria-labelledby="faq-accordion-content-1"
        data-bs-parent="#faq-accordion-1">
        <div class="grid columns-12 gap-6 mt-5">
            <div class="intro-y g-col-12 g-col-lg-12">
                <!-- BEGIN: Form Layout -->
                <div class="intro-y box p-5">
                    <form method="GET" id="myForm" action="{{ url('/accounts/general-voucher') }}">
                        <div class="row">
                            <div class="col-md-4">
                                <div>
                                    <label for="filterBy" class="form-label">Select</label>
                                    <select name="filterBy" id="filterBy" class="form-control">
                                        <option value="" {{ request('filterBy') == '' ? 'selected' : '' }}>Select
                                        </option>
                                        <option value="voucher_no"
                                            {{ request('filterBy') == 'voucher_no' ? 'selected' : '' }}>Voucher Number
                                        </option>
                                        {{-- <option value="company_id"
                                            {{ request('filterBy') == 'company_id' ? 'selected' : '' }}>Company
                                        </option> --}}
                                        {{-- <option value="date" {{ request('filterBy') == 'date' ? 'selected' : '' }}>Voucher
                                            Date</option> --}}
                                        <option value="currency_id"
                                            {{ request('filterBy') == 'currency_id' ? 'selected' : '' }}>Currency</option>
                                        <option value="account_id"
                                            {{ request('filterBy') == 'account_id' ? 'selected' : '' }}>Account</option>
                                        <option value="cost_center_id"
                                            {{ request('filterBy') == 'cost_center_id' ? 'selected' : '' }}>Cost Center
                                        </option>
                                        <option value="narration"
                                            {{ request('filterBy') == 'narration' ? 'selected' : '' }}>Narration
                                        </option>
                                        <option value="cheque_number"
                                            {{ request('filterBy') == 'cheque_number' ? 'selected' : '' }}>Cheque Number
                                        </option>
                                        <option value="status_id"
                                            {{ request('filterBy') == 'status_id' ? 'selected' : '' }}>Status
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4" id="filterInput">
                                <label for="filterValue" class="form-label">Name</label>
                                <input type="text" name="filterValue" class="form-control"
                                    value="{{ request('filterValue') }}" placeholder="Enter Name or ID" name="name"
                                    aria-label="Enter Name">
                            </div>
                            <div class="col-md-4 d-none" id="currency_id">
                                <label>Currency</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Currency" id="currency_id" name="currency_id"
                                        class="select2 w-full">
                                        <option value="">Please Select Currency</option>
                                        <option {{ request('currency_id') == 1 ? 'selected' : '' }} value="1">PAK
                                            RUPEES</option>
                                        <option {{ request('currency_id') == 2 ? 'selected' : '' }} value="2">US
                                            DOLLAR</option>
                                        <option {{ request('currency_id') == 3 ? 'selected' : '' }} value="3">DIRHAM
                                        </option>
                                        <option {{ request('currency_id') == 4 ? 'selected' : '' }} value="4">POUND
                                        </option>
                                        <option {{ request('currency_id') == 5 ? 'selected' : '' }} value="5">EURO
                                        </option>
                                        <option {{ request('currency_id') == 6 ? 'selected' : '' }} value="6">BDT
                                        </option>
                                        <option {{ request('currency_id') == 7 ? 'selected' : '' }} value="7">OMANI
                                            RIYAL</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 d-none" id="account_id">
                                <label class="lbl_account_1">Account</label>
                                <div class="mt-2">
                                    <select id="account_id" name="account_id" class="select2 w-full">
                                        <option value="">Please Select Account</option>
                                        @foreach ($chart_of_accounts as $account)
                                            <option {{ request('account_id') == $account->id ? 'selected' : '' }}
                                                value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 d-none" id="status_id">
                                <label class="lbl_account_1">Status</label>
                                <div class="mt-2">
                                    <select id="status_id" name="status_id" class="select2 w-full">
                                        <option value="">Please Select Status</option>
                                        @foreach ($transaction_master_status as $status)
                                            <option {{ request('status_id') == $status->id ? 'selected' : '' }}
                                                value="{{ $status->id }}">{{ $status->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- {{ dd(request('filterValue')) }} --}}
                            <div class="col-md-4 d-none" id="cost_center_id">
                                <label>Cost Center</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Cost Center" id="cost_center_id" name="cost_center_id"
                                        class="select2 w-full">
                                        <option value="">Please Select Cost Center</option>
                                        @foreach ($cost_centers as $cost_center)
                                            <option {{ request('cost_center_id') == $cost_center->id ? 'selected' : '' }}
                                                value="{{ $cost_center->id }}">{{ $cost_center->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="date_filter" class="form-label">Date Filter</label>
                                <select name="date_filter" id="date_filter" class="form-control">
                                    <option value="" {{ request('date_filter') == '' ? 'selected' : '' }}>Select
                                    </option>
                                    <option value="today" {{ request('date_filter') == 'today' ? 'selected' : '' }}>Today
                                    </option>
                                    <option value="this_week"
                                        {{ request('date_filter') == 'this_week' ? 'selected' : '' }}>This Week</option>
                                    <option value="this_month"
                                        {{ request('date_filter') == 'this_month' ? 'selected' : '' }}>This Month</option>
                                    <option value="custom" {{ request('date_filter') == 'custom' ? 'selected' : '' }}>
                                        Custom</option>
                                </select>
                            </div>
                            <div class="col-md-4" id="customDateRange"
                                style="display: {{ request('date_filter') == 'custom' ? 'block' : 'none' }};">
                                <label for="date_from" class="form-label">From</label>
                                <input type="date" name="date_from" class="form-control"
                                    value="{{ request('date_from') }}">
                            </div>
                            <div class="col-md-4" id="customDateRangeTwo"
                                style="display: {{ request('date_filter') == 'custom' ? 'block' : 'none' }};">
                                <label for="date_to" class="form-label">To</label>
                                <input type="date" name="date_to" class="form-control"
                                    value="{{ request('date_to') }}">
                            </div>
                            <div class="col-md-4 mt-8">
                                <button type="submit" class="btn btn-sm btn-elevated-primary w-24">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <circle cx="11" cy="11" r="8" />
                                        <line x1="21" x2="16.65" y1="21" y2="16.65" />
                                    </svg>
                                    Search</button>
                                <a href="{{ url('/accounts/general-voucher') }}" type="button"
                                    class="btn btn-sm btn-elevated-danger w-24">
                                    {{-- <i data-feather="x"></i> --}}
                                    <!-- https://feathericons.dev/?search=x&iconset=feather -->
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <line x1="18" x2="6" y1="6" y2="18" />
                                        <line x1="6" x2="18" y1="6" y2="18" />
                                    </svg>
                                    Clear</a>
                            </div>
                    </form>
                </div>
            </div>
            <!-- END: Form Layout -->
        </div>
    </div>
    </div>
    {{-- end filter --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ url('accounts/general-voucher/add') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $transaction_master->firstItem() }} to
                {{ $transaction_master->lastItem() }} of {{ $transaction_master->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Voucher No</th>
                        <th>Main Account</th>
                        <th>Party Account</th>
                        <th>Cheque / Ref No</th>
                        <th>Cheque / Ref Date</th>
                        <th>Method</th>
                        <th>Amount</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($transaction_master as $index => $transaction)
                        <tr>
                            <td>{{ $transaction->id }}</td>
                            <td>{{ $transaction->date }}</td>
                            <td>{{ @$transaction->type->name }}</td>
                            <td>{{ @$transaction->voucher_no }}</td>
                            <td>{{ @$transaction->detail->first()->account->name }}</td>
                            <td>{{ @$transaction->detail->get(1)->account->name }}</td>
                            <td>{{ @$transaction->cheque_number }}</td>
                            <td>{{ @$transaction->cheque_date }}</td>
                            <td>{{ @$transaction->nature }}</td>
                            <td>{{ @$transaction->detail->sum('debit_lc') }}</td>
                            <td>{{ @$transaction->status_master->name }}</td>
                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ url('accounts/general-voucher/edit', $transaction->id) }}"
                                        class="btn btn-primary">Edit</a>
                                    <a href="{{ url('accounts/general-voucher/print', $transaction->id) }}"
                                        class="btn btn-primary">Print</a>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="grid columns-12 gap-6 mt-4">
                <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center">
                    <div class="d-flex d-md-block mx-auto text-gray-600">
                        <?php echo $transaction_master->appends(request()->query())->links('pagination::bootstrap-4'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {

            document.getElementById('date_filter').addEventListener('change', function() {
                var customDateRange = document.getElementById('customDateRange');
                var customDateRangeTwo = document.getElementById('customDateRangeTwo');
                if (this.value === 'custom') {
                    customDateRange.style.display = 'block';
                    customDateRangeTwo.style.display = 'block';
                } else {
                    customDateRange.style.display = 'none';
                    customDateRangeTwo.style.display = 'none';
                }
            });

            $('#filterBy').change(function() {
                var selectedOption = $(this).val();

                // Clear all input fields
                $('#filterInput input').val('');
                $('#currency_id select').val('');
                $('#account_id select').val('');
                $('#cost_center_id select').val('');

                // Hide all optional fields initially
                $('#filterInput').addClass('d-none');
                $('#currency_id').addClass('d-none');
                $('#account_id').addClass('d-none');
                $('#cost_center_id').addClass('d-none');

                // Show the appropriate field based on the selected option
                switch (selectedOption) {
                    case 'currency_id':
                        $('#currency_id').removeClass('d-none');
                        break;
                    case 'account_id':
                        $('#account_id').removeClass('d-none');
                        break;
                    case 'cost_center_id':
                        $('#cost_center_id').removeClass('d-none');
                        break;
                    case 'status_id':
                        $('#status_id').removeClass('d-none');
                        break;
                    default:
                        $('#filterInput').removeClass('d-none');
                        break;
                }
            }).trigger('change'); // Trigger change event on page load to set the correct state
        });
    </script>
@endsection